/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.EnvironmentConstants;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.resource.DelegateSynchronizationResource;
import com.ibm.cics.server.API;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.ResourceUnavailableException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public abstract class SynchronizationResource
extends API
implements Serializable {
    private DelegateSynchronizationResource delegate;
    private static final long serialVersionUID = -4417976934390189065L;

    public SynchronizationResource() {
        this.delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateSynchronizationResource();
    }

    protected SynchronizationResource(DelegateSynchronizationResource delegate) {
        this.delegate = delegate;
    }

    protected DelegateSynchronizationResource getDelegate() {
        return this.delegate;
    }

    protected void dequeue(byte[] data) throws LengthErrorException {
        if (data != null && data.length != 0) {
            try {
                this.getDelegate().dequeue(data, 0);
            }
            catch (DelegateError err) {
                switch (err.getCode()) {
                    case LENGTH_ERROR: {
                        throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                    }
                }
                throw new RuntimeException(err.getMessage(), err);
            }
        } else {
            throw new LengthErrorException("invalid dequeue address");
        }
    }

    protected void dequeue(String name) throws LengthErrorException {
        byte[] data;
        try {
            data = name.getBytes(EnvironmentConstants.env.getLocalCCSID());
        }
        catch (UnsupportedEncodingException e) {
            data = name.getBytes();
        }
        if (data != null && data.length != 0) {
            try {
                this.getDelegate().dequeue(data, data.length);
            }
            catch (DelegateError err) {
                switch (err.getCode()) {
                    case LENGTH_ERROR: {
                        throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                    }
                }
                throw new RuntimeException(err.getMessage(), err);
            }
        } else {
            throw new LengthErrorException("invalid dequeue name");
        }
    }

    protected void enqueue(byte[] data, boolean suspend) throws ResourceUnavailableException, LengthErrorException {
        if (data != null && data.length != 0) {
            try {
                this.getDelegate().enqueue(data, 0, suspend);
            }
            catch (DelegateError err) {
                switch (err.getCode()) {
                    case LENGTH_ERROR: {
                        throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                    }
                    case RESOURCE_UNAVAILABLE: {
                        throw new ResourceUnavailableException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                    }
                }
                throw new RuntimeException(err.getMessage(), err);
            }
        } else {
            throw new LengthErrorException("invalid enqueue address");
        }
    }

    protected void enqueue(String name, boolean suspend) throws ResourceUnavailableException, LengthErrorException {
        byte[] data;
        try {
            data = name.getBytes(EnvironmentConstants.env.getLocalCCSID());
        }
        catch (UnsupportedEncodingException e) {
            data = name.getBytes();
        }
        if (data != null && data.length != 0) {
            try {
                this.getDelegate().enqueue(data, data.length, suspend);
            }
            catch (DelegateError err) {
                switch (err.getCode()) {
                    case LENGTH_ERROR: {
                        throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                    }
                    case RESOURCE_UNAVAILABLE: {
                        throw new ResourceUnavailableException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                    }
                }
                throw new RuntimeException(err.getMessage(), err);
            }
        } else {
            throw new LengthErrorException("invalid enqueue name");
        }
    }

    public String getDescription() {
        return this.getDelegate().getDescription();
    }

    public void setDescription(String description) {
        this.getDelegate().setDescription(description);
    }
}

