/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateDataHolder;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.resource.DelegateResource;
import com.ibm.cics.delegate.resource.queue.DelegateTDQ;
import com.ibm.cics.server.CicsError;
import com.ibm.cics.server.DataHolder;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.ISCInvalidRequestException;
import com.ibm.cics.server.InvalidQueueIdException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NoSpaceException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.NotOpenException;
import com.ibm.cics.server.QueueBusyException;
import com.ibm.cics.server.QueueZeroException;
import com.ibm.cics.server.RemotableResource;

@InjectLogging(isEnabled=false)
public class TDQ
extends RemotableResource {
    private static final long serialVersionUID = -1610563867982428214L;
    private static final Logger cicsLog = LoggerFactory.getLogger(TDQ.class);

    @InjectLogging
    public TDQ() {
        super((DelegateResource)DelegateFactoryLoader.getDelegateFactory().createDelegateTDQ());
        cicsLog.logEntry("<init>");
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    public TDQ(String name) {
        super((DelegateResource)DelegateFactoryLoader.getDelegateFactory().createDelegateTDQ());
        cicsLog.logEntry("<init>", new Object[]{name});
        this.setName(name);
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    public void delete() throws IOErrorException, ISCInvalidRequestException, NotAuthorisedException, InvalidQueueIdException, InvalidSystemIdException {
        cicsLog.logEntry("delete");
        try {
            ((DelegateTDQ)this.getDelegate()).delete();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case IO_ERROR: {
                    throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ISC_INVALID_REQUEST: {
                    throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_QUEUE_ID: {
                    throw new InvalidQueueIdException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_SYSTEM_ID: {
                    throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("delete");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void readData(DataHolder dataHolder) throws IOErrorException, ISCInvalidRequestException, LengthErrorException, NotAuthorisedException, NotOpenException, InvalidQueueIdException, QueueZeroException, InvalidSystemIdException {
        cicsLog.logEntry("readData", new Object[]{dataHolder});
        try {
            void holder;
            DelegateDataHolder delegateDataHolder = holder.getDelegate();
            ((DelegateTDQ)this.getDelegate()).readData(delegateDataHolder);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case IO_ERROR: {
                    throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ISC_INVALID_REQUEST: {
                    throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case NOT_OPEN: {
                    throw new NotOpenException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_QUEUE_ID: {
                    throw new InvalidQueueIdException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_SYSTEM_ID: {
                    throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case QUEUE_BUSY: {
                    throw new CicsError("QueueBusyException unexpected");
                }
                case QUEUE_ZERO: {
                    throw new QueueZeroException(err.getMessage(), err.getResp2(), err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("readData");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void readDataConditional(DataHolder dataHolder) throws IOErrorException, ISCInvalidRequestException, LengthErrorException, NotAuthorisedException, NotOpenException, QueueBusyException, InvalidQueueIdException, QueueZeroException, InvalidSystemIdException {
        cicsLog.logEntry("readDataConditional", new Object[]{dataHolder});
        try {
            void holder;
            DelegateDataHolder delegateDataHolder = holder.getDelegate();
            ((DelegateTDQ)this.getDelegate()).readDataConditional(delegateDataHolder);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case IO_ERROR: {
                    throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ISC_INVALID_REQUEST: {
                    throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case NOT_OPEN: {
                    throw new NotOpenException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_QUEUE_ID: {
                    throw new InvalidQueueIdException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_SYSTEM_ID: {
                    throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case QUEUE_BUSY: {
                    throw new QueueBusyException(err.getMessage(), err.getResp2(), err);
                }
                case QUEUE_ZERO: {
                    throw new QueueZeroException(err.getMessage(), err.getResp2(), err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("readDataConditional");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void writeData(byte[] byArray) throws IOErrorException, ISCInvalidRequestException, LengthErrorException, NoSpaceException, NotAuthorisedException, NotOpenException, InvalidSystemIdException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("writeData", new Object[]{byArray});
        }
        try {
            void data;
            ((DelegateTDQ)this.getDelegate()).writeData((byte[])data);
        }
        catch (DelegateError err) {
            TDQ.throwWriteJCICSException(err);
        }
        cicsLog.logExit("writeData");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void writeString(String string) throws IOErrorException, ISCInvalidRequestException, LengthErrorException, NoSpaceException, NotAuthorisedException, NotOpenException, InvalidSystemIdException {
        cicsLog.logEntry("writeString", new Object[]{string});
        try {
            void data;
            ((DelegateTDQ)this.getDelegate()).writeString((String)data);
        }
        catch (DelegateError err) {
            TDQ.throwWriteJCICSException(err);
        }
        cicsLog.logExit("writeString");
    }

    private static void throwWriteJCICSException(DelegateError err) throws IOErrorException, ISCInvalidRequestException, LengthErrorException, NoSpaceException, NotAuthorisedException, NotOpenException, InvalidSystemIdException {
        switch (err.getCode()) {
            case IO_ERROR: {
                throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case ISC_INVALID_REQUEST: {
                throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case NOT_AUTHORISED: {
                throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
            }
            case NO_SPACE: {
                throw new NoSpaceException(err.getMessage(), err.getResp2(), err);
            }
            case NOT_OPEN: {
                throw new NotOpenException(err.getMessage(), err.getResp2(), err);
            }
            case INVALID_SYSTEM_ID: {
                throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case LENGTH_ERROR: {
                throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
        }
        DelegateErrorHandler.handleUncheckedError(err);
    }
}

