/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateDataHolder;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.resource.DelegateResource;
import com.ibm.cics.delegate.resource.queue.DelegateTSQ;
import com.ibm.cics.server.CicsError;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.ISCInvalidRequestException;
import com.ibm.cics.server.InvalidQueueIdException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.ItemErrorException;
import com.ibm.cics.server.ItemHolder;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NoSpaceException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.RemotableResource;
import com.ibm.cics.server.TSQType;

@InjectLogging(isEnabled=false)
public class TSQ
extends RemotableResource {
    private static final long serialVersionUID = 6275748093699813383L;
    protected TSQType type;
    private static final Logger cicsLog = LoggerFactory.getLogger(TSQ.class);

    @InjectLogging
    public TSQ() {
        super((DelegateResource)DelegateFactoryLoader.getDelegateFactory().createDelegateTSQ());
        cicsLog.logEntry("<init>");
        this.type = TSQType.AUXILIARY;
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    public TSQ(String name) {
        super((DelegateResource)DelegateFactoryLoader.getDelegateFactory().createDelegateTSQ());
        cicsLog.logEntry("<init>", new Object[]{name});
        this.type = TSQType.AUXILIARY;
        this.setName(name);
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    public void delete() throws InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, InvalidQueueIdException, InvalidSystemIdException {
        cicsLog.logEntry("delete");
        try {
            ((DelegateTSQ)this.getDelegate()).delete();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case IO_ERROR: {
                    throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ISC_INVALID_REQUEST: {
                    throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_QUEUE_ID: {
                    throw new InvalidQueueIdException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_SYSTEM_ID: {
                    throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("delete");
    }

    @Override
    @InjectLogging
    public String getName() {
        cicsLog.logEntry("getName");
        String string = ((DelegateTSQ)this.getDelegate()).getName();
        cicsLog.logExit("getName", new Object[]{string});
        return string;
    }

    @InjectLogging
    public byte[] getQueueName() {
        cicsLog.logEntry("getQueueName");
        byte[] byArray = ((DelegateTSQ)this.getDelegate()).getQueueName();
        cicsLog.logExit("getQueueName", new Object[]{byArray});
        return byArray;
    }

    @InjectLogging
    public TSQType getType() {
        cicsLog.logEntry("getType");
        TSQType tSQType = this.type;
        cicsLog.logExit("getType", new Object[]{tSQType});
        return tSQType;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public int readItem(int n, ItemHolder itemHolder) throws InvalidRequestException, IOErrorException, ISCInvalidRequestException, ItemErrorException, LengthErrorException, NotAuthorisedException, InvalidQueueIdException, InvalidSystemIdException {
        int itemNumber;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("readItem", new Object[]{new Integer(n), itemHolder});
        }
        try {
            void item;
            void holder;
            DelegateDataHolder delegateHolder = holder.getDelegate();
            itemNumber = ((DelegateTSQ)this.getDelegate()).readItem((int)item, delegateHolder);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case IO_ERROR: {
                    throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ISC_INVALID_REQUEST: {
                    throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ITEM_ERROR: {
                    throw new ItemErrorException(err.getMessage(), err.getResp2(), err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_QUEUE_ID: {
                    throw new InvalidQueueIdException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_SYSTEM_ID: {
                    throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
            int n2 = 0;
            if (cicsLog.shouldTrace(LogType.EXIT)) {
                int n3 = n2;
                cicsLog.logExit("readItem", new Object[]{new Integer(n3)});
                n2 = n3;
            }
            return n2;
        }
        int n4 = itemNumber;
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            int n5 = n4;
            cicsLog.logExit("readItem", new Object[]{new Integer(n5)});
            n4 = n5;
        }
        return n4;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public int readNextItem(ItemHolder itemHolder) throws InvalidRequestException, IOErrorException, ISCInvalidRequestException, ItemErrorException, LengthErrorException, NotAuthorisedException, InvalidQueueIdException, InvalidSystemIdException {
        int itemNumber;
        cicsLog.logEntry("readNextItem", new Object[]{itemHolder});
        try {
            void holder;
            DelegateDataHolder delegateHolder = holder.getDelegate();
            itemNumber = ((DelegateTSQ)this.getDelegate()).readNextItem(delegateHolder);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case IO_ERROR: {
                    throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ISC_INVALID_REQUEST: {
                    throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ITEM_ERROR: {
                    throw new ItemErrorException(err.getMessage(), err.getResp2(), err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_QUEUE_ID: {
                    throw new InvalidQueueIdException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_SYSTEM_ID: {
                    throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
            int n = 0;
            if (cicsLog.shouldTrace(LogType.EXIT)) {
                int n2 = n;
                cicsLog.logExit("readNextItem", new Object[]{new Integer(n2)});
                n = n2;
            }
            return n;
        }
        int n = itemNumber;
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            int n3 = n;
            cicsLog.logExit("readNextItem", new Object[]{new Integer(n3)});
            n = n3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void rewriteItem(int n, byte[] byArray) throws InvalidRequestException, IOErrorException, ISCInvalidRequestException, ItemErrorException, LengthErrorException, NotAuthorisedException, InvalidQueueIdException, InvalidSystemIdException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("rewriteItem", new Object[]{new Integer(n), byArray});
        }
        try {
            void data;
            void item;
            ((DelegateTSQ)this.getDelegate()).rewriteItem((int)item, (byte[])data);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case IO_ERROR: {
                    throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ISC_INVALID_REQUEST: {
                    throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ITEM_ERROR: {
                    throw new ItemErrorException(err.getMessage(), err.getResp2(), err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_QUEUE_ID: {
                    throw new InvalidQueueIdException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_SYSTEM_ID: {
                    throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NO_SPACE: {
                    throw new CicsError("NoSpaceException unexpected");
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("rewriteItem");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void rewriteItemConditional(int n, byte[] byArray) throws InvalidRequestException, IOErrorException, ISCInvalidRequestException, ItemErrorException, LengthErrorException, NoSpaceException, NotAuthorisedException, InvalidQueueIdException, InvalidSystemIdException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("rewriteItemConditional", new Object[]{new Integer(n), byArray});
        }
        try {
            void data;
            void item;
            ((DelegateTSQ)this.getDelegate()).rewriteItemConditional((int)item, (byte[])data);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case IO_ERROR: {
                    throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ISC_INVALID_REQUEST: {
                    throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ITEM_ERROR: {
                    throw new ItemErrorException(err.getMessage(), err.getResp2(), err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_QUEUE_ID: {
                    throw new InvalidQueueIdException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_SYSTEM_ID: {
                    throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NO_SPACE: {
                    throw new CicsError("NoSpaceException unexpected");
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("rewriteItemConditional");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectLogging
    public void setName(String string) throws NullPointerException {
        void name;
        cicsLog.logEntry("setName", new Object[]{string});
        ((DelegateTSQ)this.getDelegate()).setName((String)name);
        cicsLog.logExit("setName");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setQueueName(byte[] byArray) throws NullPointerException {
        void queueName;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("setQueueName", new Object[]{byArray});
        }
        ((DelegateTSQ)this.getDelegate()).setQueueName((byte[])queueName);
        cicsLog.logExit("setQueueName");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setType(TSQType tSQType) {
        void type;
        cicsLog.logEntry("setType", new Object[]{tSQType});
        if (type == null) {
            throw new NullPointerException("TSQType 'type' is null");
        }
        this.type = type;
        ((DelegateTSQ)this.getDelegate()).setQueueTypeHashCode(type.hashCode());
        cicsLog.logExit("setType");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public int writeItem(byte[] byArray) throws InvalidRequestException, IOErrorException, ISCInvalidRequestException, ItemErrorException, LengthErrorException, NotAuthorisedException, InvalidSystemIdException {
        int assignedItemNumber;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("writeItem", new Object[]{byArray});
        }
        try {
            void data;
            assignedItemNumber = ((DelegateTSQ)this.getDelegate()).writeItem((byte[])data);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case IO_ERROR: {
                    throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ISC_INVALID_REQUEST: {
                    throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ITEM_ERROR: {
                    throw new ItemErrorException(err.getMessage(), err.getResp2(), err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_SYSTEM_ID: {
                    throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NO_SPACE: {
                    throw new CicsError("NoSpaceException unexpected");
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
            int n = 0;
            if (cicsLog.shouldTrace(LogType.EXIT)) {
                int n2 = n;
                cicsLog.logExit("writeItem", new Object[]{new Integer(n2)});
                n = n2;
            }
            return n;
        }
        int n = assignedItemNumber;
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            int n3 = n;
            cicsLog.logExit("writeItem", new Object[]{new Integer(n3)});
            n = n3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public int writeString(String string) throws InvalidRequestException, IOErrorException, ISCInvalidRequestException, ItemErrorException, LengthErrorException, NotAuthorisedException, InvalidSystemIdException {
        int assignedItemNumber;
        cicsLog.logEntry("writeString", new Object[]{string});
        try {
            void data;
            assignedItemNumber = ((DelegateTSQ)this.getDelegate()).writeString((String)data);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case IO_ERROR: {
                    throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ISC_INVALID_REQUEST: {
                    throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ITEM_ERROR: {
                    throw new ItemErrorException(err.getMessage(), err.getResp2(), err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_SYSTEM_ID: {
                    throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NO_SPACE: {
                    throw new CicsError("TSQ.writeString: NoSpaceException unexpected");
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
            int n = 0;
            if (cicsLog.shouldTrace(LogType.EXIT)) {
                int n2 = n;
                cicsLog.logExit("writeString", new Object[]{new Integer(n2)});
                n = n2;
            }
            return n;
        }
        int n = assignedItemNumber;
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            int n3 = n;
            cicsLog.logExit("writeString", new Object[]{new Integer(n3)});
            n = n3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public int writeItemConditional(byte[] byArray) throws InvalidRequestException, IOErrorException, ISCInvalidRequestException, ItemErrorException, LengthErrorException, NoSpaceException, NotAuthorisedException, InvalidSystemIdException {
        int assignedItemNumber;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("writeItemConditional", new Object[]{byArray});
        }
        try {
            void data;
            assignedItemNumber = ((DelegateTSQ)this.getDelegate()).writeItemConditional((byte[])data);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case IO_ERROR: {
                    throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ISC_INVALID_REQUEST: {
                    throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ITEM_ERROR: {
                    throw new ItemErrorException(err.getMessage(), err.getResp2(), err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_SYSTEM_ID: {
                    throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NO_SPACE: {
                    throw new CicsError("TSQ.writeString: NoSpaceException unexpected");
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
            int n = 0;
            if (cicsLog.shouldTrace(LogType.EXIT)) {
                int n2 = n;
                cicsLog.logExit("writeItemConditional", new Object[]{new Integer(n2)});
                n = n2;
            }
            return n;
        }
        int n = assignedItemNumber;
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            int n3 = n;
            cicsLog.logExit("writeItemConditional", new Object[]{new Integer(n3)});
            n = n3;
        }
        return n;
    }
}

