/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.CICSThreadLocalManager;
import com.ibm.cics.common.EnvironmentConstants;
import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateApplicationContext;
import com.ibm.cics.delegate.DelegateChannel;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.DelegateOwner;
import com.ibm.cics.delegate.DelegatePrincipalFacility;
import com.ibm.cics.delegate.DelegateRetrievedData;
import com.ibm.cics.delegate.DelegateTask;
import com.ibm.cics.delegate.DelegateTaskStartReason;
import com.ibm.cics.delegate.DelegateTransactionWorkArea;
import com.ibm.cics.delegate.DelegateUnitOfWork;
import com.ibm.cics.delegate.DelegateVersion;
import com.ibm.cics.delegate.OwnedDelegate;
import com.ibm.cics.delegate.jdbc.DelegateApplicationReturnCode;
import com.ibm.cics.delegate.terminal.DelegateTerminalPrincipalFacility;
import com.ibm.cics.server.API;
import com.ibm.cics.server.ApplicationContext;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.ChannelFactory;
import com.ibm.cics.server.ContainerIterator;
import com.ibm.cics.server.ConversationPrincipalFacility;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.DelegateOwnerAdapter;
import com.ibm.cics.server.EndOfDataException;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidRetrieveOptionException;
import com.ibm.cics.server.InvalidTerminalIdException;
import com.ibm.cics.server.IsCICS;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.RetrieveBits;
import com.ibm.cics.server.RetrievedData;
import com.ibm.cics.server.RetrievedDataHolder;
import com.ibm.cics.server.RolledBackException;
import com.ibm.cics.server.StartCode;
import com.ibm.cics.server.TWAHolder;
import com.ibm.cics.server.Terminal;
import com.ibm.cics.server.TerminalOutputStream;
import com.ibm.cics.server.TerminalPrincipalFacility;
import com.ibm.cics.server.Version;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.BitSet;

@InjectLogging(isEnabled=false)
public class Task
extends API
implements RetrieveBits {
    private static final Logger cicsLog = LoggerFactory.getLogger(Task.class);
    private static final String localCCSID = EnvironmentConstants.env.getLocalCCSID();
    private static final boolean taskTerminalOutputDisabled = EnvironmentConstants.env.isStandardTerminalOutputDisabled();
    private static boolean isServerJarVersionChecked = false;
    @Deprecated
    public static PrintWriter fixedOutForJVMLifetime;
    @Deprecated
    public static PrintWriter fixedErrForJVMLifetime;
    public static final byte FCI_START_NO_DATA = 0;
    public static final byte FCI_TASK_WITH_FACILITY = 1;
    public static final byte FCI_TRIGGERED_NO_FACILITY = 8;
    public static final byte FCI_START_WITH_DATA = 16;
    @Deprecated
    public PrintWriter err;
    @Deprecated
    public PrintWriter out;
    private DelegateTask delegateTask;
    private DelegateUnitOfWork delegateUnitOfWork;
    private DelegateTransactionWorkArea transactionWorkArea;
    DelegateOwnerAdapter<Task> delegatePrincipalFacilityAdapter;
    private DelegateTaskStartReason startReason;
    private ChannelFactory chanFactory;
    private Integer taskNumberInt;
    private byte[] originData;
    private byte[] transactionGroupID;
    private Thread taskThread;
    private static ThreadLocal<Task> theTask;

    @InjectLogging
    Task() {
        super(false);
        cicsLog.logEntry("<init>");
        try {
            this.delegateTask = DelegateFactoryLoader.getDelegateFactory().createDelegateTask();
        }
        catch (DelegateError error) {
            DelegateErrorHandler.handleUncheckedError(error);
        }
        this.checkCicsServerJarVersionIsAsExpected();
        this.delegateUnitOfWork = this.delegateTask.getUnitOfWork();
        this.transactionWorkArea = this.delegateTask.getTransactionWorkArea();
        this.startReason = this.delegateTask.getTaskStartReason();
        this.setTaskThread();
        Object principleFactilityObj = this.getPrincipalFacility();
        if (!taskTerminalOutputDisabled && principleFactilityObj instanceof Terminal) {
            cicsLog.logDebug("constructor", new Object[]{"principalFacility is a Terminal"});
            try {
                TerminalOutputStream outStream = new TerminalOutputStream((Terminal)principleFactilityObj);
                BufferedOutputStream BOS = new BufferedOutputStream(outStream);
                OutputStreamWriter OSW = new OutputStreamWriter((OutputStream)BOS, localCCSID);
                this.out = new PrintWriter((Writer)OSW, true);
                TerminalOutputStream errStream = new TerminalOutputStream((Terminal)principleFactilityObj);
                OutputStreamWriter errOSW = new OutputStreamWriter((OutputStream)errStream, localCCSID);
                this.err = new PrintWriter((Writer)errOSW, true);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (this.out == null) {
            if (fixedOutForJVMLifetime == null) {
                fixedOutForJVMLifetime = new PrintWriter(System.out, true);
            }
            this.out = fixedOutForJVMLifetime;
        }
        if (this.err == null) {
            if (fixedErrForJVMLifetime == null) {
                fixedErrForJVMLifetime = new PrintWriter(System.err, true);
            }
            this.err = fixedOutForJVMLifetime;
        }
        cicsLog.logExit("<init>");
    }

    private void checkCicsServerJarVersionIsAsExpected() {
        if (!isServerJarVersionChecked) {
            isServerJarVersionChecked = true;
            String minSupported = this.delegateTask.getMinSupportedCicsServerApiVersion();
            Version min = new Version(minSupported);
            String maxSupported = this.delegateTask.getMaxSupportedCicsServerApiVersion();
            Version max = new Version(maxSupported);
            try {
                Version currentServerApiVersion = Task.getCICSServerApiVersion();
                if (currentServerApiVersion.compareTo(min) < 0 || currentServerApiVersion.compareTo(max) > 0) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Version ");
                    msg.append(currentServerApiVersion.toString());
                    msg.append(" of com.ibm.cics.server.jar is outside the expected range of ");
                    msg.append(min.toString());
                    msg.append(" to ");
                    msg.append(max.toString());
                    msg.append(".");
                    msg.append(" This could indicate that an application has packaged the jar by mistake.");
                    cicsLog.logWarning("checkCicsServerJarVersionIsAsExpected", new Object[]{msg});
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void abend(String abcode) {
        cicsLog.logEntryExit("abend()", new Object[]{abcode});
        this.abend(abcode, true);
    }

    private void setTaskThread() {
        this.taskThread = Thread.currentThread();
    }

    public Thread getTaskThread() {
        return this.taskThread;
    }

    public void setDB2SQLJJDBCActive(boolean isActive) {
        this.delegateUnitOfWork.setDB2JDBCActive(isActive);
    }

    public boolean getDB2SQLJJDBCActive() {
        return this.delegateUnitOfWork.isDB2JDBCActive();
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void abend(String string, boolean bl) {
        void abcode;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("abend", new Object[]{string, new Boolean(bl)});
        }
        if (abcode == null) {
            throw new IllegalArgumentException("null abcode provided");
        }
        String abcodeLocal = abcode;
        if (abcodeLocal.length() < 4) {
            abcodeLocal = abcodeLocal.concat("    ");
        }
        if (abcodeLocal.length() > 4) {
            abcodeLocal = abcodeLocal.substring(0, 4);
        }
        try {
            void dump;
            this.delegateTask.abend(abcodeLocal, false, (boolean)dump);
        }
        catch (DelegateError error) {
            DelegateErrorHandler.handleUncheckedError(error);
        }
        cicsLog.logExit("abend");
    }

    @InjectLogging
    public void abend() {
        cicsLog.logEntry("abend");
        try {
            this.delegateTask.abend(null, false, false);
        }
        catch (DelegateError error) {
            DelegateErrorHandler.handleUncheckedError(error);
        }
        cicsLog.logExit("abend");
    }

    @InjectLogging
    public void commit() throws InvalidRequestException, RolledBackException {
        cicsLog.logEntry("commit");
        try {
            this.delegateUnitOfWork.commit();
        }
        catch (DelegateError error) {
            switch (error.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(error.getMessage(), error.getResp2(), error.getResponseCode(), (Throwable)error);
                }
                case ROLLED_BACK: {
                    throw new RolledBackException(error.getMessage(), error.getResp2(), error);
                }
            }
            DelegateErrorHandler.handleUncheckedError(error);
        }
        cicsLog.logExit("commit");
    }

    public void forceAbend(String abcode) {
        cicsLog.logEntryExit("forceAbend", new Object[]{abcode});
        this.forceAbend(abcode, true);
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void forceAbend(String string, boolean bl) {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("forceAbend", new Object[]{string, new Boolean(bl)});
        }
        try {
            void dump;
            void abcode;
            this.delegateTask.abend((String)abcode, true, (boolean)dump);
        }
        catch (DelegateError error) {
            DelegateErrorHandler.handleUncheckedError(error);
        }
        cicsLog.logExit("forceAbend");
    }

    public void forceAbend() {
        this.forceAbend(null, false);
    }

    public byte getFCI() {
        return this.startReason.getFCI();
    }

    public Object getPrincipalFacility() {
        Object result = null;
        DelegatePrincipalFacility dpf = this.delegateTask.getPrincipalFacility();
        if (dpf != null) {
            DelegateOwner delegateOwnerAdapter = dpf.getOwner();
            result = delegateOwnerAdapter == null ? Task.wrapDelegatePrincipalFacilityInJCICSObject(dpf) : Task.getDelegatePrincipalFacilityWrappingJCICSObject(dpf);
        }
        return result;
    }

    DelegateUnitOfWork getDelegateUnitOfWork() {
        return this.delegateUnitOfWork;
    }

    private static Object getDelegatePrincipalFacilityWrappingJCICSObject(DelegatePrincipalFacility delegatePrincipalFacility) {
        API result = null;
        DelegateOwner delegateOwner = delegatePrincipalFacility.getOwner();
        if (delegateOwner instanceof DelegateOwnerAdapter) {
            if (delegatePrincipalFacility.isDelegateConversationPF()) {
                ConversationPrincipalFacility convJcicsObject;
                DelegateOwnerAdapter delegateOwnerAdapter = (DelegateOwnerAdapter)delegateOwner;
                result = convJcicsObject = (ConversationPrincipalFacility)delegateOwnerAdapter.getOwner();
            } else {
                DelegateOwnerAdapter delegateOwnerAdapter = (DelegateOwnerAdapter)delegateOwner;
                TerminalPrincipalFacility termJcicsObject = (TerminalPrincipalFacility)delegateOwnerAdapter.getOwner();
                result = termJcicsObject;
            }
        }
        return result;
    }

    private static Object wrapDelegatePrincipalFacilityInJCICSObject(DelegatePrincipalFacility delegatePFToWrap) {
        API result;
        DelegatePrincipalFacility ownedDelegate = delegatePFToWrap;
        if (delegatePFToWrap.isDelegateConversationPF()) {
            ConversationPrincipalFacility convJcicsObject = new ConversationPrincipalFacility(delegatePFToWrap.getDelegateConversationPF());
            DelegateOwnerAdapter<ConversationPrincipalFacility> delegateOwnerAdapter = new DelegateOwnerAdapter<ConversationPrincipalFacility>(convJcicsObject);
            delegateOwnerAdapter.setDelegate((OwnedDelegate)ownedDelegate);
            result = convJcicsObject;
        } else if (delegatePFToWrap.isDelegateTerminalPF()) {
            TerminalPrincipalFacility termJcicsObject;
            DelegateTerminalPrincipalFacility principleTermDelegate = delegatePFToWrap.getDelegateTerminalPF();
            try {
                termJcicsObject = new TerminalPrincipalFacility(principleTermDelegate);
            }
            catch (InvalidTerminalIdException ex) {
                throw new RuntimeException("Unexpected terminal id error when creating principal terminal.", ex);
            }
            DelegateOwnerAdapter<TerminalPrincipalFacility> delegateOwnerAdapter = new DelegateOwnerAdapter<TerminalPrincipalFacility>(termJcicsObject);
            delegateOwnerAdapter.setDelegate((OwnedDelegate)ownedDelegate);
            result = termJcicsObject;
        } else {
            throw new RuntimeException("Unexpected object type " + delegatePFToWrap.getClass().getCanonicalName() + " returned from delegateTask.getPrincipalFacility()");
        }
        return result;
    }

    @Deprecated
    public String getQNAME() {
        return null;
    }

    @Deprecated
    public String getSTARTCODE() {
        return this.startReason.getStartCode();
    }

    public StartCode getStartCode() {
        return StartCode.fromShortCode(this.startReason.getStartCode());
    }

    protected int getThreadPosition() {
        return this.delegateTask.getThreadPosition();
    }

    public Channel getTransactionChannel() {
        DelegateChannel delegateChannel = this.delegateTask.getTransactionChannel();
        Channel jcicsChannel = DelegateOwnerAdapter.toJCICSChannel(delegateChannel);
        return jcicsChannel;
    }

    @InjectLogging
    public Channel getCurrentChannel() {
        cicsLog.logEntry("getCurrentChannel");
        Channel currentChannel = null;
        DelegateChannel delegateChannel = this.delegateTask.getCurrentChannel();
        if (delegateChannel != null) {
            currentChannel = DelegateOwnerAdapter.toJCICSChannel(delegateChannel);
        }
        Channel channel = currentChannel;
        cicsLog.logExit("getCurrentChannel", new Object[]{channel});
        return channel;
    }

    public Channel createChannel(String channelName) throws ChannelErrorException {
        return this.createChannel(channelName, 16);
    }

    public Channel createChannel(String channelName, int listSize) throws ChannelErrorException {
        if (this.chanFactory == null) {
            this.chanFactory = new ChannelFactory(this.getCurrentChannel());
        }
        return this.chanFactory.createChannel(channelName, listSize);
    }

    void removeChannel(Channel channel) {
        this.chanFactory.remove(channel);
    }

    public Channel getChannel(String channelName) {
        if (this.chanFactory == null) {
            this.chanFactory = new ChannelFactory(this.getCurrentChannel());
        }
        return this.chanFactory.getChannel(channelName);
    }

    protected Channel returnChannel(String channelName) throws ChannelErrorException {
        return this.chanFactory.returnChannel(channelName);
    }

    @Deprecated
    @InjectLogging
    public ContainerIterator containerIterator() {
        cicsLog.logEntry("containerIterator");
        ContainerIterator result = null;
        Channel currentChannel = this.getCurrentChannel();
        if (currentChannel != null) {
            result = currentChannel.containerIterator();
        }
        ContainerIterator containerIterator = result;
        cicsLog.logExit("containerIterator", new Object[]{containerIterator});
        return containerIterator;
    }

    @InjectLogging
    public static Task getTask() {
        cicsLog.logEntry("getTask");
        Task t = theTask.get();
        if (t == null) {
            cicsLog.logDebug("getTask", new Object[]{"Task is null"});
            if (EnvironmentConstants.env.isThreadPoolActive()) {
                IsCICS.getApiStatus(true);
                t = theTask.get();
            }
            if (t == null) {
                t = new Task();
                theTask.set(t);
            }
        } else {
            cicsLog.logDebug("getTask", new Object[]{"Task is not null: ", t});
        }
        Task task = t;
        cicsLog.logExit("getTask", new Object[]{task});
        return task;
    }

    public int getTaskNumber() {
        return this.delegateTask.getTaskNumber();
    }

    public Integer getTaskNumberInteger() {
        if (this.taskNumberInt == null) {
            this.taskNumberInt = new Integer(this.delegateTask.getTaskNumber());
        }
        return this.taskNumberInt;
    }

    public String getTransactionName() {
        return this.delegateUnitOfWork.getTransactionName();
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void getTWA(TWAHolder tWAHolder) {
        byte[] contents;
        void holder;
        cicsLog.logEntry("getTWA", new Object[]{tWAHolder});
        if (holder == null) {
            throw new NullPointerException("null holder in Task.getTWA()");
        }
        try {
            contents = this.transactionWorkArea.getContents();
        }
        catch (DelegateError error) {
            DelegateErrorHandler.handleUncheckedError(error);
            cicsLog.logExit("getTWA");
            return;
        }
        holder.setValue(contents);
        cicsLog.logExit("getTWA");
    }

    public String getUSERID() throws InvalidRequestException {
        String userId;
        try {
            userId = this.delegateTask.getUserId();
        }
        catch (DelegateError error) {
            switch (error.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(error.getMessage(), error.getResp2(), error.getResponseCode(), (Throwable)error);
                }
            }
            DelegateErrorHandler.handleUncheckedError(error);
            return null;
        }
        cicsLog.logEvent("getUSERID", new Object[]{userId});
        return userId;
    }

    public String getProgramName() {
        return this.delegateTask.getProgramName();
    }

    public String getInvokingProgramName() {
        return this.startReason.getInvokingProgramName();
    }

    public ApplicationContext getApplicationContext() throws InvalidRequestException {
        DelegateApplicationContext context;
        try {
            context = this.delegateTask.getApplicationContext();
        }
        catch (DelegateError error) {
            switch (error.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(error.getMessage(), error.getResp2(), error.getResponseCode(), (Throwable)error);
                }
            }
            DelegateErrorHandler.handleUncheckedError(error);
            return null;
        }
        DelegateVersion delegateVersion = context.getVersion();
        ApplicationContext jcicsAppContext = new ApplicationContext(context.getOperation(), context.getApplication(), context.getPlatform(), delegateVersion.getMajorVersion(), delegateVersion.getMinorVersion(), delegateVersion.getMicroVersion());
        cicsLog.logEvent("getApplicationContext", new Object[]{jcicsAppContext});
        return jcicsAppContext;
    }

    @InjectLogging
    static void resetTask() {
        cicsLog.logEntry("resetTask");
        Task currentTask = theTask.get();
        if (currentTask != null) {
            cicsLog.logDebug("resetTask", new Object[]{"Task object = ", currentTask});
            theTask.remove();
        } else {
            cicsLog.logDebug("resetTask", new Object[]{"Task object = null"});
        }
        cicsLog.logExit("resetTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieve(BitSet whatToRetrieve, RetrievedDataHolder holder) throws EndOfDataException, InvalidRequestException, InvalidRetrieveOptionException, IOErrorException, LengthErrorException, RecordNotFoundException {
        boolean isDataRequired = false;
        boolean isTransIdRequired = false;
        boolean isTermIdRequired = false;
        boolean isQueueNameRequired = false;
        isDataRequired = whatToRetrieve.get(0);
        isTransIdRequired = whatToRetrieve.get(1);
        isTermIdRequired = whatToRetrieve.get(2);
        isQueueNameRequired = whatToRetrieve.get(3);
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("retrieve", new Object[]{" isDataRequired", Boolean.toString(isDataRequired), " isTransIdRequired", Boolean.toString(isTransIdRequired), " isTermIdRequired", Boolean.toString(isTermIdRequired), " isQueueNameRequired", Boolean.toString(isQueueNameRequired)});
        }
        RetrievedData jcicsRetrievedData = new RetrievedData(null, null, null, null);
        DelegateRetrievedData nativeHolder = jcicsRetrievedData.getDelegate();
        try {
            this.startReason.retrieve(isDataRequired, isTransIdRequired, isTermIdRequired, isQueueNameRequired, nativeHolder);
            holder.setValue(jcicsRetrievedData);
        }
        catch (DelegateError error) {
            try {
                switch (error.getCode()) {
                    case END_OF_DATA: {
                        throw new EndOfDataException(error.getMessage(), error.getResp2(), error.getResponseCode(), (Throwable)error);
                    }
                    case INVALID_REQUEST: {
                        throw new InvalidRequestException(error.getMessage(), error.getResp2(), error.getResponseCode(), (Throwable)error);
                    }
                    case INVALID_RETRIEVE_OPTION: {
                        throw new InvalidRetrieveOptionException(error.getMessage(), error.getResp2(), error.getResponseCode(), (Throwable)error);
                    }
                    case IO_ERROR: {
                        throw new IOErrorException(error.getMessage(), error.getResp2(), error.getResponseCode(), (Throwable)error);
                    }
                    case LENGTH_ERROR: {
                        throw new LengthErrorException(error.getMessage(), error.getResp2(), error.getResponseCode(), (Throwable)error);
                    }
                    case RECORD_NOT_FOUND: {
                        throw new RecordNotFoundException(error.getMessage(), error.getResp2(), error);
                    }
                }
                DelegateErrorHandler.handleUncheckedError(error);
                holder.setValue(jcicsRetrievedData);
            }
            catch (Throwable throwable) {
                holder.setValue(jcicsRetrievedData);
                cicsLog.logExit("retrieve", new Object[]{nativeHolder});
                throw throwable;
            }
            cicsLog.logExit("retrieve", new Object[]{nativeHolder});
        }
        cicsLog.logExit("retrieve", new Object[]{nativeHolder});
    }

    public void rollback() throws InvalidRequestException {
        cicsLog.logEntryExit("rollback", new Object[0]);
        try {
            this.delegateUnitOfWork.rollback();
        }
        catch (DelegateError error) {
            switch (error.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(error.getMessage(), error.getResp2(), error.getResponseCode(), (Throwable)error);
                }
            }
            DelegateErrorHandler.handleUncheckedError(error);
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setTWA(byte[] byArray) throws InvalidRequestException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("setTWA", new Object[]{byArray});
        }
        try {
            void data;
            this.transactionWorkArea.setContents((byte[])data);
        }
        catch (DelegateError error) {
            switch (error.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(error.getMessage(), error.getResp2(), error.getResponseCode(), (Throwable)error);
                }
            }
            DelegateErrorHandler.handleUncheckedError(error);
        }
        cicsLog.logExit("setTWA");
    }

    public void setJTATranActive(boolean setJTATran) {
        cicsLog.logEntryExit("setJTATranActive", new Object[0]);
        this.delegateUnitOfWork.setJTATranActive(setJTATran);
    }

    protected void setOriginData(byte[] taskOriginData, byte[] transactionGroupID) {
        cicsLog.logEntryExit("setOriginData", new Object[]{taskOriginData, transactionGroupID});
        this.originData = taskOriginData;
        this.transactionGroupID = transactionGroupID;
    }

    protected byte[] getOriginData() {
        return this.originData;
    }

    protected byte[] getTransactionGroupID() {
        return this.transactionGroupID;
    }

    public String getThreadName() {
        return this.delegateTask.getThreadName();
    }

    public boolean isJTATranActive() {
        return this.delegateUnitOfWork.isJTATranActive();
    }

    public static void setFixedErrForJVMLifetime(PrintWriter newStdErr) {
        cicsLog.logEntryExit("setFixedErrForJVMLifetime", new Object[]{newStdErr});
        fixedErrForJVMLifetime = newStdErr;
    }

    public static PrintWriter getFixedErrForJVMLifetime() {
        return fixedErrForJVMLifetime;
    }

    public static void setFixedOutForJVMLifetime(PrintWriter newStdOut) {
        cicsLog.logEntryExit("setFixedOutForJVMLifetime", new Object[]{newStdOut});
        fixedOutForJVMLifetime = newStdOut;
    }

    public static PrintWriter getFixedOutForJVMLifetime() {
        return fixedOutForJVMLifetime;
    }

    public void setOut(PrintWriter newOut) {
        cicsLog.logEntryExit("setOut", new Object[]{newOut});
        this.out = newOut;
    }

    public PrintWriter getOut() {
        return this.out;
    }

    public void setErr(PrintWriter newErr) {
        cicsLog.logEntryExit("setOut", new Object[]{newErr});
        this.err = newErr;
    }

    public PrintWriter getErr() {
        return this.err;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Task (");
        str.append(Integer.toString(this.hashCode()));
        str.append(") ");
        if (this.delegateTask == null) {
            str.append("(no delegate task");
        } else {
            str.append(this.delegateTask.toString());
        }
        return str.toString();
    }

    protected DelegateApplicationReturnCode jdbcReset() {
        DelegateApplicationReturnCode rc = DelegateApplicationReturnCode.SUCCESS;
        if (this.delegateUnitOfWork != null) {
            rc = this.delegateUnitOfWork.jdbcReset();
        }
        cicsLog.logEntryExit("jdbcReset", new Object[]{rc});
        return rc;
    }

    static {
        theTask = CICSThreadLocalManager.createThreadLocal();
    }
}

