/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.CICSThreadLocalManager;
import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.PaddingUtils;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.web.DelegateAuthentication;
import com.ibm.cics.delegate.web.DelegateHostType;
import com.ibm.cics.delegate.web.DelegatePrivacy;
import com.ibm.cics.delegate.web.DelegateSSL;
import com.ibm.cics.delegate.web.DelegateTcpipInfo;
import com.ibm.cics.server.API;
import com.ibm.cics.server.CertificateInfo;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.Container;
import com.ibm.cics.server.ContainerErrorException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NonHttpDataException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.Task;
import com.ibm.cics.server.WebReceive;
import com.ibm.cics.server.internal.TidyUpOnTermination;
import com.ibm.cics.server.internal.WrapperHelper;

@InjectLogging(isEnabled=false)
public class TcpipRequest
extends API
implements TidyUpOnTermination {
    private static final Logger cicsLog = LoggerFactory.getLogger(TcpipRequest.class);
    public static final Integer NOTSET = -1;
    private static ThreadLocal<CertificateInfo> CInfo = CICSThreadLocalManager.createThreadLocal();
    private static final ThreadLocal<DelegateTcpipInfo> delegateThreadLocal = CICSThreadLocalManager.createThreadLocal();
    private static final ThreadLocal<WebReceive> WRecv = CICSThreadLocalManager.createThreadLocal();
    private static final ThreadLocal<TcpipRequest> _trq = CICSThreadLocalManager.createThreadLocal();
    private static final ThreadLocal<Integer> lastCertExtract = CICSThreadLocalManager.createThreadLocal();
    public static final int NOTAPPLIC = DelegateHostType.NOTAPPLIC.getValue();
    public static final int IPV4 = DelegateHostType.IPV4.getValue();
    public static final int IPV6 = DelegateHostType.IPV6.getValue();
    public static final int SSL = DelegateSSL.SSL.getValue();
    public static final int NOSSL = DelegateSSL.NOSSL.getValue();
    public static final int CLIENTAUTH = DelegateAuthentication.CLIENTAUTH.getValue();
    public static final int NOAUTHENTIC = DelegateAuthentication.NOAUTHENTIC.getValue();
    public static final int BASICAUTH = DelegateAuthentication.BASICAUTH.getValue();
    public static final int CERTIFICAUTH = DelegateAuthentication.CERTIFICAUTH.getValue();
    public static final int AUTOREGISTER = DelegateAuthentication.AUTOREGISTER.getValue();
    public static final int AUTOAUTH = DelegateAuthentication.AUTOAUTH.getValue();
    public static final int SUPPORTED = DelegatePrivacy.SUPPORTED.getValue();
    public static final int REQUIRED = DelegatePrivacy.REQUIRED.getValue();
    public static final int NOTSUPPORTED = DelegatePrivacy.NOTSUPPORTED.getValue();
    public static final int ATTLSAWARE = DelegateSSL.ATTLSAWARE.getValue();
    private static final int RESP2_NO_CURRENT_CHANNEL = 145;
    private static final int RESP2_CONTAINER_NAME_INVALID = 1;
    private static final int RESP2_CHANNEL_NAME_INVALID = 1;
    private static boolean registeredWithWrapper;

    @InjectLogging
    protected TcpipRequest() {
        cicsLog.logEntry("<init>");
        lastCertExtract.set(NOTSET);
        if (!registeredWithWrapper) {
            cicsLog.logEvent("constructor", new Object[]{"registering with Wrapper"});
            registeredWithWrapper = true;
            WrapperHelper.registerTerminator(this);
        }
        cicsLog.logExit("<init>");
    }

    private static DelegateTcpipInfo getDelegate() {
        if (delegateThreadLocal.get() == null) {
            delegateThreadLocal.set(DelegateFactoryLoader.getDelegateFactory().createDelegateTcpipInfo());
        }
        return delegateThreadLocal.get();
    }

    public static TcpipRequest getTcpipRequestInstance() {
        if (_trq.get() == null) {
            _trq.set(new TcpipRequest());
        }
        return _trq.get();
    }

    public CertificateInfo getCertificateInfo() throws InvalidRequestException {
        return this.getCertificateInfo(CertificateInfo.OWNER);
    }

    public CertificateInfo getCertificateInfo(int ownerIssuer) throws InvalidRequestException {
        if (CInfo.get() == null || lastCertExtract.get() != ownerIssuer) {
            CInfo.set(new CertificateInfo(ownerIssuer));
            lastCertExtract.set(ownerIssuer);
        }
        return CInfo.get();
    }

    public String getClientHostName() throws InvalidRequestException {
        String result = null;
        try {
            result = TcpipRequest.getDelegate().getClientHostName();
        }
        catch (DelegateError err) {
            TcpipRequest.processCommonDelegateError(err);
        }
        return result;
    }

    public String getServerHostName() throws InvalidRequestException {
        String result = null;
        try {
            result = TcpipRequest.getDelegate().getServerHostName();
        }
        catch (DelegateError err) {
            TcpipRequest.processCommonDelegateError(err);
        }
        return result;
    }

    public String getClientAddress() throws InvalidRequestException {
        String result = null;
        try {
            result = TcpipRequest.getDelegate().getClientAddress();
        }
        catch (DelegateError err) {
            TcpipRequest.processCommonDelegateError(err);
        }
        return result;
    }

    public String getServerAddress() throws InvalidRequestException {
        String result = null;
        try {
            result = TcpipRequest.getDelegate().getServerAddress();
        }
        catch (DelegateError err) {
            TcpipRequest.processCommonDelegateError(err);
        }
        return result;
    }

    public byte[] getClientHostAddress() throws InvalidRequestException {
        byte[] result = null;
        try {
            result = TcpipRequest.getDelegate().getClientHostAddress();
        }
        catch (DelegateError err) {
            TcpipRequest.processCommonDelegateError(err);
        }
        return result;
    }

    public byte[] getServerHostAddress() throws InvalidRequestException {
        byte[] result = null;
        try {
            result = TcpipRequest.getDelegate().getServerHostAddress();
        }
        catch (DelegateError err) {
            TcpipRequest.processCommonDelegateError(err);
        }
        return result;
    }

    public byte[] getClientHostAddress6() throws InvalidRequestException {
        byte[] result = null;
        try {
            result = TcpipRequest.getDelegate().getClientHostAddress6();
        }
        catch (DelegateError err) {
            TcpipRequest.processCommonDelegateError(err);
        }
        return result;
    }

    public byte[] getServerHostAddress6() throws InvalidRequestException {
        byte[] result = null;
        try {
            result = TcpipRequest.getDelegate().getServerHostAddress6();
        }
        catch (DelegateError err) {
            TcpipRequest.processCommonDelegateError(err);
        }
        return result;
    }

    public int getClientIpFamily() throws InvalidRequestException {
        int result = 0;
        try {
            result = TcpipRequest.getDelegate().getClientIpFamily();
        }
        catch (DelegateError err) {
            TcpipRequest.processCommonDelegateError(err);
        }
        return result;
    }

    public int getServerIpFamily() throws InvalidRequestException {
        int result = 0;
        try {
            result = TcpipRequest.getDelegate().getServerIpFamily();
        }
        catch (DelegateError err) {
            TcpipRequest.processCommonDelegateError(err);
        }
        return result;
    }

    public boolean isSSL() throws InvalidRequestException {
        boolean result = false;
        try {
            result = TcpipRequest.getDelegate().isSSL();
        }
        catch (DelegateError err) {
            TcpipRequest.processCommonDelegateError(err);
        }
        return result;
    }

    public boolean isClientAuth() throws InvalidRequestException {
        boolean result = false;
        try {
            result = TcpipRequest.getDelegate().isClientAuth();
        }
        catch (DelegateError err) {
            TcpipRequest.processCommonDelegateError(err);
        }
        return result;
    }

    public boolean isATTLSAware() throws InvalidRequestException {
        try {
            return TcpipRequest.getDelegate().isATTLSAware();
        }
        catch (DelegateError err) {
            TcpipRequest.processCommonDelegateError(err);
            return false;
        }
    }

    public String getTcpipService() throws InvalidRequestException {
        String result = null;
        try {
            result = TcpipRequest.getDelegate().getTcpipService();
        }
        catch (DelegateError err) {
            TcpipRequest.processCommonDelegateError(err);
        }
        return result;
    }

    public int getPortNumber() throws InvalidRequestException {
        int result = 0;
        try {
            result = TcpipRequest.getDelegate().getPortNumber();
        }
        catch (DelegateError err) {
            TcpipRequest.processCommonDelegateError(err);
        }
        return result;
    }

    public int getAuthenticate() throws InvalidRequestException {
        int result = 0;
        try {
            result = TcpipRequest.getDelegate().getAuthenticate();
        }
        catch (DelegateError err) {
            TcpipRequest.processCommonDelegateError(err);
        }
        return result;
    }

    public int getPrivacy() throws InvalidRequestException {
        int result = 0;
        try {
            result = TcpipRequest.getDelegate().getPrivacy();
        }
        catch (DelegateError err) {
            TcpipRequest.processCommonDelegateError(err);
        }
        return result;
    }

    public int getMaxDataLen() throws InvalidRequestException {
        int result = 0;
        try {
            result = TcpipRequest.getDelegate().getMaxDataLen();
        }
        catch (DelegateError err) {
            TcpipRequest.processCommonDelegateError(err);
        }
        return result;
    }

    public void setServerConvert() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        WRecv.get().setServerConvert();
    }

    public void setNoServerConvert() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        WRecv.get().setNoServerConvert();
    }

    public void setClientCodePage(String theCharacterset) {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        String characterset = theCharacterset;
        characterset = PaddingUtils.spacePad((String)characterset, (int)40);
        WRecv.get().setCharacterset(characterset);
    }

    public void setCharacterset(String theCharacterset) {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        String characterset = theCharacterset;
        characterset = PaddingUtils.spacePad((String)characterset, (int)40);
        WRecv.get().setCharacterset(characterset);
    }

    public void setHostCodePage(String theHostCodePage) {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        String hostCodePage = theHostCodePage;
        hostCodePage = PaddingUtils.spacePad((String)hostCodePage, (int)8);
        WRecv.get().setHostCodePage(hostCodePage);
    }

    public void setNoTruncate() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        WRecv.get().setNoTruncate();
    }

    public void setTruncate() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        WRecv.get().setTruncate();
    }

    public void setMaxLength(int maxLength) throws LengthErrorException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        if (maxLength < 1) {
            throw new LengthErrorException("maxLength not greater than 0");
        }
        WRecv.get().setMaxLength(maxLength);
    }

    public byte[] getContent(String theHostCodePage, String theCharacterset) throws InvalidRequestException, RecordNotFoundException, NonHttpDataException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        String hostCodePage = theHostCodePage;
        hostCodePage = PaddingUtils.spacePad((String)hostCodePage, (int)8);
        WRecv.get().setHostCodePage(hostCodePage);
        String characterset = theCharacterset;
        characterset = PaddingUtils.spacePad((String)characterset, (int)40);
        WRecv.get().setCharacterset(characterset);
        WRecv.get().setNonHttpDataExceptionNo();
        return WRecv.get().receive();
    }

    public byte[] getContent() throws InvalidRequestException, RecordNotFoundException, NonHttpDataException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        WRecv.get().setNonHttpDataExceptionNo();
        return WRecv.get().receive();
    }

    public Container getContentAsContainer(String targetContainer, String targetChannel) throws InvalidRequestException, RecordNotFoundException, ChannelErrorException, ContainerErrorException {
        Channel chan;
        String toContainer;
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        if ((toContainer = targetContainer) == null) {
            throw new ContainerErrorException("Null toContainer", 1);
        }
        String toChannel = targetChannel;
        if (toChannel == null) {
            throw new ChannelErrorException("Null toChannel", 1);
        }
        toContainer = PaddingUtils.spacePad((String)toContainer, (int)16);
        toChannel = PaddingUtils.spacePad((String)toChannel, (int)16);
        WRecv.get().receiveContainer(toContainer, toChannel);
        Task t = Task.getTask();
        if (t == null) {
            throw new InvalidRequestException("Task.getTask failed");
        }
        try {
            chan = t.createChannel(toChannel);
        }
        catch (Exception e) {
            chan = t.returnChannel(toChannel);
        }
        Container cont = chan.returnContainer(toContainer);
        cont.containerExistsInCICS();
        return cont;
    }

    public Container getContentAsContainer(String targetContainer) throws InvalidRequestException, RecordNotFoundException, ChannelErrorException, ContainerErrorException {
        String toContainer;
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        if ((toContainer = targetContainer) == null) {
            throw new ContainerErrorException("Null toContainer", 1);
        }
        toContainer = PaddingUtils.spacePad((String)toContainer, (int)16);
        Task t = Task.getTask();
        Channel chan = t.getCurrentChannel();
        if (chan == null) {
            throw new InvalidRequestException("No current channel", 145);
        }
        WRecv.get().receiveContainer(toContainer, chan.getName());
        Container cont = chan.returnContainer(chan.getName());
        cont.containerExistsInCICS();
        return cont;
    }

    public boolean isBodyComplete() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        boolean isComplete = WRecv.get().isBodyComplete();
        if (cicsLog.shouldTrace(LogType.ENTRYEXIT)) {
            cicsLog.logEntryExit("isBodyTruncated", new Object[]{Boolean.toString(isComplete)});
        }
        return isComplete;
    }

    public boolean isBodyTruncated() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        boolean isTruncated = WRecv.get().isBodyTruncated();
        if (cicsLog.shouldTrace(LogType.ENTRYEXIT)) {
            cicsLog.logEntryExit("isBodyTruncated", new Object[]{Boolean.toString(isTruncated)});
        }
        return isTruncated;
    }

    public boolean isBodyPartial() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        return WRecv.get().isBodyPartial();
    }

    public String getBodyCharset() throws InvalidRequestException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        return WRecv.get().getBodyCharset();
    }

    public String getMediaType() throws InvalidRequestException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        return WRecv.get().getMediaType();
    }

    @InjectLogging
    private static boolean ibmJVMTidyUp() {
        cicsLog.logEntry("ibmJVMTidyUp");
        if (delegateThreadLocal.get() != null) {
            delegateThreadLocal.get().resetObject();
            delegateThreadLocal.remove();
        }
        if (CInfo.get() != null) {
            CInfo.get().resetObject();
            CInfo.remove();
        }
        if (WRecv.get() != null) {
            WRecv.get().resetObject();
            WRecv.remove();
        }
        lastCertExtract.set(NOTSET);
        boolean bl = true;
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            boolean bl2 = bl;
            cicsLog.logExit("ibmJVMTidyUp", new Object[]{new Boolean(bl2)});
            bl = bl2;
        }
        return bl;
    }

    @Override
    public void drive_ibmJVMTidyUp() {
        cicsLog.logEntryExit("drive_ibmJVMTidyUp", new Object[0]);
        TcpipRequest.ibmJVMTidyUp();
    }

    private static void processCommonDelegateError(DelegateError err) throws InvalidRequestException {
        switch (err.getCode()) {
            case INVALID_REQUEST: {
                throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
        }
        throw new RuntimeException("Unexpected error code from Delegate layer:" + err.getCode() + " " + err.getMessage(), err);
    }
}

