/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.terminal.DelegateTerminal;
import com.ibm.cics.server.API;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.Cursor;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidTerminalIdException;

public class Terminal
extends API {
    private static final Logger cicsLog = LoggerFactory.getLogger(Terminal.class);
    private Cursor cursor;
    private byte[] nextCOMMAREA;
    private String nextTransaction;
    private Channel nextChannel;
    private DelegateTerminal delegate;

    public Terminal(String name) throws NullPointerException, InvalidTerminalIdException {
        this(DelegateFactoryLoader.getDelegateFactory().createDelegateTerminal(name), name);
    }

    Terminal(DelegateTerminal delegate, String name) throws NullPointerException, InvalidTerminalIdException {
        cicsLog.logEntryExit("constructor", new Object[]{delegate, name});
        if (name == null) {
            throw new NullPointerException("null terminal name");
        }
        if (name.length() == 0) {
            throw new InvalidTerminalIdException("empty terminal name", 0);
        }
        this.delegate = delegate;
        this.cursor = new Cursor(80, 24);
    }

    DelegateTerminal getDelegate() {
        return this.delegate;
    }

    public Terminal(String name, String NETNAME) throws NullPointerException, InvalidTerminalIdException {
        this(DelegateFactoryLoader.getDelegateFactory().createDelegateTerminal(name), name);
        if (NETNAME == null) {
            throw new NullPointerException("null terminal NETNAME");
        }
        if (NETNAME.length() == 0) {
            throw new InvalidTerminalIdException("empty terminal NETNAME", 0);
        }
    }

    Terminal(DelegateTerminal delegate, String name, String NETNAME) throws NullPointerException, InvalidTerminalIdException {
        this(delegate, name);
        if (NETNAME == null) {
            throw new NullPointerException("null terminal NETNAME");
        }
        if (NETNAME.length() == 0) {
            throw new InvalidTerminalIdException("empty terminal NETNAME", 0);
        }
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public String getName() {
        return this.delegate.getName();
    }

    protected byte[] getNextCOMMAREA() {
        return this.nextCOMMAREA;
    }

    protected Channel getNextChannel() {
        return this.nextChannel;
    }

    protected String getNextTransaction() {
        return this.nextTransaction;
    }

    public String getUser() throws InvalidRequestException {
        String userId;
        try {
            userId = this.delegate.getUserId();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
            return null;
        }
        cicsLog.logEntryExit("getUser", new Object[]{userId});
        return userId;
    }

    protected void setNextCOMMAREA(byte[] nextCOMMAREA) {
        this.nextCOMMAREA = nextCOMMAREA;
    }

    protected void setNextTransaction(String nextTransaction) {
        this.nextTransaction = nextTransaction;
    }

    protected void setNextChannel(Channel nextChan) {
        this.nextChannel = nextChan;
    }
}

