/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.EnvironmentConstants;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.terminal.DelegateTerminalOutputStream;
import com.ibm.cics.server.CicsConditionException;
import com.ibm.cics.server.Cursor;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NotAllocatedException;
import com.ibm.cics.server.Terminal;
import com.ibm.cics.server.TerminalException;
import com.ibm.cics.server.internal.JCICSLateBinding;
import java.io.IOException;
import java.io.OutputStream;

class TerminalOutputStream
extends OutputStream {
    Cursor c;
    private static boolean isArchEsa;
    private static byte newLine;
    private DelegateTerminalOutputStream delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateTerminalOutputStream();

    TerminalOutputStream() {
    }

    TerminalOutputStream(Terminal t) {
        this.c = t.getCursor();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] DataBuffer = new byte[len + 4];
        this.c.toSBA(DataBuffer);
        System.arraycopy(b, off, DataBuffer, 3, len);
        DataBuffer[len + 3] = 19;
        try {
            this.sendDataToDelegate(DataBuffer, true);
            if (b[off + len - 1] == newLine) {
                this.c.incrementRow();
                this.c.setColumn(1);
            } else {
                this.c.increment(len);
            }
        }
        catch (CicsConditionException cce) {
            throw new IOException("An error occurred whilst writing to the Terminal.\nThe original exception was: \n" + cce.getClass().getName());
        }
    }

    private void sendDataToDelegate(byte[] dataBuffer, boolean isWait) throws InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        JCICSLateBinding.bindTaskIfRequired();
        try {
            this.delegate.send(dataBuffer, isWait);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_ALLOCATED: {
                    throw new NotAllocatedException(err.getMessage(), err.getResp2(), err);
                }
                case TERMINAL: {
                    throw new TerminalException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (isArchEsa) {
            this.writeEBCDIC(b);
        } else {
            this.writeASCII(b);
        }
    }

    public void writeASCII(int b) throws IOException {
        switch (b) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                this.c.decrement();
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                this.c.incrementRow();
                this.c.setColumn(1);
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                this.c.setColumn(1);
                this.c.setRow(1);
                break;
            }
            case 13: {
                this.c.setColumn(1);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            default: {
                byte[] DataBuffer = new byte[5];
                this.c.toSBA(DataBuffer);
                this.c.increment();
                DataBuffer[3] = (byte)(b & 0xFF);
                DataBuffer[4] = 19;
                try {
                    this.sendDataToDelegate(DataBuffer, false);
                    break;
                }
                catch (CicsConditionException cce) {
                    throw new IOException("An error occurred whilst writing to the Terminal.\nThe original exception was: \n" + cce.getClass().getName());
                }
            }
            case 127: 
        }
    }

    public void writeEBCDIC(int b) throws IOException {
        switch (b) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.c.setColumn(1);
                this.c.setRow(1);
                break;
            }
            case 13: {
                this.c.setColumn(1);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 21: {
                this.c.incrementRow();
                this.c.setColumn(1);
                break;
            }
            case 22: {
                this.c.decrement();
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            case 37: {
                this.c.incrementRow();
                this.c.setColumn(1);
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                break;
            }
            default: {
                byte[] DataBuffer = new byte[5];
                this.c.toSBA(DataBuffer);
                this.c.increment();
                DataBuffer[3] = (byte)(b & 0xFF);
                DataBuffer[4] = 19;
                try {
                    this.sendDataToDelegate(DataBuffer, false);
                    break;
                }
                catch (CicsConditionException cce) {
                    throw new IOException("An error occurred whilst writing to the Terminal.\nThe original exception was: \n" + cce.getClass().getName());
                }
            }
            case 255: 
        }
    }

    static {
        newLine = (byte)10;
        String osArch = EnvironmentConstants.env.getOsArch();
        if (osArch.equals("390") || osArch.equals("s390") || osArch.equals("s390x")) {
            isArchEsa = true;
            newLine = (byte)21;
        }
    }
}

