/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.EnvironmentConstants;
import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateDataHolder;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.terminal.DelegateCursor;
import com.ibm.cics.delegate.terminal.DelegateTerminal;
import com.ibm.cics.delegate.terminal.DelegateTerminalInitialState;
import com.ibm.cics.delegate.terminal.DelegateTerminalPrincipalFacility;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.Cursor;
import com.ibm.cics.server.DataHolder;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.EndOfChainIndicatorException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidTerminalIdException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NotAllocatedException;
import com.ibm.cics.server.TCTUAHolder;
import com.ibm.cics.server.Terminal;
import com.ibm.cics.server.TerminalException;
import com.ibm.cics.server.TerminalSendBits;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;

@InjectLogging(isEnabled=false)
public class TerminalPrincipalFacility
extends Terminal
implements TerminalSendBits {
    private static final Logger cicsLog = LoggerFactory.getLogger(TerminalPrincipalFacility.class);
    private byte[] TERMCODE;
    private int TCTUAlength;
    private byte[] TCTUAP;
    private static final BitSet allFalse = new BitSet();

    @InjectLogging
    TerminalPrincipalFacility(String name, String netname) throws NullPointerException, InvalidTerminalIdException {
        super((DelegateTerminal)DelegateFactoryLoader.getDelegateFactory().createDelegateTerminalPrincipalFacility(name), name, netname);
        cicsLog.logEntry("<init>", new Object[]{name, netname});
        this.initialiseFields();
        cicsLog.logExit("<init>");
    }

    TerminalPrincipalFacility(String name) throws NullPointerException, InvalidTerminalIdException {
        this(DelegateFactoryLoader.getDelegateFactory().createDelegateTerminalPrincipalFacility(name));
    }

    @InjectLogging
    TerminalPrincipalFacility(DelegateTerminalPrincipalFacility delegate) throws NullPointerException, InvalidTerminalIdException {
        super((DelegateTerminal)delegate, delegate.getName());
        cicsLog.logEntry("<init>", new Object[]{delegate});
        this.initialiseFields();
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    TerminalPrincipalFacility(DelegateTerminalPrincipalFacility delegate, String netName) throws NullPointerException, InvalidTerminalIdException {
        super((DelegateTerminal)delegate, delegate.getName(), netName);
        cicsLog.logEntry("<init>", new Object[]{delegate, netName});
        this.initialiseFields();
        cicsLog.logExit("<init>");
    }

    private void initialiseFields() {
        DelegateCursor theCursor = this.getDelegateCursor();
        try {
            DelegateTerminalInitialState initialState = ((DelegateTerminalPrincipalFacility)this.getDelegate()).getInitialState(theCursor);
            this.TCTUAlength = initialState.getTCTUALength();
            this.TCTUAP = initialState.getTCTUAP();
            this.TERMCODE = initialState.getTermCode();
        }
        catch (DelegateError err) {
            DelegateErrorHandler.handleUncheckedError(err);
        }
    }

    @InjectLogging
    public void clear() throws InvalidRequestException {
        cicsLog.logEntry("clear");
        this.erase();
        cicsLog.logExit("clear");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void converse(DataHolder dataHolder) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        void data;
        cicsLog.logEntry("converse", new Object[]{dataHolder});
        if (data == null) {
            throw new InvalidRequestException("data holder is null", 0);
        }
        try {
            boolean isReceivedDataRaw = false;
            ((DelegateTerminalPrincipalFacility)this.getDelegate()).converse(data.getDelegate(), this.getDelegateCursor(), isReceivedDataRaw);
        }
        catch (DelegateError err) {
            TerminalPrincipalFacility.convertReceiveErrorToJCICSExceptions(err);
        }
        cicsLog.logExit("converse");
    }

    @InjectLogging
    private static void convertReceiveErrorToJCICSExceptions(DelegateError delegateError) throws EndOfChainIndicatorException, LengthErrorException, TerminalException, InvalidRequestException, NotAllocatedException {
        DelegateError err;
        cicsLog.logEntry("convertReceiveErrorToJCICSExceptions", new Object[]{delegateError});
        switch (err.getCode()) {
            case END_OF_CHAIN_INDICATOR: {
                throw new EndOfChainIndicatorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case INVALID_REQUEST: {
                throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case LENGTH_ERROR: {
                throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case NOT_ALLOCATED: {
                throw new NotAllocatedException(err.getMessage(), err.getResp2(), err);
            }
            case TERMINAL: {
                throw new TerminalException(err.getMessage(), err.getResp2(), err);
            }
        }
        DelegateErrorHandler.handleUncheckedError(err);
        cicsLog.logExit("convertReceiveErrorToJCICSExceptions");
    }

    private DelegateCursor getDelegateCursor() {
        Cursor currentCursor = this.getCursor();
        return TerminalPrincipalFacility.getDelegateCursor(currentCursor);
    }

    private static DelegateCursor getDelegateCursor(Cursor currentCursor) {
        DelegateCursor delegateCursor = null;
        if (currentCursor != null) {
            delegateCursor = currentCursor.getDelegate();
        }
        return delegateCursor;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void converseASIS(DataHolder dataHolder) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        void data;
        cicsLog.logEntry("converseASIS", new Object[]{dataHolder});
        if (data == null) {
            throw new InvalidRequestException("data holder is null", 0);
        }
        try {
            boolean isReceivedDataRaw = true;
            ((DelegateTerminalPrincipalFacility)this.getDelegate()).converse(data.getDelegate(), this.getDelegateCursor(), isReceivedDataRaw);
        }
        catch (DelegateError err) {
            TerminalPrincipalFacility.convertReceiveErrorToJCICSExceptions(err);
        }
        cicsLog.logExit("converseASIS");
    }

    @InjectLogging
    public void erase() throws InvalidRequestException {
        cicsLog.logEntry("erase");
        try {
            ((DelegateTerminalPrincipalFacility)this.getDelegate()).sendControlErase();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("erase");
    }

    @Override
    @InjectLogging
    protected byte[] getNextCOMMAREA() {
        byte[] c;
        cicsLog.logEntry("getNextCOMMAREA");
        byte[] byArray = c = super.getNextCOMMAREA();
        cicsLog.logExit("getNextCOMMAREA", new Object[]{byArray});
        return byArray;
    }

    @Override
    @InjectLogging
    protected String getNextTransaction() {
        String s;
        cicsLog.logEntry("getNextTransaction");
        String string = s = super.getNextTransaction();
        cicsLog.logExit("getNextTransaction", new Object[]{string});
        return string;
    }

    @Override
    @InjectLogging
    protected Channel getNextChannel() {
        cicsLog.logEntry("getNextChannel");
        Channel channel = super.getNextChannel();
        cicsLog.logExit("getNextChannel", new Object[]{channel});
        return channel;
    }

    public void getTCTUA(TCTUAHolder holder) {
        if (holder == null) {
            throw new NullPointerException("null holder in TerminalPrincipalFacility.getTCTUA()");
        }
        if (this.TCTUAlength == 0) {
            holder.setValue(new byte[0]);
        } else {
            DelegateDataHolder delegateHolder = holder.getDelegate();
            try {
                ((DelegateTerminalPrincipalFacility)this.getDelegate()).readTCTUAContents(delegateHolder, this.TCTUAP, this.TCTUAlength);
            }
            catch (DelegateError err) {
                DelegateErrorHandler.handleUncheckedError(err);
            }
        }
    }

    public byte[] getTERMCODE() {
        return this.TERMCODE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @InjectLogging
    public void receive(DataHolder var1_1) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        TerminalPrincipalFacility.cicsLog.logEntry("receive", new Object[]{var1_1});
        try {
            isRaw = false;
            isBuffered = false;
            ((DelegateTerminalPrincipalFacility)this.getDelegate()).receive(data.getDelegate(), isRaw, isBuffered, this.getDelegateCursor());
        }
        catch (DelegateError err) {
            try {
                TerminalPrincipalFacility.convertReceiveErrorToJCICSExceptions(err);
            }
            catch (Throwable var4_5) {
                if (TerminalPrincipalFacility.cicsLog.shouldTrace(LogType.DEBUG)) {
                    TerminalPrincipalFacility.cicsLog.logDebug("receive", new Object[]{"data:" + data});
                }
                throw var4_5;
            }
            if (TerminalPrincipalFacility.cicsLog.shouldTrace(LogType.DEBUG)) {
                TerminalPrincipalFacility.cicsLog.logDebug("receive", new Object[]{"data:" + data});
            } else {
                ** GOTO lbl19
            }
        }
        if (TerminalPrincipalFacility.cicsLog.shouldTrace(LogType.DEBUG)) {
            TerminalPrincipalFacility.cicsLog.logDebug("receive", new Object[]{"data:" + data});
        }
        TerminalPrincipalFacility.cicsLog.logExit("receive");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void receiveASIS(DataHolder dataHolder) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        cicsLog.logEntry("receiveASIS", new Object[]{dataHolder});
        try {
            void data;
            boolean isRaw = true;
            boolean isBuffered = false;
            ((DelegateTerminalPrincipalFacility)this.getDelegate()).receive(data.getDelegate(), isRaw, isBuffered, this.getDelegateCursor());
        }
        catch (DelegateError err) {
            TerminalPrincipalFacility.convertReceiveErrorToJCICSExceptions(err);
        }
        cicsLog.logExit("receiveASIS");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void receiveBuffer(DataHolder dataHolder) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        cicsLog.logEntry("receiveBuffer", new Object[]{dataHolder});
        try {
            void data;
            boolean isRaw = false;
            boolean isBuffered = true;
            ((DelegateTerminalPrincipalFacility)this.getDelegate()).receive(data.getDelegate(), isRaw, isBuffered, this.getDelegateCursor());
        }
        catch (DelegateError err) {
            TerminalPrincipalFacility.convertReceiveErrorToJCICSExceptions(err);
        }
        cicsLog.logExit("receiveBuffer");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void receiveBufferASIS(DataHolder dataHolder) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        cicsLog.logEntry("receiveBufferASIS", new Object[]{dataHolder});
        try {
            void data;
            boolean isRaw = true;
            boolean isBuffered = true;
            ((DelegateTerminalPrincipalFacility)this.getDelegate()).receive(data.getDelegate(), isRaw, isBuffered, this.getDelegateCursor());
        }
        catch (DelegateError err) {
            TerminalPrincipalFacility.convertReceiveErrorToJCICSExceptions(err);
        }
        cicsLog.logExit("receiveBufferASIS");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void send(byte[] byArray) throws InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        void data;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("send", new Object[]{byArray});
        }
        boolean alarm = false;
        boolean erase = false;
        boolean freekb = false;
        boolean print = false;
        boolean frset = false;
        boolean wait = false;
        if (data == null) {
            throw new InvalidRequestException("text to send is null", 0);
        }
        try {
            ((DelegateTerminalPrincipalFacility)this.getDelegate()).send((byte[])data, alarm, erase, freekb, print, frset, wait);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_ALLOCATED: {
                    throw new NotAllocatedException(err.getMessage(), err.getResp2(), err);
                }
                case TERMINAL: {
                    throw new TerminalException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("send");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void send(byte[] byArray, BitSet bitSet) throws InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        void options;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("send", new Object[]{byArray, bitSet});
        }
        boolean alarm = false;
        boolean erase = false;
        boolean freekb = false;
        boolean print = false;
        boolean frset = false;
        boolean wait = false;
        alarm = options.get(0);
        erase = options.get(1);
        freekb = options.get(2);
        print = options.get(3);
        frset = options.get(4);
        wait = options.get(5);
        try {
            void data;
            ((DelegateTerminalPrincipalFacility)this.getDelegate()).send((byte[])data, alarm, erase, freekb, print, frset, wait);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_ALLOCATED: {
                    throw new NotAllocatedException(err.getMessage(), err.getResp2(), err);
                }
                case TERMINAL: {
                    throw new TerminalException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("send");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendControl(Cursor cursor) throws InvalidRequestException {
        void theCursor;
        cicsLog.logEntry("sendControl", new Object[]{cursor});
        this.sendControl((Cursor)theCursor, allFalse);
        cicsLog.logExit("sendControl");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendControl(Cursor cursor, BitSet bitSet) throws InvalidRequestException {
        void options;
        cicsLog.logEntry("sendControl", new Object[]{cursor, bitSet});
        boolean alarm = false;
        boolean erase = false;
        boolean freekb = false;
        boolean print = false;
        boolean eraseaup = false;
        boolean formfeed = false;
        boolean frset = false;
        alarm = options.get(0);
        erase = options.get(1);
        freekb = options.get(2);
        print = options.get(3);
        eraseaup = options.get(4);
        formfeed = options.get(5);
        frset = options.get(6);
        try {
            void theCursor;
            ((DelegateTerminalPrincipalFacility)this.getDelegate()).sendControl(TerminalPrincipalFacility.getDelegateCursor((Cursor)theCursor), alarm, erase, freekb, print, eraseaup, formfeed, frset);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("sendControl");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendControl(BitSet bitSet) throws InvalidRequestException {
        void options;
        cicsLog.logEntry("sendControl", new Object[]{bitSet});
        this.sendControl(null, (BitSet)options);
        cicsLog.logExit("sendControl");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendText(byte[] byArray) throws InvalidRequestException, LengthErrorException {
        void text;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("sendText", new Object[]{byArray});
        }
        this.sendText((byte[])text, null, allFalse);
        cicsLog.logExit("sendText");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendText(byte[] byArray, Cursor cursor) throws InvalidRequestException, LengthErrorException {
        void theCursor;
        void text;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("sendText", new Object[]{byArray, cursor});
        }
        this.sendText((byte[])text, (Cursor)theCursor, allFalse);
        cicsLog.logExit("sendText");
    }

    private void sendTextToDelegate(byte[] textBytes, DelegateCursor theCursor, boolean alarm, boolean erase, boolean freekb, boolean print, boolean formfeed, boolean nleom) throws InvalidRequestException, LengthErrorException {
        if (textBytes == null) {
            throw new InvalidRequestException("text to send is null", 0);
        }
        try {
            ((DelegateTerminalPrincipalFacility)this.getDelegate()).sendText(textBytes, theCursor, alarm, erase, freekb, print, formfeed, nleom);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendText(byte[] byArray, Cursor cursor, BitSet bitSet) throws InvalidRequestException, LengthErrorException {
        void text;
        void theCursor;
        void options;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("sendText", new Object[]{byArray, cursor, bitSet});
        }
        boolean alarm = false;
        boolean erase = false;
        boolean freekb = false;
        boolean print = false;
        boolean formfeed = false;
        boolean nleom = false;
        alarm = options.get(0);
        erase = options.get(1);
        freekb = options.get(2);
        print = options.get(3);
        formfeed = options.get(4);
        nleom = options.get(5);
        DelegateCursor delegateCursor = null;
        if (theCursor != null) {
            delegateCursor = theCursor.getDelegate();
        }
        this.sendTextToDelegate((byte[])text, delegateCursor, alarm, erase, freekb, print, formfeed, nleom);
        cicsLog.logExit("sendText");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendText(byte[] byArray, BitSet bitSet) throws InvalidRequestException, LengthErrorException {
        void text;
        void options;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("sendText", new Object[]{byArray, bitSet});
        }
        boolean alarm = false;
        boolean erase = false;
        boolean freekb = false;
        boolean print = false;
        boolean formfeed = false;
        boolean nleom = false;
        alarm = options.get(0);
        erase = options.get(1);
        freekb = options.get(2);
        print = options.get(3);
        formfeed = options.get(4);
        nleom = options.get(5);
        this.sendTextToDelegate((byte[])text, null, alarm, erase, freekb, print, formfeed, nleom);
        cicsLog.logExit("sendText");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendTextString(String string) throws InvalidRequestException, LengthErrorException {
        void text;
        cicsLog.logEntry("sendTextString", new Object[]{string});
        byte[] textAsBytes = TerminalPrincipalFacility.encodeStringAsBytes((String)text);
        this.sendText(textAsBytes, null, allFalse);
        cicsLog.logExit("sendTextString");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendTextString(String string, Cursor cursor) throws InvalidRequestException, LengthErrorException {
        void theCursor;
        void text;
        cicsLog.logEntry("sendTextString", new Object[]{string, cursor});
        byte[] textAsBytes = TerminalPrincipalFacility.encodeStringAsBytes((String)text);
        this.sendText(textAsBytes, (Cursor)theCursor, allFalse);
        cicsLog.logExit("sendTextString");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendTextString(String string, Cursor cursor, BitSet bitSet) throws InvalidRequestException, LengthErrorException {
        void options;
        void theCursor;
        void text;
        cicsLog.logEntry("sendTextString", new Object[]{string, cursor, bitSet});
        byte[] textAsBytes = TerminalPrincipalFacility.encodeStringAsBytes((String)text);
        this.sendText(textAsBytes, (Cursor)theCursor, (BitSet)options);
        cicsLog.logExit("sendTextString");
    }

    @InjectLogging
    private static byte[] encodeStringAsBytes(String string) throws InvalidRequestException {
        byte[] textAsBytes;
        String text;
        cicsLog.logEntry("encodeStringAsBytes", new Object[]{string});
        if (text == null) {
            throw new InvalidRequestException("Null text to send.", 0);
        }
        if (EnvironmentConstants.env.getLocalCCSID() == null) {
            textAsBytes = text.getBytes();
        } else {
            try {
                textAsBytes = text.getBytes(EnvironmentConstants.env.getLocalCCSID());
            }
            catch (UnsupportedEncodingException e) {
                textAsBytes = text.getBytes();
            }
        }
        byte[] byArray = textAsBytes;
        cicsLog.logExit("encodeStringAsBytes", new Object[]{byArray});
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendText(String string, BitSet bitSet) throws InvalidRequestException, LengthErrorException {
        void options;
        void text;
        cicsLog.logEntry("sendText", new Object[]{string, bitSet});
        byte[] textAsBytes = TerminalPrincipalFacility.encodeStringAsBytes((String)text);
        this.sendText(textAsBytes, null, (BitSet)options);
        cicsLog.logExit("sendText");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectLogging
    public void setNextCOMMAREA(byte[] byArray) {
        void nextCOMMAREA;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("setNextCOMMAREA", new Object[]{byArray});
        }
        super.setNextCOMMAREA((byte[])nextCOMMAREA);
        cicsLog.logExit("setNextCOMMAREA");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectLogging
    public void setNextTransaction(String string) {
        void nextTransaction;
        cicsLog.logEntry("setNextTransaction", new Object[]{string});
        super.setNextTransaction((String)nextTransaction);
        cicsLog.logExit("setNextTransaction");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectLogging
    public void setNextChannel(Channel channel) {
        void nextChan;
        cicsLog.logEntry("setNextChannel", new Object[]{channel});
        super.setNextChannel((Channel)nextChan);
        cicsLog.logExit("setNextChannel");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setTCTUA(byte[] byArray) throws InvalidRequestException {
        void data;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("setTCTUA", new Object[]{byArray});
        }
        if (data == null) {
            throw new NullPointerException("null data in setTCTUA()");
        }
        if (this.TCTUAlength == 0) {
            throw new InvalidRequestException("No TCTUA to update");
        }
        try {
            ((DelegateTerminalPrincipalFacility)this.getDelegate()).writeTCTUA((byte[])data, this.TCTUAP, this.TCTUAlength);
        }
        catch (DelegateError err) {
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("setTCTUA");
    }

    @Deprecated
    @InjectLogging
    public void waitTerminal() {
        cicsLog.logEntry("waitTerminal");
        cicsLog.logExit("waitTerminal");
    }

    @InjectLogging
    public byte getAIDbyte() {
        byte AIDbyte;
        cicsLog.logEntry("getAIDbyte");
        try {
            AIDbyte = ((DelegateTerminalPrincipalFacility)this.getDelegate()).getActionIdentifier();
        }
        catch (DelegateError err) {
            DelegateErrorHandler.handleUncheckedError(err);
            byte by = 0;
            if (cicsLog.shouldTrace(LogType.EXIT)) {
                byte by2 = by;
                cicsLog.logExit("getAIDbyte", new Object[]{new Byte(by2)});
                by = by2;
            }
            return by;
        }
        byte by = AIDbyte;
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            byte by3 = by;
            cicsLog.logExit("getAIDbyte", new Object[]{new Byte(by3)});
            by = by3;
        }
        return by;
    }
}

