/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.transform.DelegateTransform;
import com.ibm.cics.delegate.transform.DelegateTransformOutput;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.ContainerErrorException;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.TransformInput;
import com.ibm.cics.server.TransformOutput;
import com.ibm.cics.server.internal.JCICSLateBinding;

@InjectLogging(isEnabled=false)
public class Transform {
    private static final Logger cicsLog = LoggerFactory.getLogger(Transform.class);

    @InjectLogging
    public static TransformOutput xmlToData(TransformInput transformInput) throws IllegalArgumentException, RecordNotFoundException, ChannelErrorException, ContainerErrorException, LengthErrorException, InvalidRequestException {
        TransformOutput results;
        DelegateTransformOutput output;
        TransformInput input;
        cicsLog.logEntry("xmlToData", new Object[]{transformInput});
        if (input.getChannel() == null) {
            throw new IllegalArgumentException("CHANNEL not set");
        }
        if (input.getXmlContainer() == null) {
            throw new IllegalArgumentException("XMLCONTAINER not set");
        }
        String channelName = null;
        String datContainerName = null;
        String xmlContainerName = null;
        String nsContainerName = null;
        String xmltransformName = null;
        if (input.getChannel() != null) {
            channelName = input.getChannel().getName();
        }
        if (input.getDataContainer() != null) {
            datContainerName = input.getDataContainer().getName();
        }
        if (input.getXmlContainer() != null) {
            xmlContainerName = input.getXmlContainer().getName();
        }
        if (input.getNsContainer() != null) {
            nsContainerName = input.getNsContainer().getName();
        }
        if (input.getXmltransform() != null) {
            xmltransformName = input.getXmltransform().getName();
        }
        if (input.getElementName() != null) {
            input.setTypeName(null);
            input.setTypeNamespace(null);
            input.setElementName(null);
            input.setElementNamespace(null);
        }
        JCICSLateBinding.bindTaskIfRequired();
        DelegateTransform xform = DelegateFactoryLoader.getDelegateFactory().createDelegateTransform();
        try {
            output = xform.xmlToData(channelName, datContainerName, input.getTypeName(), input.getTypeNamespace(), xmlContainerName, xmltransformName, nsContainerName);
        }
        catch (DelegateError err) {
            Transform.processTransformError(err);
            throw new RuntimeException("Program logic error: dataToXML() should never hit this code");
        }
        TransformOutput transformOutput = results = new TransformOutput(output.getElementName(), output.getElementNamespace(), output.getTypeName(), output.getTypeNamespace());
        cicsLog.logExit("xmlToData", new Object[]{transformOutput});
        return transformOutput;
    }

    @InjectLogging
    public static TransformOutput dataToXML(TransformInput transformInput) throws IllegalArgumentException, RecordNotFoundException, ChannelErrorException, ContainerErrorException, LengthErrorException, InvalidRequestException {
        TransformOutput results;
        DelegateTransformOutput output;
        TransformInput input;
        cicsLog.logEntry("dataToXML", new Object[]{transformInput});
        if (input.getChannel() == null) {
            throw new IllegalArgumentException("CHANNEL not set");
        }
        if (input.getXmlContainer() == null) {
            throw new IllegalArgumentException("XMLCONTAINER not set");
        }
        if (input.getXmltransform() == null) {
            throw new IllegalArgumentException("XMLTRANSFORM not set");
        }
        String channelName = null;
        String datContainerName = null;
        String xmlContainerName = null;
        String xmltransformName = null;
        if (input.getChannel() != null) {
            channelName = input.getChannel().getName();
        }
        if (input.getDataContainer() != null) {
            datContainerName = input.getDataContainer().getName();
        }
        if (input.getXmlContainer() != null) {
            xmlContainerName = input.getXmlContainer().getName();
        }
        if (input.getXmltransform() != null) {
            xmltransformName = input.getXmltransform().getName();
        }
        JCICSLateBinding.bindTaskIfRequired();
        DelegateTransform xform = DelegateFactoryLoader.getDelegateFactory().createDelegateTransform();
        try {
            output = xform.dataToXml(channelName, datContainerName, input.getElementName(), input.getElementNamespace(), input.getTypeName(), input.getTypeNamespace(), xmlContainerName, xmltransformName);
        }
        catch (DelegateError err) {
            Transform.processTransformError(err);
            throw new RuntimeException("Program logic error: dataToXML() should never hit this code");
        }
        TransformOutput transformOutput = results = new TransformOutput(output.getElementName(), output.getElementNamespace(), output.getTypeName(), output.getTypeNamespace());
        cicsLog.logExit("dataToXML", new Object[]{transformOutput});
        return transformOutput;
    }

    private static void processTransformError(DelegateError err) throws RecordNotFoundException, ChannelErrorException, ContainerErrorException, LengthErrorException, InvalidRequestException {
        switch (err.getCode()) {
            case RECORD_NOT_FOUND: {
                throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
            }
            case CHANNEL_ERROR: {
                throw new ChannelErrorException(err.getMessage(), err.getResp2(), err);
            }
            case CONTAINER_ERROR: {
                throw new ContainerErrorException(err.getMessage(), err.getResp2(), err);
            }
            case LENGTH_ERROR: {
                throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case INVALID_REQUEST: {
                throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
        }
        DelegateErrorHandler.handleUncheckedError(err);
    }
}

