/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

public class Version
implements Comparable<Version> {
    private int majorVersion;
    private int minorVersion;
    private int microVersion;
    public static final char SEPARATOR_CHARACTER = '.';
    public static final int MAX_VERSION_PARTS = 3;

    public Version(int majorVersion, int minorVersion, int microVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.microVersion = microVersion;
    }

    public Version(int majorVersion, int minorVersion) {
        this(majorVersion, minorVersion, 0);
    }

    public Version(String versionString) throws IllegalArgumentException {
        if (versionString == null) {
            throw new IllegalArgumentException("Version string is null.");
        }
        String[] parts = versionString.split("\\.");
        if (parts.length > 3) {
            throw new IllegalArgumentException("Version string has too many parts.");
        }
        int[] versionPartNumbers = new int[3];
        int index = 0;
        for (String part : parts) {
            try {
                int value;
                versionPartNumbers[index] = value = Integer.parseInt(part.trim());
                ++index;
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Version string part '" + part + "' is not a number.", nfe);
            }
        }
        this.majorVersion = versionPartNumbers[0];
        this.minorVersion = versionPartNumbers[1];
        this.microVersion = versionPartNumbers[2];
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public int getMicroVersion() {
        return this.microVersion;
    }

    public void setMicroVersion(int microVersion) {
        this.microVersion = microVersion;
    }

    public boolean equals(Object obj) {
        return obj instanceof Version && ((Version)obj).getMajorVersion() == this.majorVersion && ((Version)obj).getMinorVersion() == this.minorVersion && ((Version)obj).getMicroVersion() == this.microVersion;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.majorVersion;
        hash = 31 * hash + this.minorVersion;
        hash = 31 * hash + this.microVersion;
        return hash;
    }

    public String toString() {
        return this.majorVersion + Character.toString('.') + this.minorVersion + Character.toString('.') + this.microVersion;
    }

    @Override
    public int compareTo(Version versionToCompare) {
        int compareResult = 0;
        compareResult = Integer.compare(this.majorVersion, versionToCompare.majorVersion);
        if (compareResult == 0) {
            compareResult = Integer.compare(this.minorVersion, versionToCompare.minorVersion);
        }
        if (compareResult == 0) {
            compareResult = Integer.compare(this.microVersion, versionToCompare.microVersion);
        }
        return compareResult;
    }
}

