/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateErrorCode;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.web.DelegateWSAContext;
import com.ibm.cics.server.API;
import com.ibm.cics.server.CCSIDErrorException;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.internal.JCICSLateBinding;
import java.util.HashMap;
import java.util.Map;

@InjectLogging(isEnabled=false)
public class WSAContext
extends API {
    private static final Logger cicsLog = LoggerFactory.getLogger(WSAContext.class);
    public static final int FROMEPR = 850;
    public static final int TOEPR = 851;
    public static final int REPLYTOEPR = 852;
    public static final int FAULTTOEPR = 853;
    public static final int REQCONTEXT = 854;
    public static final int RESPCONTEXT = 855;
    private static final int IALL = 856;
    private static final int IMETADATA = 857;
    private static final int IREFPARMS = 858;
    private static final int IADDRESS = 859;
    private String channel;
    private String natlang;
    private DelegateWSAContext delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateWSAContext();

    @InjectLogging
    public static void delete(String string) throws InvalidRequestException, ChannelErrorException, RecordNotFoundException {
        String channel;
        cicsLog.logEntry("delete", new Object[]{string});
        if (channel == null || channel.equals("")) {
            cicsLog.logError("delete", new Object[]{"exception: Null or empty Channel name"});
            throw new IllegalStateException("Null or empty Channel name");
        }
        JCICSLateBinding.bindTaskIfRequired();
        DelegateWSAContext delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateWSAContext();
        try {
            delegate.delete(channel);
        }
        catch (DelegateError err) {
            cicsLog.logError("delete", "delegate error detected", (Throwable)err);
            WSAContext.throwInvReqChanErrRecNotFoundJCICSException(err);
        }
        cicsLog.logExit("delete");
    }

    private static void throwInvReqChanErrRecNotFoundJCICSException(DelegateError err) throws InvalidRequestException, ChannelErrorException, RecordNotFoundException {
        switch (err.getCode()) {
            case INVALID_REQUEST: {
                throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case CHANNEL_ERROR: {
                throw new ChannelErrorException(err.getMessage(), err.getResp2(), err);
            }
            case RECORD_NOT_FOUND: {
                throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
            }
        }
        DelegateErrorHandler.handleUncheckedError(err);
    }

    private static void throwInvReqChanErrCCSIDErrJCICSException2(DelegateError err) throws InvalidRequestException, ChannelErrorException, CCSIDErrorException {
        switch (err.getCode()) {
            case INVALID_REQUEST: {
                throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case CHANNEL_ERROR: {
                throw new ChannelErrorException(err.getMessage(), err.getResp2(), err);
            }
            case CCSID_ERROR: {
                throw new CCSIDErrorException(err.getMessage(), err.getResp2(), err);
            }
        }
        DelegateErrorHandler.handleUncheckedError(err);
    }

    public WSAContext() {
        cicsLog.logEntryExit("constructor", new Object[0]);
    }

    @InjectLogging
    public void delete() throws IllegalStateException, InvalidRequestException, ChannelErrorException, RecordNotFoundException {
        cicsLog.logEntry("delete");
        if (this.channel == null || this.channel.equals("")) {
            throw new IllegalStateException("Channel name not supplied");
        }
        JCICSLateBinding.bindTaskIfRequired();
        try {
            this.delegate.delete(this.channel);
        }
        catch (DelegateError err) {
            WSAContext.throwInvReqChanErrRecNotFoundJCICSException(err);
        }
        cicsLog.logExit("delete");
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getNationalLang() {
        return this.natlang;
    }

    public void setNationalLang(String natlang) {
        this.natlang = natlang;
    }

    public String getAction(int contextType) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, RecordNotFoundException, ChannelErrorException {
        String action = null;
        if (contextType != 854 && contextType != 855) {
            throw new IllegalArgumentException("Context type not valid");
        }
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        try {
            action = this.delegate.getAction(contextType, chn, this.natlang);
        }
        catch (DelegateError err) {
            if (err.getCode().equals((Object)DelegateErrorCode.CCSID_ERROR)) {
                throw new CCSIDErrorException(err.getMessage(), err.getResp2(), err);
            }
            WSAContext.throwInvReqChanErrRecNotFoundJCICSException(err);
        }
        if (action != null) {
            action = action.trim();
        }
        return action;
    }

    public void setAction(String action) throws InvalidRequestException, CCSIDErrorException, ChannelErrorException {
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        try {
            this.delegate.build(chn, action, null, null, null, 0, 0, null, this.natlang);
        }
        catch (DelegateError err) {
            WSAContext.throwBuildJCICSExceptions(err);
        }
    }

    private static void throwBuildJCICSExceptions(DelegateError err) throws InvalidRequestException, CCSIDErrorException, ChannelErrorException {
        switch (err.getCode()) {
            case INVALID_REQUEST: {
                throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case CCSID_ERROR: {
                throw new CCSIDErrorException(err.getMessage(), err.getResp2(), err);
            }
            case CHANNEL_ERROR: {
                throw new ChannelErrorException(err.getMessage(), err.getResp2(), err);
            }
        }
        throw new RuntimeException(err.getMessage(), err);
    }

    public String getMessageId(int contextType) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, RecordNotFoundException, ChannelErrorException {
        String messageId = null;
        if (contextType != 854 && contextType != 855) {
            throw new IllegalArgumentException("Context type not valid");
        }
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        try {
            messageId = this.delegate.getMessageId(contextType, chn, this.natlang);
        }
        catch (DelegateError err) {
            if (err.getCode().equals((Object)DelegateErrorCode.CCSID_ERROR)) {
                throw new CCSIDErrorException(err.getMessage(), err.getResp2(), err);
            }
            WSAContext.throwInvReqChanErrRecNotFoundJCICSException(err);
        }
        if (messageId != null) {
            messageId = messageId.trim();
        }
        return messageId;
    }

    public void setMessageId(String messageId) throws InvalidRequestException, CCSIDErrorException, ChannelErrorException {
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        try {
            this.delegate.build(chn, null, messageId, null, null, 0, 0, null, this.natlang);
        }
        catch (DelegateError err) {
            WSAContext.throwInvReqChanErrCCSIDErrJCICSException2(err);
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public Map<String, String> getRelatesTo(int n) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, RecordNotFoundException, ChannelErrorException {
        void contextType;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("getRelatesTo", new Object[]{new Integer(n)});
        }
        HashMap<String, String> relatesTo = new HashMap<String, String>();
        String rString = null;
        if (contextType != 854 && contextType != 855) {
            throw new IllegalArgumentException("Context type not valid");
        }
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        for (int i = 1; i <= 1024; ++i) {
            try {
                rString = this.delegate.getRelates((int)contextType, chn, i, this.natlang);
            }
            catch (DelegateError err) {
                if (err.getCode().equals((Object)DelegateErrorCode.RECORD_NOT_FOUND)) {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
                WSAContext.throwInvReqChanErrCCSIDErrJCICSException2(err);
                Map<String, String> map = null;
                cicsLog.logExit("getRelatesTo", new Object[]{map});
                return map;
            }
            try {
                relatesTo.put(rString.substring(0, 255).trim(), rString.substring(255).trim());
                continue;
            }
            catch (InvalidRequestException ex) {
                if (ex.getRESP2() == 12) break;
                throw ex;
            }
        }
        HashMap<String, String> hashMap = relatesTo;
        cicsLog.logExit("getRelatesTo", new Object[]{hashMap});
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setRelatesTo(String string, String string2) throws InvalidRequestException, CCSIDErrorException, ChannelErrorException {
        cicsLog.logEntry("setRelatesTo", new Object[]{string, string2});
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        try {
            void relatesType;
            void relatesURI;
            this.delegate.build(chn, null, null, (String)relatesURI, (String)relatesType, 0, 0, null, this.natlang);
        }
        catch (DelegateError err) {
            WSAContext.throwBuildJCICSExceptions(err);
        }
        cicsLog.logExit("setRelatesTo");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setRelatesTo(String string) throws InvalidRequestException, CCSIDErrorException, ChannelErrorException {
        cicsLog.logEntry("setRelatesTo", new Object[]{string});
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        try {
            void relatesURI;
            this.delegate.build(chn, null, null, (String)relatesURI, null, 0, 0, null, this.natlang);
        }
        catch (DelegateError err) {
            WSAContext.throwBuildJCICSExceptions(err);
        }
        cicsLog.logExit("setRelatesTo");
    }

    public String getEprAddress(int contextType, int eprType) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, RecordNotFoundException, ChannelErrorException {
        int index1;
        String address = "http://www.w3.org/2005/08/addressing/anonymous";
        String epr = this.getEpr(contextType, eprType);
        if (epr != null && (index1 = epr.indexOf(":Address>")) > -1) {
            int index2 = epr.substring(index1 += ":Address>".length()).indexOf(":Address>");
            while (epr.charAt(index1 + index2) != '<') {
                --index2;
            }
            address = epr.substring(index1, index1 + index2);
        }
        return address;
    }

    public void setEprAddress(int eprType, String address) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, ChannelErrorException {
        if (eprType != 851 && eprType != 850 && eprType != 852 && eprType != 853) {
            throw new IllegalArgumentException("EPR type not valid");
        }
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        try {
            this.delegate.build(chn, null, null, null, null, eprType, 859, address, this.natlang);
        }
        catch (DelegateError err) {
            WSAContext.throwBuildJCICSExceptions(err);
        }
    }

    public String getEprRefParms(int contextType, int eprType) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, RecordNotFoundException, ChannelErrorException {
        int index1;
        String refParms = null;
        String epr = this.getEpr(contextType, eprType);
        if (epr != null && (index1 = epr.indexOf(":ReferenceParameters>")) > -1) {
            int index2 = epr.substring(index1 += ":ReferenceParameters>".length()).lastIndexOf(":ReferenceParameters>");
            while (epr.charAt(index1 + index2) != '<') {
                --index2;
            }
            refParms = epr.substring(index1, index1 + index2);
        }
        return refParms;
    }

    public void setEprRefParms(int eprType, String refparms) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, ChannelErrorException {
        if (eprType != 851 && eprType != 850 && eprType != 852 && eprType != 853) {
            throw new IllegalArgumentException("EPR type not valid");
        }
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        try {
            this.delegate.build(chn, null, null, null, null, eprType, 858, refparms, this.natlang);
        }
        catch (DelegateError err) {
            WSAContext.throwBuildJCICSExceptions(err);
        }
    }

    public String getEprMetadata(int contextType, int eprType) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, RecordNotFoundException, ChannelErrorException {
        int index1;
        String metadata = null;
        String epr = this.getEpr(contextType, eprType);
        if (epr != null && (index1 = epr.indexOf(":Metadata>")) > -1) {
            int index2 = epr.substring(index1 += ":Metadata>".length()).lastIndexOf(":Metadata>");
            while (epr.charAt(index1 + index2) != '<') {
                --index2;
            }
            metadata = epr.substring(index1, index1 + index2);
        }
        return metadata;
    }

    public void setEprMetadata(int eprType, String metadata) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, ChannelErrorException {
        if (eprType != 851 && eprType != 850 && eprType != 852 && eprType != 853) {
            throw new IllegalArgumentException("EPR type not valid");
        }
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        try {
            this.delegate.build(chn, null, null, null, null, eprType, 857, metadata, this.natlang);
        }
        catch (DelegateError err) {
            WSAContext.throwBuildJCICSExceptions(err);
        }
    }

    public String getEpr(int contextType, int eprType) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, RecordNotFoundException, ChannelErrorException {
        String epr = null;
        if (contextType != 854 && contextType != 855) {
            throw new IllegalArgumentException("Context type not valid");
        }
        if (eprType != 851 && eprType != 850 && eprType != 852 && eprType != 853) {
            throw new IllegalArgumentException("EPR type not valid");
        }
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        try {
            epr = this.delegate.getEPR(contextType, chn, eprType, 856, this.natlang);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case CCSID_ERROR: {
                    throw new CCSIDErrorException(err.getMessage(), err.getResp2(), err);
                }
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
                case CHANNEL_ERROR: {
                    throw new ChannelErrorException(err.getMessage(), err.getResp2(), err);
                }
            }
            throw new RuntimeException(err.getMessage(), err);
        }
        return epr;
    }

    public void setEpr(int eprType, String epr) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, ChannelErrorException {
        if (eprType != 851 && eprType != 850 && eprType != 852 && eprType != 853) {
            throw new IllegalArgumentException("EPR type not valid");
        }
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        try {
            this.delegate.build(chn, null, null, null, null, eprType, 856, epr, this.natlang);
        }
        catch (DelegateError err) {
            WSAContext.throwBuildJCICSExceptions(err);
        }
    }
}

