/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.web.DelegateWSAEndpointReferenceFactory;
import com.ibm.cics.server.API;
import com.ibm.cics.server.CCSIDErrorException;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.InvalidRequestException;

public class WSAEpr
extends API {
    private String natlang;
    private DelegateWSAEndpointReferenceFactory delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateWSAEndpointReferenceFactory();

    public String getNationalLang() {
        return this.natlang;
    }

    public void setNationalLang(String natlang) {
        this.natlang = natlang;
    }

    public String create(String address, String referenceParameters, String metadata) throws InvalidRequestException, CCSIDErrorException {
        return this.create(address, referenceParameters, metadata, this.natlang);
    }

    public String create(String address, String referenceParameters) throws InvalidRequestException, CCSIDErrorException {
        return this.create(address, referenceParameters, null, this.natlang);
    }

    public String create(String address) throws InvalidRequestException, CCSIDErrorException {
        return this.create(address, null, null, this.natlang);
    }

    private String create(String address, String referenceParameters, String metadata, String theNatlang) throws InvalidRequestException, CCSIDErrorException {
        String EPRxml;
        try {
            EPRxml = this.delegate.createWSAEndpointReference(address, referenceParameters, metadata, theNatlang);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case CCSID_ERROR: {
                    throw new CCSIDErrorException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
            return null;
        }
        return EPRxml;
    }
}

