/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.web.DelegateHostType;
import com.ibm.cics.delegate.web.DelegateRequestType;
import com.ibm.cics.delegate.web.DelegateScheme;
import com.ibm.cics.delegate.web.DelegateWebInfo;
import com.ibm.cics.server.API;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.InvalidRequestException;

class WebInfo
extends API {
    public static final int NOTSET = DelegateHostType.NOTSET.getValue();
    public static final int NOTAPPLIC = DelegateHostType.NOTAPPLIC.getValue();
    public static final int IPV4 = DelegateHostType.IPV4.getValue();
    public static final int IPV6 = DelegateHostType.IPV6.getValue();
    public static final int HOSTNAME = DelegateHostType.HOSTNAME.getValue();
    public static final int HTTPYES = DelegateRequestType.HTTPYES.getValue();
    public static final int HTTPNO = DelegateRequestType.HTTPNO.getValue();
    public static final int HTTP = DelegateScheme.HTTP.getValue();
    public static final int HTTPS = DelegateScheme.HTTPS.getValue();
    private DelegateWebInfo delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateWebInfo();

    WebInfo() {
    }

    public String getHttpMethod() throws InvalidRequestException {
        try {
            return this.delegate.getHttpMethod();
        }
        catch (DelegateError err) {
            WebInfo.handleCommonDelegateError(err);
            return null;
        }
    }

    private static void handleCommonDelegateError(DelegateError err) throws InvalidRequestException {
        switch (err.getCode()) {
            case INVALID_REQUEST: {
                throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
        }
        DelegateErrorHandler.handleUncheckedError(err);
    }

    public String getHttpVersion() throws InvalidRequestException {
        try {
            return this.delegate.getHttpVersion();
        }
        catch (DelegateError err) {
            WebInfo.handleCommonDelegateError(err);
            return null;
        }
    }

    public String getRequestType() throws InvalidRequestException {
        try {
            return this.delegate.getRequestType().getStringValue();
        }
        catch (DelegateError err) {
            WebInfo.handleCommonDelegateError(err);
            return null;
        }
    }

    public boolean isDataHttp() throws InvalidRequestException {
        try {
            return this.delegate.isDataHttp();
        }
        catch (DelegateError err) {
            WebInfo.handleCommonDelegateError(err);
            return false;
        }
    }

    public String getPath() throws InvalidRequestException {
        try {
            return this.delegate.getPath();
        }
        catch (DelegateError err) {
            WebInfo.handleCommonDelegateError(err);
            return null;
        }
    }

    public String getQueryString() throws InvalidRequestException {
        try {
            return this.delegate.getQueryString();
        }
        catch (DelegateError err) {
            WebInfo.handleCommonDelegateError(err);
            return null;
        }
    }

    public String getHost() throws InvalidRequestException {
        try {
            return this.delegate.getHost();
        }
        catch (DelegateError err) {
            WebInfo.handleCommonDelegateError(err);
            return null;
        }
    }

    public boolean isSchemeHttp() throws InvalidRequestException {
        try {
            return this.delegate.isSchemeHttp();
        }
        catch (DelegateError err) {
            WebInfo.handleCommonDelegateError(err);
            return false;
        }
    }

    public boolean isSchemeHttps() throws InvalidRequestException {
        try {
            return this.delegate.isSchemeHttps();
        }
        catch (DelegateError err) {
            WebInfo.handleCommonDelegateError(err);
            return false;
        }
    }

    public String getScheme() throws InvalidRequestException {
        try {
            return this.delegate.getScheme().getStringValue();
        }
        catch (DelegateError err) {
            WebInfo.handleCommonDelegateError(err);
            return null;
        }
    }

    public String getUrimap() throws InvalidRequestException {
        try {
            return this.delegate.getUrimap();
        }
        catch (DelegateError err) {
            WebInfo.handleCommonDelegateError(err);
            return null;
        }
    }

    public int getPortNumber() throws InvalidRequestException {
        try {
            return this.delegate.getPortNumber();
        }
        catch (DelegateError err) {
            WebInfo.handleCommonDelegateError(err);
            return 0;
        }
    }

    public int getHostType() throws InvalidRequestException {
        try {
            return this.delegate.getHostType();
        }
        catch (DelegateError err) {
            WebInfo.handleCommonDelegateError(err);
            return 0;
        }
    }

    protected void resetObject() {
        this.delegate.resetObject();
    }
}

