/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.web.DelegateWebReceive;
import com.ibm.cics.server.API;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.ContainerErrorException;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.NonHttpDataException;
import com.ibm.cics.server.RecordNotFoundException;

@InjectLogging(isEnabled=false)
class WebReceive
extends API {
    private DelegateWebReceive delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateWebReceive();
    private static final Logger cicsLog = LoggerFactory.getLogger(WebReceive.class);

    WebReceive() {
    }

    @InjectLogging
    protected void setServerConvert() {
        cicsLog.logEntry("setServerConvert");
        this.delegate.setServerConvert(true);
        cicsLog.logExit("setServerConvert");
    }

    @InjectLogging
    protected void setNoServerConvert() {
        cicsLog.logEntry("setNoServerConvert");
        this.delegate.setServerConvert(false);
        cicsLog.logExit("setNoServerConvert");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    protected void setCharacterset(String string) {
        void characterset;
        cicsLog.logEntry("setCharacterset", new Object[]{string});
        this.delegate.setCharacterset((String)characterset);
        cicsLog.logExit("setCharacterset");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    protected void setHostCodePage(String string) {
        void hostCodePage;
        cicsLog.logEntry("setHostCodePage", new Object[]{string});
        this.delegate.setHostCodePage((String)hostCodePage);
        cicsLog.logExit("setHostCodePage");
    }

    @InjectLogging
    protected void setNoTruncate() {
        cicsLog.logEntry("setNoTruncate");
        this.delegate.setTruncate(false);
        cicsLog.logExit("setNoTruncate");
    }

    @InjectLogging
    protected void setTruncate() {
        cicsLog.logEntry("setTruncate");
        this.delegate.setTruncate(true);
        cicsLog.logExit("setTruncate");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    protected void setMaxLength(int n) {
        void maxLength;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("setMaxLength", new Object[]{new Integer(n)});
        }
        this.delegate.setMaxLength((int)maxLength);
        cicsLog.logExit("setMaxLength");
    }

    @InjectLogging
    protected void setNonHttpDataExceptionYes() {
        cicsLog.logEntry("setNonHttpDataExceptionYes");
        this.delegate.setNativeCodeThrowsHttpDataException(true);
        cicsLog.logExit("setNonHttpDataExceptionYes");
    }

    @InjectLogging
    protected void setNonHttpDataExceptionNo() {
        cicsLog.logEntry("setNonHttpDataExceptionNo");
        this.delegate.setNativeCodeThrowsHttpDataException(false);
        cicsLog.logExit("setNonHttpDataExceptionNo");
    }

    @InjectLogging
    protected byte[] receive() throws InvalidRequestException, RecordNotFoundException, NonHttpDataException {
        byte[] byArray;
        cicsLog.logEntry("receive");
        try {
            byArray = this.delegate.receive();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
                case NON_HTTP_DATA: {
                    throw new NonHttpDataException();
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
            byte[] byArray2 = null;
            cicsLog.logExit("receive", new Object[]{byArray2});
            return byArray2;
        }
        cicsLog.logExit("receive", new Object[]{byArray});
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    protected void receiveContainer(String string, String string2) throws InvalidRequestException, RecordNotFoundException, ChannelErrorException, ContainerErrorException {
        cicsLog.logEntry("receiveContainer", new Object[]{string, string2});
        try {
            void toChannel;
            void toContainer;
            this.delegate.receiveContainer((String)toContainer, (String)toChannel);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
                case CHANNEL_ERROR: {
                    throw new ChannelErrorException(err.getMessage(), err.getResp2(), err);
                }
                case CONTAINER_ERROR: {
                    throw new ContainerErrorException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("receiveContainer");
    }

    protected boolean isBodyComplete() {
        return this.delegate.isBodyComplete();
    }

    protected boolean isBodyTruncated() {
        return this.delegate.isBodyTruncated();
    }

    protected boolean isBodyPartial() {
        return this.delegate.isBodyPartial();
    }

    protected String getBodyCharset() throws InvalidRequestException {
        try {
            return this.delegate.getBodyCharset();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
            return null;
        }
    }

    protected String getMediaType() throws InvalidRequestException {
        try {
            return this.delegate.getMediaType();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
            return null;
        }
    }

    @InjectLogging
    protected void resetObject() {
        cicsLog.logEntry("resetObject");
        this.delegate.resetObject();
        cicsLog.logExit("resetObject");
    }
}

