/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.resource.DelegateResource;
import com.ibm.cics.delegate.resource.execution.DelegateWebService;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.Resource;
import com.ibm.cics.server.TimedOutException;
import com.ibm.cics.server.URIMap;

@InjectLogging(isEnabled=false)
public class WebService
extends Resource {
    private static final long serialVersionUID = 4389824957186735041L;
    private String scope;
    private static final Logger cicsLog = LoggerFactory.getLogger(WebService.class);

    @InjectLogging
    public WebService() {
        super((DelegateResource)DelegateFactoryLoader.getDelegateFactory().createDelegateWebService());
        cicsLog.logEntry("<init>");
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    public WebService(String name) {
        super((DelegateResource)DelegateFactoryLoader.getDelegateFactory().createDelegateWebService());
        cicsLog.logEntry("<init>", new Object[]{name});
        ((DelegateWebService)this.getDelegate()).setName(name);
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    protected WebService(DelegateWebService delegate) {
        super((DelegateResource)delegate);
        cicsLog.logEntry("<init>", new Object[]{delegate});
        cicsLog.logExit("<init>");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void invoke(Channel channel, String string) throws RecordNotFoundException, InvalidRequestException, TimedOutException, LengthErrorException {
        void operationName;
        void theChannel;
        cicsLog.logEntry("invoke", new Object[]{channel, string});
        this.invoke((Channel)theChannel, (String)operationName, null, null);
        cicsLog.logExit("invoke");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void invoke(Channel channel, String string, String string2) throws RecordNotFoundException, InvalidRequestException, TimedOutException, LengthErrorException {
        void uri;
        void operationName;
        void theChannel;
        cicsLog.logEntry("invoke", new Object[]{channel, string, string2});
        this.invoke((Channel)theChannel, (String)operationName, (String)uri, null);
        cicsLog.logExit("invoke");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void invoke(Channel channel, String string, URIMap uRIMap) throws RecordNotFoundException, InvalidRequestException, TimedOutException, LengthErrorException {
        void urimap;
        void operationName;
        void theChannel;
        cicsLog.logEntry("invoke", new Object[]{channel, string, uRIMap});
        this.invoke((Channel)theChannel, (String)operationName, null, (URIMap)urimap);
        cicsLog.logExit("invoke");
    }

    private void invoke(Channel theChannel, String operationName, String uri, URIMap urimap) throws RecordNotFoundException, InvalidRequestException, TimedOutException, LengthErrorException {
        String baseUrimapName = null;
        if (urimap != null) {
            baseUrimapName = urimap.getName();
        }
        try {
            ((DelegateWebService)this.getDelegate()).invoke(theChannel.getName(), operationName, uri, baseUrimapName, this.scope);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case TIMED_OUT: {
                    throw new TimedOutException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setScope(String string) {
        void scope;
        cicsLog.logEntry("setScope", new Object[]{string});
        this.scope = scope;
        cicsLog.logExit("setScope");
    }
}

