/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.CICSThreadLocalManager;
import com.ibm.cics.common.CommonLogger;
import com.ibm.cics.common.CommonUtils;
import com.ibm.cics.common.Environment;
import com.ibm.cics.common.EnvironmentConstants;
import com.ibm.cics.common.EnvironmentImpl;
import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.ThreadStopper;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactory;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.DelegateProgramCaller;
import com.ibm.cics.delegate.DelegateWrapper;
import com.ibm.cics.delegate.ServerStatsCollector;
import com.ibm.cics.delegate.jdbc.DelegateApplicationReturnCode;
import com.ibm.cics.delegate.jvmevents.DelegateEventResponder;
import com.ibm.cics.delegate.jvmevents.DelegateJvmShutdownHelper;
import com.ibm.cics.domains.Dfhsjthj;
import com.ibm.cics.ras.CICSMessageService;
import com.ibm.cics.ras.CICSTraceService;
import com.ibm.cics.ras.RASInitializationProtector;
import com.ibm.cics.server.AbendCancelException;
import com.ibm.cics.server.AbendException;
import com.ibm.cics.server.CICSExecutorService;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.CicsConditionException;
import com.ibm.cics.server.CommAreaHolder;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.IsCICS;
import com.ibm.cics.server.OutputRedirectionPlugin;
import com.ibm.cics.server.Task;
import com.ibm.cics.server.TerminalPrincipalFacility;
import com.ibm.cics.server.internal.Activator;
import com.ibm.cics.server.internal.MainMethodInvocationProxy;
import com.ibm.cics.server.internal.OSGiWrapper;
import com.ibm.cics.server.internal.WrapperHelper;
import com.ibm.cics.server.invocation.InvocationProxy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@InjectLogging(isEnabled=false)
public final class Wrapper {
    static final com.ibm.cics.common.log.Logger cicsLog = LoggerFactory.getLogger(Wrapper.class);
    private static final String sccsid = "@(#) ,GM03-202405201010 %I% %E% %U%";
    private static final int LOCATION_JAVA = 1;
    private static final String applid;
    private static final boolean IS_LIBERTY;
    public static final int MAIN_METHOD = 0;
    public static final int LINKABLE = 1;
    public static final int RUNNABLE = 2;
    public static final int CALLABLE = 3;
    private static final ThreadLocal<String> debugPrefix;
    private static Class<?> outClass;
    private static Class<?> errClass;
    private static OutputStream oStream;
    private static OutputStream eStream;
    private static PrintStream originalSTDOUT;
    private static PrintStream originalSTDERR;
    private static boolean checkedIfOSGi;
    private static boolean isOSGi;
    public static final Class<?>[] MAIN_STRING_ARRAY_PARAMETERS;
    public static final Class<?>[] MAIN_COMMAREA_PARAMETERS;
    public static PrintStream outHandler;
    public static PrintStream errHandler;
    public static final int UNABLE_TO_DETERMINE_STATUS = -1;
    public static final int NOT_CICS_REGION = 0;
    public static final int CICS_REGION_BUT_API_DISALLOWED = 1;
    public static final int CICS_REGION_AND_API_ALLOWED = 2;
    private static Map<Long, Thread> runningDSTasks;
    private static List<Task> runningTasks;
    private static final String thisClassName = "com.ibm.cics.server.Wrapper";
    private static final String TID_2 = "WRAPPER_2";
    private static final String TID_JDBC_PRE_CALL = "JDBC_PRE_CALL_";
    private static final String TID_JDBC_POST_CALL = "JDBC_POST_CALL_";
    private static final String TID_WRAPPER_TIDYUP = "WRAPPER_TIDYUP";
    private static String fullJavaVersion;
    private static boolean libertyVersionShown;
    private static final String JVMSERVER_NAME;
    private static ClassLoader contextCL;
    private static final ServerStatsCollector serverStatsCollector;

    @InjectLogging
    public static void init() {
        cicsLog.logEntry("init");
        CommonLogger.init();
        if (JVMSERVER_NAME == "") {
            throw new IllegalArgumentException("Could not detect com.ibm.cics.jvmserver.name {Expected Environment variable.}");
        }
        DelegateEventResponder eventResponder = DelegateFactoryLoader.getDelegateFactory().createDelegateEventResponder(new DelegateJvmShutdownHelper(){

            public void jvmserverDisabling() {
                this.set_jvmserver_disabling(null);
            }

            public void jvmServerTerminate() {
                Wrapper.jvmServerTerminate(null);
            }

            private void set_jvmserver_disabling(String[] args) {
                cicsLog.logEntryExit("set_jvmserver_disabling", new Object[]{""});
                try {
                    Wrapper.getDelegateWrapper().dtcMarkJvmserverDisabling();
                }
                catch (DelegateError err) {
                    DelegateErrorHandler.handleUncheckedError(err);
                }
            }

            public void shuttingDown() {
                Activator.setExpectShutDown(true);
            }
        });
        try {
            Activator.setEventResponder(eventResponder);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        eventResponder.start();
        serverStatsCollector.startCollecting();
        cicsLog.logExit("init");
    }

    private static DelegateWrapper getDelegateWrapper() {
        DelegateFactory myFactory = DelegateFactoryLoader.getDelegateFactory();
        return myFactory.getDelegateWrapper();
    }

    private static void setAbendFromDelegate(String abcode) {
        try {
            Wrapper.getDelegateWrapper().setAbend(abcode);
        }
        catch (DelegateError err) {
            DelegateErrorHandler.handleUncheckedError(err);
        }
    }

    private static void setAbendForConditionFromDelegate(int resp) {
        try {
            Wrapper.getDelegateWrapper().setAbendForCondition(resp);
        }
        catch (DelegateError err) {
            DelegateErrorHandler.handleUncheckedError(err);
        }
    }

    private static byte[] getCommAreaFromDelegate(String address, String length) {
        byte[] commArea = null;
        try {
            commArea = Wrapper.getDelegateWrapper().getCommArea(address, length);
        }
        catch (DelegateError err) {
            DelegateErrorHandler.handleUncheckedError(err);
        }
        return commArea;
    }

    private static void setCommAreaFromDelegate(String address, String length, byte[] newCommArea) {
        try {
            Wrapper.getDelegateWrapper().setCommArea(address, length, newCommArea);
        }
        catch (DelegateError err) {
            DelegateErrorHandler.handleUncheckedError(err);
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public static void route(byte[] byArray, byte[][] byArray2, int n) {
        void sjTraceLevel;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("route", new Object[]{byArray, byArray2, new Integer(n)});
        }
        CommonLogger.setTraceLevel((int)sjTraceLevel);
        try {
            void args2;
            byte[] args1;
            Dfhsjthj plist = new Dfhsjthj(args1, (byte[][])args2);
            Thread thisThread = Thread.currentThread();
            switch (plist.getFunction()) {
                case 12: {
                    thisThread.setName("PURGE_KILL_JVMSERVER_" + thisThread.getName());
                    if (plist.getExistence(49)) {
                        thisThread.setName("PURGE_KILL_JVMSERVER_" + thisThread.getName());
                        byte[] tranbytes = plist.getTrannum();
                        String unpacked = CommonUtils.packedToUnpacked((byte[])tranbytes);
                        Wrapper.jvmServerTaskTerminate(unpacked);
                        break;
                    }
                    Wrapper.jvmServerTerminate(null);
                    break;
                }
                case 13: {
                    thisThread.setName("JVMSERVER_STATISTICS_" + thisThread.getName());
                    Wrapper.jvmServerStats(null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected function: " + plist.getFunction());
                }
            }
        }
        catch (Throwable t) {
            cicsLog.logError("route", "experienced a problem", t);
            throw t;
        }
        cicsLog.logExit("route");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void addTask(Task theTask) {
        Object object;
        if (runningTasks == null) {
            object = sccsid;
            // MONITORENTER : "@(#) ,GM03-202405201010 %I% %E% %U%"
            if (runningTasks == null) {
                runningTasks = new ArrayList<Task>(100);
            }
            // MONITOREXIT : object
        }
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            cicsLog.logDebug("addTask", new Object[]{"Task = " + theTask.getTaskNumber()});
        }
        object = runningTasks;
        // MONITORENTER : object
        runningTasks.add(theTask);
        // MONITOREXIT : object
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addDSTask(long threadId) {
        if (runningDSTasks == null) {
            runningDSTasks = new ConcurrentHashMap<Long, Thread>(8, 0.9f, 1);
        }
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            cicsLog.logDebug("addDSTask", new Object[]{"cicsPoolThreadId = " + threadId});
        }
        Map<Long, Thread> map = runningDSTasks;
        synchronized (map) {
            runningDSTasks.put(threadId, Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeTask(Task theTask) {
        if (runningTasks != null) {
            if (cicsLog.shouldTrace(LogType.DEBUG)) {
                cicsLog.logDebug("removeTask", new Object[]{"Task = " + theTask.getTaskNumber()});
            }
            List<Task> list = runningTasks;
            synchronized (list) {
                runningTasks.remove(theTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeDSTask(long threadId) {
        if (runningDSTasks != null) {
            Thread removedThread;
            Map<Long, Thread> map = runningDSTasks;
            synchronized (map) {
                removedThread = runningDSTasks.remove(threadId);
            }
            if (removedThread != null && cicsLog.shouldTrace(LogType.DEBUG)) {
                cicsLog.logDebug("removeDSTask", new Object[]{"cicsPoolThreadId = " + threadId + ", Thread name = " + removedThread.getName()});
            }
        }
    }

    @InjectLogging
    private static boolean ibmJVMTidyUp() {
        cicsLog.logEntry("ibmJVMTidyUp");
        if (Wrapper.collectingTrace()) {
            CICSTraceService.getTraceService().trace(2048L, thisClassName, TID_WRAPPER_TIDYUP, "ibmJVMTidyUp");
        }
        try {
            if (outHandler != null) {
                outHandler.flush();
            }
            if (errHandler != null) {
                errHandler.flush();
            }
        }
        catch (Exception exc) {
            cicsLog.logError("ibmJVMTidyUp", "failed when flushing stdout/stderr", (Throwable)exc);
        }
        Task.resetTask();
        try {
            DelegateFactoryLoader.getDelegateFactory().getDelegateStorageManager().cleanup();
        }
        catch (DelegateError err) {
            DelegateErrorHandler.handleUncheckedError(err);
        }
        boolean bl = true;
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            boolean bl2 = bl;
            cicsLog.logExit("ibmJVMTidyUp", new Object[]{new Boolean(bl2)});
            bl = bl2;
        }
        return bl;
    }

    @InjectLogging
    private static boolean isActiveDB2SQLJJDBC(Task task) {
        Task theTask;
        cicsLog.logEntry("isActiveDB2SQLJJDBC", new Object[]{task});
        Task currentTask = theTask;
        if (currentTask == null) {
            currentTask = Task.getTask();
        }
        if (currentTask.getDB2SQLJJDBCActive()) {
            boolean bl = true;
            if (cicsLog.shouldTrace(LogType.EXIT)) {
                boolean bl2 = bl;
                cicsLog.logExit("isActiveDB2SQLJJDBC", new Object[]{new Boolean(bl2)});
                bl = bl2;
            }
            return bl;
        }
        boolean bl = false;
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            boolean bl3 = bl;
            cicsLog.logExit("isActiveDB2SQLJJDBC", new Object[]{new Boolean(bl3)});
            bl = bl3;
        }
        return bl;
    }

    public static boolean collectingTrace() {
        return cicsLog.shouldTrace(LogType.ENTRY);
    }

    public static int isSQLJPropSet() {
        if (!Wrapper.isActiveDB2SQLJJDBC(null)) {
            cicsLog.logEvent("isSQLJPropSet", new Object[]{"false"});
            return 0;
        }
        cicsLog.logEvent("isSQLJPropSet", new Object[]{"true"});
        return 1;
    }

    private static ApplicationResponse call_main(InvocationProxy proxy) throws NoSuchMethodException {
        String thisMethod = "call_main";
        if (cicsLog.shouldTrace(LogType.EVENT)) {
            cicsLog.logEntry("call_main", new Object[]{proxy.toString()});
        }
        ApplicationResponse response = new ApplicationResponse(ApplicationResponse.ReturnCode.SUCCESS);
        try {
            proxy.invoke();
        }
        catch (InvocationTargetException ITE) {
            response = Wrapper.checkRealException(ITE);
        }
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            cicsLog.logExit("call_main", new Object[]{"rc = " + (Object)((Object)response.getReturnCode())});
        }
        return response;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public static void callUserClass(String[] stringArray, Task task) throws AbendException, AbendCancelException, ThreadDeath {
        String s;
        Object o;
        void currentTask;
        String[] args;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("callUserClass", new Object[]{stringArray, task});
        }
        String thisMethod = "callUserClass";
        ApplicationResponse response = new ApplicationResponse(ApplicationResponse.ReturnCode.SUCCESS);
        String userClassName = "unknown";
        CommAreaHolder CAH = new CommAreaHolder();
        boolean inputCommArea = false;
        Class<?> userClass = null;
        if (args.length < 1 || args[0].length() == 0) {
            String abcode = "AJ0" + ApplicationResponse.ReturnCode.INVALID_ARGUMENTS.getNumericValue();
            Wrapper.setAbendFromDelegate(abcode);
            response.setReturnCode(ApplicationResponse.ReturnCode.INVALID_ARGUMENTS);
            throw new RuntimeException(abcode);
        }
        if (Wrapper.collectingTrace()) {
            CICSTraceService.getTraceService().entry(thisClassName, "callUserClass", (Object)args[0]);
        }
        Thread.currentThread().setName(currentTask.getThreadName());
        byte[] commAreaHolderValue = Wrapper.getCommAreaFromDelegate(null, null);
        if (commAreaHolderValue == null) {
            inputCommArea = false;
            CAH.setValue(new byte[0]);
        } else {
            CAH.setValue(commAreaHolderValue);
            inputCommArea = true;
        }
        try {
            userClassName = args[0].replace('/', '.');
            userClass = contextCL.loadClass(userClassName);
            try {
                if (Wrapper.collectingTrace()) {
                    CICSTraceService.getTraceService().trace(4096L, thisClassName, "callUserClass", TID_2, (Object)userClassName);
                }
                MainMethodInvocationProxy proxy = new MainMethodInvocationProxy(userClass);
                proxy.setArguments(CAH, new String[0]);
                response = Wrapper.call_main(proxy);
                if (response.getReturnCode() == ApplicationResponse.ReturnCode.SUCCESS && inputCommArea) {
                    Wrapper.setCommAreaFromDelegate(null, null, CAH.value);
                }
            }
            catch (NoSuchMethodException e) {
                response.setThrown(e);
                response.setReturnCode(ApplicationResponse.ReturnCode.NO_SUCH_METHOD_ERROR);
            }
            catch (NoSuchMethodError NSME) {
                response.setThrown(NSME);
                response.setReturnCode(ApplicationResponse.ReturnCode.NO_SUCH_METHOD_ERROR);
            }
        }
        catch (ClassNotFoundException CNFE) {
            response.setThrown(CNFE);
            response.setReturnCode(ApplicationResponse.ReturnCode.NO_CLASS_DEF_FOUND_ERROR);
        }
        catch (Throwable th) {
            response.setThrown(th);
            response.setReturnCode(ApplicationResponse.ReturnCode.UNEXPECTED_EXCEPTION);
        }
        userClass = null;
        if (response.getReturnCode() != ApplicationResponse.ReturnCode.SUCCESS) {
            Wrapper.handleReturnCode(response, userClassName, 0);
        }
        if ((o = currentTask.getPrincipalFacility()) instanceof TerminalPrincipalFacility && (s = ((TerminalPrincipalFacility)o).getNextTransaction()) != null) {
            TerminalPrincipalFacility term = (TerminalPrincipalFacility)o;
            term.setNextTransaction(null);
            Channel nextChan = term.getNextChannel();
            byte[] commArea = term.getNextCOMMAREA();
            if (nextChan != null && commArea != null) {
                Wrapper.setAbendForConditionFromDelegate(CicsConditionException.RESPCODE.INVREQ.getValue());
            }
            DelegateProgramCaller caller = DelegateFactoryLoader.getDelegateFactory().getDelegateProgramCaller();
            try {
                if (nextChan != null) {
                    caller.returnExplicitly(s, null, nextChan.getName());
                } else {
                    caller.returnExplicitly(s, commArea, null);
                }
            }
            catch (DelegateError err) {
                DelegateErrorHandler.handleUncheckedError(err);
            }
        }
        if (Wrapper.collectingTrace()) {
            CICSTraceService.getTraceService().exit(thisClassName, "callUserClass", (Object)userClassName);
        }
        cicsLog.logExit("callUserClass");
    }

    public static void handleReturnCode(ApplicationResponse response, String userClassName, int callType) {
        String thisMethod = "handleReturnCode";
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("handleReturnCode", new Object[]{response, userClassName, String.valueOf(callType)});
        }
        Throwable localThrown = response.getThrown();
        ApplicationResponse.ReturnCode rc = response.getReturnCode();
        if (localThrown != null) {
            CICSTraceService.exception((String)thisClassName, (String)"handleReturnCode", (Throwable)localThrown);
            if (localThrown instanceof IllegalArgumentException) {
                CICSMessageService.getMessageService().msg(1L, thisClassName, "handleReturnCode", "CICS_MESSAGE SJ 905", "", (Object)userClassName);
            }
            if (callType == 1) {
                CICSMessageService.getMessageService().msg(2L, thisClassName, "handleReturnCode", "CICS_MESSAGE SJ 926", "", (Object)localThrown.toString(), (Object)userClassName);
            } else {
                CICSMessageService.getMessageService().msg(2L, thisClassName, "handleReturnCode", "CICS_MESSAGE SJ 904", "", (Object)localThrown.toString(), (Object)userClassName);
            }
        }
        if (rc == ApplicationResponse.ReturnCode.ABEND_RECEIVED_AND_SET) {
            if (localThrown instanceof AbendException) {
                cicsLog.logExit("handleReturnCode", new Object[]{"Throw exception = " + localThrown.toString()});
                throw (AbendException)localThrown;
            }
            if (localThrown instanceof ThreadDeath) {
                cicsLog.logExit("handleReturnCode", new Object[]{"Throw exception = " + localThrown.toString()});
                throw (ThreadDeath)localThrown;
            }
            if (localThrown instanceof AbendCancelException) {
                cicsLog.logExit("handleReturnCode", new Object[]{"Throw exception = " + localThrown.toString()});
                throw (AbendCancelException)localThrown;
            }
        }
        if (EnvironmentConstants.env.isThreadPoolActive() && Wrapper.getApiStatus(false) != 2) {
            cicsLog.logExit("handleReturnCode", new Object[]{"No TRANSACTION to abend"});
            return;
        }
        String abcode = Wrapper.getAbendCode(rc.getNumericValue());
        Wrapper.setAbendFromDelegate(abcode);
        RuntimeException e = new RuntimeException(abcode, localThrown);
        cicsLog.logExit("handleReturnCode", new Object[]{"Throw exception = " + e.toString()});
        throw e;
    }

    private static String getAbendCode(int value) {
        return value > 9 ? "AJ" + value : "AJ0" + value;
    }

    private static void terminateTask(Task theTask) {
        cicsLog.logEntryExit("terminateTask", new Object[]{"Thread.stop(TASK) = " + theTask.getTaskNumber()});
        try {
            theTask.getTaskThread().stop();
        }
        catch (ThreadDeath threadDeath) {
            // empty catch block
        }
    }

    public static void set_jvmserver_disabling(String[] args) {
        cicsLog.logEntryExit("set_jvmserver_disabling", new Object[0]);
        try {
            Wrapper.getDelegateWrapper().dtcMarkJvmserverDisabling();
        }
        catch (DelegateError err) {
            DelegateErrorHandler.handleUncheckedError(err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void terminateAllTasks() {
        Object object;
        String thisMethod = "terminateAllTasks";
        if (runningTasks == null && runningDSTasks == null) {
            cicsLog.logEvent("terminateAllTasks", new Object[]{"none to terminate"});
            return;
        }
        Task currentTask = null;
        if (runningTasks != null) {
            object = runningTasks;
            synchronized (object) {
                ListIterator<Task> it = runningTasks.listIterator();
                while (it.hasNext()) {
                    currentTask = it.next();
                    try {
                        int threadLocation = Wrapper.getDelegateWrapper().dtcGetThreadLocation(currentTask.getThreadPosition());
                        if (threadLocation != 1) continue;
                        Wrapper.terminateTask(currentTask);
                        it.remove();
                    }
                    catch (DelegateError err) {
                        DelegateErrorHandler.handleUncheckedError(err);
                    }
                }
            }
        }
        if (runningDSTasks != null) {
            object = runningDSTasks;
            synchronized (object) {
                Collection<Thread> threads = runningDSTasks.values();
                Iterator<Thread> it = threads.iterator();
                while (it.hasNext()) {
                    Thread theThread = it.next();
                    if (cicsLog.shouldTrace(LogType.DEBUG)) {
                        cicsLog.logDebug("terminateAllTasks", new Object[]{"Thread.stop(DS_TASK) = " + theThread.getName() + ":" + (Object)((Object)theThread.getState())});
                    }
                    try {
                        theThread.stop();
                    }
                    catch (ThreadDeath threadDeath) {
                        // empty catch block
                    }
                    it.remove();
                }
            }
        }
    }

    @InjectLogging
    private static ApplicationResponse checkRealException(InvocationTargetException invocationTargetException) {
        InvocationTargetException ITE;
        cicsLog.logEntry("checkRealException", new Object[]{invocationTargetException});
        String thisMethod = "checkRealException";
        ApplicationResponse response = new ApplicationResponse(ApplicationResponse.ReturnCode.INVOCATION_TARGET_EXCEPTION);
        Throwable cause = ITE.getCause();
        if (cause instanceof InvocationTargetException) {
            ApplicationResponse applicationResponse = Wrapper.checkRealException((InvocationTargetException)cause);
            cicsLog.logExit("checkRealException", new Object[]{applicationResponse});
            return applicationResponse;
        }
        if (cause instanceof IllegalArgumentException) {
            response.setThrown(cause);
            response.setReturnCode(ApplicationResponse.ReturnCode.UNEXPECTED_EXCEPTION);
        } else if (cause instanceof NullPointerException) {
            response.setThrown(cause);
            response.setReturnCode(ApplicationResponse.ReturnCode.UNEXPECTED_EXCEPTION);
        }
        if (cause instanceof ExceptionInInitializerError) {
            cause.printStackTrace(System.err);
            CICSTraceService.exception((String)thisClassName, (String)"checkRealException", (Throwable)cause);
            response.setThrown(((ExceptionInInitializerError)cause).getException());
            CICSMessageService.getMessageService().msg(2L, thisClassName, "checkRealException", "CICS_MESSAGE SJ 903", "", (Object)cause.toString());
            response.setReturnCode(ApplicationResponse.ReturnCode.UNEXPECTED_EXCEPTION);
        }
        if (cause instanceof SecurityException) {
            response.setThrown(cause);
            response.setReturnCode(ApplicationResponse.ReturnCode.UNEXPECTED_EXCEPTION);
        }
        if (cause instanceof NoSuchMethodException || cause instanceof NoSuchMethodError) {
            response.setThrown(cause);
            response.setReturnCode(ApplicationResponse.ReturnCode.NO_SUCH_METHOD_ERROR);
        }
        try {
            response = Wrapper.interpretUserException(cause);
        }
        catch (NoClassDefFoundError e) {
            if (e.getCause() == null) {
                e.initCause(cause);
            }
            response = new ApplicationResponse(ApplicationResponse.ReturnCode.NO_CLASS_DEF_FOUND_ERROR);
            response.setThrown(e);
            cicsLog.logError("checkRealException", new Object[]{e});
        }
        ApplicationResponse applicationResponse = response;
        cicsLog.logExit("checkRealException", new Object[]{applicationResponse});
        return applicationResponse;
    }

    @InjectLogging
    public static ApplicationResponse interpretUserException(Throwable throwable) {
        Throwable userException;
        cicsLog.logEntry("interpretUserException", new Object[]{throwable});
        String thisMethod = "interpretUserException";
        ApplicationResponse response = new ApplicationResponse(ApplicationResponse.ReturnCode.INVOCATION_TARGET_EXCEPTION);
        response.setThrown(userException);
        if (userException instanceof CicsConditionException) {
            try {
                if (Wrapper.getApiStatus(false) == 2) {
                    Wrapper.setAbendForConditionFromDelegate(((CicsConditionException)userException).getRESPCode().getValue());
                }
            }
            catch (RuntimeException re) {
                int levelOfExceptionNesting;
                cicsLog.logDebug("interpretUserException", new Object[]{"Adding original exception to runtime exception before sending to FFDC", re});
                Throwable t = re;
                int maxLevelOfExceptionNesting = 1000;
                for (levelOfExceptionNesting = 0; t.getCause() != null && levelOfExceptionNesting < maxLevelOfExceptionNesting; ++levelOfExceptionNesting) {
                    cicsLog.logDebug("interpretUserException", new Object[]{"exception already has a cause set, so try to add the root cause to that ", t});
                    t = t.getCause();
                }
                if (levelOfExceptionNesting < maxLevelOfExceptionNesting) {
                    cicsLog.logDebug("interpretUserException", new Object[]{"Adding original exception to end of runtime exception chain"});
                    t.initCause(userException);
                } else {
                    cicsLog.logDebug("interpretUserException", new Object[]{"Maximum level of exception nesting reached. Not traversing further as it looks like a loop.", String.valueOf(levelOfExceptionNesting)});
                }
                throw re;
            }
            response.setReturnCode(ApplicationResponse.ReturnCode.CONDITION_RECEIVED);
        } else if (userException instanceof AbendException) {
            String abcode = ((AbendException)userException).getABCODE();
            Wrapper.setAbendFromDelegate(abcode);
            response.setReturnCode(ApplicationResponse.ReturnCode.ABEND_RECEIVED_AND_SET);
        } else if (userException instanceof AbendCancelException) {
            String abcode = ((AbendCancelException)userException).getABCODE();
            Wrapper.setAbendFromDelegate(abcode);
            response.setReturnCode(ApplicationResponse.ReturnCode.ABEND_RECEIVED_AND_SET);
        } else if (userException instanceof ThreadDeath) {
            response.setReturnCode(ApplicationResponse.ReturnCode.ABEND_RECEIVED_AND_SET);
        } else {
            response.setReturnCode(ApplicationResponse.ReturnCode.INVOCATION_TARGET_EXCEPTION);
        }
        ApplicationResponse applicationResponse = response;
        cicsLog.logExit("interpretUserException", new Object[]{applicationResponse});
        return applicationResponse;
    }

    public static void jvmServerWrapperEntry(String[] args) {
        String thisMethod = "jvmServerWrapperEntry";
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            debugPrefix.set("[" + Thread.currentThread().getName() + "] ");
            cicsLog.logEntry("jvmServerWrapperEntry", new Object[]{"args = " + Arrays.toString(args)});
        }
        Task currentTask = Wrapper.initWrapper();
        Wrapper.jvmServerProcessArgs(currentTask);
        try {
            Wrapper.invokeJvmServerUserClass(args, currentTask);
        }
        catch (Throwable t) {
            cicsLog.logError("jvmServerWrapperEntry", "Problem detected", t);
            throw t;
        }
        finally {
            Wrapper.driveTidyUp(currentTask);
        }
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            cicsLog.logExit("jvmServerWrapperEntry");
        }
    }

    @InjectLogging
    public static void jvmServerStats(String[] stringArray) {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("jvmServerStats", new Object[]{stringArray});
        }
        serverStatsCollector.collectServerStats();
        cicsLog.logExit("jvmServerStats");
    }

    public static void jvmServerTerminate(String[] args) {
        String thisMethod = "jvmServerTerminate";
        cicsLog.logEntry("jvmServerTerminate", new Object[]{"args = " + Arrays.toString(args)});
        Wrapper.terminateAllTasks();
        if (IS_LIBERTY) {
            ThreadStopper.terminateThreads((ThreadStopper.ThreadTypes)ThreadStopper.ThreadTypes.NonDaemon);
        } else {
            cicsLog.logDebug("jvmServerTerminate", new Object[]{"ThreadStopper bypassed"});
        }
        cicsLog.logExit("jvmServerTerminate");
    }

    @InjectLogging
    public static void jvmServerTaskTerminate(String string) {
        cicsLog.logEntry("jvmServerTaskTerminate", new Object[]{string});
        if (runningTasks != null) {
            for (Task task : runningTasks) {
                String trannum;
                int tasknum = task.getTaskNumber();
                if (tasknum != Integer.parseInt(trannum)) continue;
                cicsLog.logEvent("jvmServerTaskTerminate", new Object[]{"terminating TASK = ", String.valueOf(tasknum)});
                Wrapper.terminateTask(task);
            }
        }
        cicsLog.logExit("jvmServerTaskTerminate");
    }

    public static int getApiStatus(boolean lateBind) {
        return IsCICS.getApiStatus(lateBind);
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public static Task threadPoolBindDTC(byte[] byArray, byte[] byArray2) {
        void transactionGroupID;
        byte[] originData;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("threadPoolBindDTC", new Object[]{byArray, byArray2});
        }
        Task t = Wrapper.initOSGiWrapper();
        t.setOriginData(originData, (byte[])transactionGroupID);
        Wrapper.addTask(t);
        Task task = t;
        cicsLog.logExit("threadPoolBindDTC", new Object[]{task});
        return task;
    }

    @InjectLogging
    public static void threadPoolUnbindDTC(Task task) {
        Task currentTask;
        cicsLog.logEntry("threadPoolUnbindDTC", new Object[]{task});
        Wrapper.driveTidyUp(currentTask);
        Wrapper.removeTask(currentTask);
        cicsLog.logExit("threadPoolUnbindDTC");
    }

    public static void main(String[] args) {
        String thisMethod = "main";
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            cicsLog.logEntry("main", new Object[]{"args = " + Arrays.toString(args)});
            debugPrefix.set("[" + Thread.currentThread().getName() + "] ");
        }
        Task currentTask = Wrapper.initWrapper();
        Wrapper.processArgs(args, currentTask);
        Wrapper.invokeUserClass(args, currentTask);
        Wrapper.driveTidyUp(currentTask);
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            cicsLog.logExit("main");
        }
    }

    @InjectLogging
    private static Task initWrapper() {
        cicsLog.logEntry("initWrapper");
        String thisMethod = "initWrapper";
        RASInitializationProtector.reset();
        if (contextCL == null) {
            contextCL = Thread.currentThread().getContextClassLoader();
        }
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            cicsLog.logDebug("initWrapper", new Object[]{"contextCL = " + contextCL.toString()});
        }
        if (fullJavaVersion == null) {
            if (EnvironmentConstants.env.isDisplayJavaVersionWanted()) {
                fullJavaVersion = EnvironmentConstants.env.getJavaFullVersion();
                CICSMessageService.getMessageService().msg(1L, thisClassName, "initWrapper", "CICS_MESSAGE SJ 901", "", (Object)JVMSERVER_NAME, (Object)fullJavaVersion);
            } else {
                fullJavaVersion = "NOT REQUESTED";
            }
        }
        Task currentTask = Task.getTask();
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            cicsLog.logDebug("initWrapper", new Object[]{"Task object = " + currentTask.getTaskNumber()});
        }
        if (originalSTDOUT == null) {
            originalSTDOUT = System.out;
        }
        if (originalSTDERR == null) {
            originalSTDERR = System.err;
        }
        Task task = currentTask;
        cicsLog.logExit("initWrapper", new Object[]{task});
        return task;
    }

    @InjectLogging
    private static Task initOSGiWrapper() {
        cicsLog.logEntry("initOSGiWrapper");
        String thisMethod = "initOSGiWrapper";
        RASInitializationProtector.reset();
        if (fullJavaVersion == null) {
            if (EnvironmentConstants.env.isDisplayJavaVersionWanted()) {
                fullJavaVersion = EnvironmentConstants.env.getJavaFullVersion();
                CICSMessageService.getMessageService().msg(1L, thisClassName, "initOSGiWrapper", "CICS_MESSAGE SJ 901", "", (Object)JVMSERVER_NAME, (Object)fullJavaVersion);
            } else {
                fullJavaVersion = "NOT REQUESTED";
            }
        }
        if (IS_LIBERTY && !libertyVersionShown) {
            libertyVersionShown = true;
            File wlpReadMeFile = new File(EnvironmentConstants.env.getLibertyInstallDir() + "/README.TXT");
            String wlpVersionString = null;
            String errorMessage = null;
            try (Scanner scanner = new Scanner(wlpReadMeFile);){
                if (scanner.hasNext()) {
                    wlpVersionString = scanner.nextLine();
                } else {
                    errorMessage = "File " + wlpReadMeFile.getAbsolutePath() + " is empty";
                    cicsLog.logError("initOSGiWrapper", "Unable to determine Liberty version. " + errorMessage, null);
                }
            }
            catch (FileNotFoundException e) {
                errorMessage = "Exception occured: " + e.getMessage();
                cicsLog.logError("initOSGiWrapper", "Unable to determine Liberty version from " + wlpReadMeFile.getAbsolutePath(), (Throwable)e);
            }
            if (wlpVersionString != null) {
                String pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
                CICSMessageService.getMessageService().msg(1L, thisClassName, "initOSGiWrapper", "CICS_MESSAGE SJ 1405", "", new Object[]{JVMSERVER_NAME, wlpVersionString, pid});
                Logger LOGGER = Logger.getLogger(Wrapper.class.getName());
                LOGGER.logp(Level.INFO, Wrapper.class.getName(), "initOSGiWrapper", "DFHSJ1405I: " + wlpVersionString);
                cicsLog.logInfo("initOSGiWrapper", new Object[]{wlpVersionString});
            } else {
                CICSMessageService.getMessageService().msg(1L, thisClassName, "initOSGiWrapper", "CICS_MESSAGE SJ 1406", "", new Object[]{JVMSERVER_NAME, errorMessage});
            }
        }
        Task currentTask = Task.getTask();
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            cicsLog.logDebug("initOSGiWrapper", new Object[]{"Task object = " + currentTask.getTaskNumber()});
            cicsLog.logDebug("initOSGiWrapper", new Object[]{"Task threadname = " + currentTask.getThreadName()});
        }
        if (originalSTDOUT == null) {
            originalSTDOUT = System.out;
        }
        if (originalSTDERR == null) {
            originalSTDERR = System.err;
        }
        Task task = currentTask;
        cicsLog.logExit("initOSGiWrapper", new Object[]{task});
        return task;
    }

    private static void processArgs(String[] args, Task currentTask) {
        String thisMethod = "processArgs";
        ApplicationResponse response = new ApplicationResponse(ApplicationResponse.ReturnCode.SUCCESS);
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            int taskNum = 0;
            if (currentTask != null) {
                taskNum = currentTask.getTaskNumber();
            }
            cicsLog.logEntry("processArgs", new Object[]{"Task = " + taskNum + " args = " + Arrays.toString(args)});
        }
        if (!checkedIfOSGi) {
            checkedIfOSGi = true;
            ClassLoader wrapperClassLoader = Wrapper.class.getClassLoader();
            HashSet superclasses = new HashSet();
            Wrapper.getSuperClassesAndInterfaces(wrapperClassLoader.getClass(), superclasses);
            for (Class clazz : superclasses) {
                if (!"org.osgi.framework.BundleReference".equals(clazz.getName())) continue;
                isOSGi = true;
                break;
            }
        }
        if (args.length > 1 && args[1].length() != 0) {
            String outClassName = args[1].replace('/', '.');
            try {
                if (outHandler == null) {
                    if (isOSGi) {
                        oStream = OSGiWrapper.getOutputRedirectionPlugin(outClassName);
                        if (oStream == null) {
                            throw new ClassNotFoundException(outClassName);
                        }
                        outClass = oStream.getClass();
                        oStream = (OutputStream)outClass.newInstance();
                    } else {
                        outClass = Class.forName(outClassName);
                        oStream = (OutputStream)outClass.newInstance();
                    }
                    outHandler = new PrintStream(oStream);
                    if (Wrapper.collectingTrace()) {
                        CICSTraceService.getTraceService().trace(4096L, thisClassName, "processArgs", outClassName, (Object)"stdout");
                    }
                    System.out.flush();
                    System.setOut(outHandler);
                }
                if (oStream instanceof OutputRedirectionPlugin && currentTask != null) {
                    boolean superclasses = ((OutputRedirectionPlugin)((Object)oStream)).initRedirect("stdout", originalSTDOUT, applid, currentTask.getProgramName(), currentTask.getTaskNumberInteger(), currentTask.getTransactionName());
                }
            }
            catch (ClassNotFoundException CNFE) {
                response.setThrown(CNFE);
                CICSTraceService.exception((String)thisClassName, (String)"processArgs", (Throwable)CNFE);
                CICSMessageService.getMessageService().msg(4L, thisClassName, "processArgs", "CICS_MESSAGE SJ 906", "", (Object)outClassName);
                CNFE.printStackTrace(System.err);
            }
            catch (Exception exc) {
                response.setThrown(exc);
                CICSMessageService.getMessageService().msg(4L, thisClassName, "processArgs", "CICS_MESSAGE SJ 907", "", (Object)outClassName, (Object)exc);
                exc.printStackTrace();
            }
        }
        if (args.length > 2 && args[2].length() != 0) {
            String errClassName = args[2].replace('/', '.');
            try {
                if (errHandler == null) {
                    if (isOSGi) {
                        eStream = OSGiWrapper.getOutputRedirectionPlugin(errClassName);
                        if (eStream == null) {
                            throw new ClassNotFoundException(errClassName);
                        }
                        errClass = eStream.getClass();
                        eStream = (OutputStream)errClass.newInstance();
                    } else {
                        errClass = Class.forName(errClassName);
                        eStream = (OutputStream)errClass.newInstance();
                    }
                    errHandler = new PrintStream(eStream);
                    if (Wrapper.collectingTrace()) {
                        CICSTraceService.getTraceService().trace(4096L, thisClassName, "processArgs", errClassName, (Object)"stderr");
                    }
                    System.err.flush();
                    System.setErr(errHandler);
                }
                if (eStream instanceof OutputRedirectionPlugin && currentTask != null) {
                    boolean exc = ((OutputRedirectionPlugin)((Object)eStream)).initRedirect("stderr", originalSTDERR, applid, currentTask.getProgramName(), currentTask.getTaskNumberInteger(), currentTask.getTransactionName());
                }
            }
            catch (ClassNotFoundException CNFE) {
                response.setThrown(CNFE);
                CICSTraceService.exception((String)thisClassName, (String)"processArgs", (Throwable)CNFE);
                CICSMessageService.getMessageService().msg(1L, thisClassName, "processArgs", "CICS_MESSAGE SJ 906", "", (Object)errClassName);
                CNFE.printStackTrace(System.err);
            }
            catch (Exception exc) {
                response.setThrown(exc);
                CICSMessageService.getMessageService().msg(4L, thisClassName, "processArgs", "CICS_MESSAGE SJ 907", "", (Object)errClassName, (Object)exc);
                exc.printStackTrace();
            }
        }
        cicsLog.logExit("processArgs");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    private static void getSuperClassesAndInterfaces(Class<?> clazz, Set<Class<?>> set) {
        void superclasses;
        Class<?> class1;
        cicsLog.logEntry("getSuperClassesAndInterfaces", new Object[]{clazz, set});
        for (Class<?> interface1 : class1.getInterfaces()) {
            superclasses.add(interface1);
            Wrapper.getSuperClassesAndInterfaces(interface1, superclasses);
        }
        Class<?> superclass = class1.getSuperclass();
        if (superclass != null) {
            superclasses.add(superclass);
            Wrapper.getSuperClassesAndInterfaces(superclass, superclasses);
        }
        cicsLog.logExit("getSuperClassesAndInterfaces");
    }

    private static void jvmServerProcessArgs(Task currentTask) {
        String arg0;
        String thisMethod = "jvmServerProcessArgs";
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            int taskNum = 0;
            if (currentTask != null) {
                taskNum = currentTask.getTaskNumber();
            }
            cicsLog.logEntry("jvmServerProcessArgs", new Object[]{"Task", String.valueOf(taskNum)});
        }
        if ((arg0 = EnvironmentConstants.env.getUserOutputClass()) == "") {
            return;
        }
        String arg1 = arg0;
        String arg2 = arg0;
        String[] mockArgs = new String[]{arg0, arg1, arg2};
        Wrapper.processArgs(mockArgs, currentTask);
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            cicsLog.logExit("jvmServerProcessArgs");
        }
    }

    private static void invokeUserClass(String[] args, Task currentTask) {
        String thisMethod = "invokeUserClass";
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            cicsLog.logEntry("invokeUserClass", new Object[]{"Task = " + currentTask.getTaskNumber() + ", args = " + Arrays.toString(args)});
        }
        Wrapper.callUserClass(args, currentTask);
        Thread.currentThread().setContextClassLoader(contextCL);
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            cicsLog.logExit("invokeUserClass");
        }
    }

    private static void invokeJvmServerUserClass(String[] args, Task currentTask) {
        String thisMethod = "invokeJvmServerUserClass";
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("invokeJvmServerUserClass", new Object[]{"Task = " + currentTask.getTaskNumber()});
        }
        try {
            Wrapper.addTask(currentTask);
            Wrapper.callUserClass(args, currentTask);
        }
        finally {
            Wrapper.removeTask(currentTask);
            Thread.currentThread().setContextClassLoader(contextCL);
        }
        cicsLog.logExit("invokeJvmServerUserClass");
    }

    private static void driveTidyUp(Task theTask) {
        String thisMethod = "driveTidyUp";
        Task currentTask = theTask;
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            int taskNum = 0;
            if (currentTask != null) {
                taskNum = currentTask.getTaskNumber();
            }
            cicsLog.logEntry("driveTidyUp", new Object[]{"Task = " + taskNum});
        }
        WrapperHelper.driveTidyUp();
        if (currentTask == null) {
            currentTask = Task.getTask();
        }
        if (Wrapper.isActiveDB2SQLJJDBC(currentTask)) {
            if (Wrapper.collectingTrace()) {
                CICSTraceService.getTraceService().trace(4096L, thisClassName, "driveTidyUp", TID_JDBC_PRE_CALL, (Object)"JDBC_pre_reset");
            }
            DelegateApplicationReturnCode rc = currentTask.jdbcReset();
            if (Wrapper.collectingTrace()) {
                CICSTraceService.getTraceService().trace(4096L, thisClassName, "driveTidyUp", TID_JDBC_POST_CALL, (Object)("JDBC_post_reset. rc=" + rc.toString()));
            }
            if (rc != DelegateApplicationReturnCode.SUCCESS) {
                throw new RuntimeException("currentTask.jdbcReset failed with " + rc);
            }
        }
        Wrapper.ibmJVMTidyUp();
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            cicsLog.logExit("driveTidyUp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jvmServerOSGiEntry(InvocationProxy classProxy, long threadId) {
        String thisMethod = "jvmServerOSGiEntry";
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            debugPrefix.set("[" + Thread.currentThread().getName() + "] ");
            cicsLog.logEntry("jvmServerOSGiEntry", new Object[]{"cicsPoolThreadId = " + threadId});
        }
        Task currentTask = null;
        if (threadId == 0L) {
            currentTask = Wrapper.initOSGiWrapper();
        }
        Wrapper.jvmServerProcessArgs(currentTask);
        try {
            Wrapper.invokeJvmServerOSGiClass(classProxy, currentTask, threadId);
        }
        finally {
            if (threadId == 0L) {
                Wrapper.driveTidyUp(currentTask);
            }
        }
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            cicsLog.logExit("jvmServerOSGiEntry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeJvmServerOSGiClass(InvocationProxy classProxy, Task currentTask, long threadId) {
        String thisMethod = "invokeJvmServerOSGiClass";
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            int taskNum = 0;
            if (currentTask != null) {
                taskNum = currentTask.getTaskNumber();
            }
            cicsLog.logEntry("invokeJvmServerOSGiClass", new Object[]{"cicsPoolThreadId = " + threadId + ", Task = " + taskNum});
        }
        try {
            if (threadId == 0L) {
                Wrapper.addTask(currentTask);
            } else {
                Wrapper.addDSTask(threadId);
            }
            Wrapper.callOSGiClass(classProxy, currentTask, threadId);
        }
        finally {
            if (threadId == 0L) {
                Wrapper.removeTask(currentTask);
            } else {
                Wrapper.removeDSTask(threadId);
            }
        }
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            cicsLog.logExit("invokeJvmServerOSGiClass");
        }
    }

    private static void callOSGiClass(InvocationProxy classProxy, Task currentTask, long threadId) throws AbendException, AbendCancelException, ThreadDeath {
        String s;
        Object o;
        String thisMethod = "callOSGiClass";
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            int taskNum = 0;
            if (currentTask != null) {
                taskNum = currentTask.getTaskNumber();
            }
            cicsLog.logEntry("callOSGiClass", new Object[]{"cicsPoolThreadId = " + threadId + ", Task = " + taskNum});
        }
        if (classProxy == null) {
            String abcode = "AJ0" + ApplicationResponse.ReturnCode.INVALID_ARGUMENTS.getNumericValue();
            Wrapper.setAbendFromDelegate(abcode);
            throw new RuntimeException(abcode);
        }
        ApplicationResponse response = new ApplicationResponse(ApplicationResponse.ReturnCode.SUCCESS);
        CommAreaHolder CAH = new CommAreaHolder();
        boolean inputCommArea = true;
        if (Wrapper.collectingTrace()) {
            CICSTraceService.getTraceService().entry(thisClassName, "callOSGiClass", (Object)classProxy.getClassName());
        }
        if (threadId == 0L && currentTask != null) {
            Thread.currentThread().setName(currentTask.getThreadName());
            CAH.value = Wrapper.getCommAreaFromDelegate(null, null);
            if (CAH.value == null) {
                inputCommArea = false;
                CAH.value = new byte[0];
            }
        }
        try {
            try {
                if (Wrapper.collectingTrace()) {
                    CICSTraceService.getTraceService().trace(4096L, thisClassName, "callOSGiClass", TID_2, (Object)classProxy.getClassName());
                }
                String[] arguments = threadId > 0L ? new String[]{Long.toString(threadId)} : new String[]{};
                classProxy.setArguments(CAH, arguments);
                response = Wrapper.call_main(classProxy);
                if (response.getReturnCode() == ApplicationResponse.ReturnCode.SUCCESS) {
                    if (inputCommArea) {
                        Wrapper.setCommAreaFromDelegate(null, null, CAH.value);
                    }
                    CAH.value = null;
                }
            }
            catch (NoSuchMethodException main_e) {
                response.setThrown(main_e);
                response.setReturnCode(ApplicationResponse.ReturnCode.NO_SUCH_METHOD_ERROR);
                cicsLog.logError("callOSGiClass", "", (Throwable)main_e);
            }
            catch (NoSuchMethodError NSME) {
                response.setThrown(NSME);
                response.setReturnCode(ApplicationResponse.ReturnCode.NO_SUCH_METHOD_ERROR);
                cicsLog.logError("callOSGiClass", "", (Throwable)NSME);
            }
        }
        catch (Throwable th) {
            response.setThrown(th);
            response.setReturnCode(ApplicationResponse.ReturnCode.UNEXPECTED_EXCEPTION);
            cicsLog.logError("callOSGiClass", "", th);
        }
        if (response.getReturnCode() != ApplicationResponse.ReturnCode.SUCCESS) {
            Wrapper.handleReturnCode(response, classProxy.getClassName(), 0);
        }
        if (threadId == 0L && currentTask != null && (o = currentTask.getPrincipalFacility()) instanceof TerminalPrincipalFacility && (s = ((TerminalPrincipalFacility)o).getNextTransaction()) != null) {
            TerminalPrincipalFacility term = (TerminalPrincipalFacility)o;
            term.setNextTransaction(null);
            Channel nextChan = term.getNextChannel();
            byte[] commArea = term.getNextCOMMAREA();
            if (nextChan != null && commArea != null) {
                Wrapper.setAbendForConditionFromDelegate(CicsConditionException.RESPCODE.INVREQ.getValue());
            }
            DelegateProgramCaller caller = DelegateFactoryLoader.getDelegateFactory().getDelegateProgramCaller();
            try {
                if (nextChan != null) {
                    caller.returnExplicitly(s, null, nextChan.getName());
                } else {
                    caller.returnExplicitly(s, commArea, null);
                }
            }
            catch (DelegateError err) {
                DelegateErrorHandler.handleUncheckedError(err);
            }
        }
        if (Wrapper.collectingTrace()) {
            CICSTraceService.getTraceService().exit(thisClassName, "callOSGiClass", (Object)classProxy.getClassName());
        }
        if (cicsLog.shouldTrace(LogType.DEBUG)) {
            cicsLog.logExit("callOSGiClass");
        }
    }

    public static byte[] getOriginDataForCurrentTask() {
        Task t = Task.getTask();
        return t.getOriginData();
    }

    public static byte[] getTransactionGroupId() {
        Task t = Task.getTask();
        return t.getTransactionGroupID();
    }

    public static ApplicationResponse interpretSystemException(Throwable systemException, String classIdentifier) {
        String thisMethod = "interpretSystemException";
        cicsLog.logEntry("interpretSystemException", new Object[]{"Exception", systemException});
        ApplicationResponse response = new ApplicationResponse(ApplicationResponse.ReturnCode.UNEXPECTED_EXCEPTION);
        response.setThrown(systemException);
        if (systemException instanceof InstantiationException) {
            response.setReturnCode(ApplicationResponse.ReturnCode.CLASS_NOT_INSTANTIABLE_ERROR);
            CICSMessageService.getMessageService().msg(2L, thisClassName, "interpretSystemException", "CICS_MESSAGE SJ 925", "", (Object)systemException.toString(), (Object)classIdentifier);
        } else if (systemException instanceof ExceptionInInitializerError) {
            systemException.printStackTrace(System.err);
            response.setReturnCode(ApplicationResponse.ReturnCode.CLASS_NOT_INSTANTIABLE_ERROR);
            CICSTraceService.exception((String)thisClassName, (String)"interpretSystemException", (Throwable)systemException);
            response.setThrown(systemException.getCause());
        }
        cicsLog.logExit("interpretSystemException", new Object[]{"rc = " + (Object)((Object)response.getReturnCode())});
        return response;
    }

    public static void setThreadPoolReady(boolean value) {
        CICSExecutorService.setThreadPoolReady(value);
    }

    static {
        if (EnvironmentConstants.env == null) {
            EnvironmentImpl newEnv = new EnvironmentImpl();
            newEnv.validate();
            EnvironmentConstants.setEnvironment((Environment)newEnv);
        }
        applid = EnvironmentConstants.env.getApplid();
        IS_LIBERTY = EnvironmentConstants.env.isLiberty();
        debugPrefix = CICSThreadLocalManager.createThreadLocal();
        MAIN_STRING_ARRAY_PARAMETERS = new Class[1];
        MAIN_COMMAREA_PARAMETERS = new Class[1];
        Wrapper.MAIN_STRING_ARRAY_PARAMETERS[0] = String[].class;
        Wrapper.MAIN_COMMAREA_PARAMETERS[0] = CommAreaHolder.class;
        libertyVersionShown = false;
        JVMSERVER_NAME = EnvironmentConstants.env.getJVMServerName();
        serverStatsCollector = DelegateFactoryLoader.getDelegateFactory().createServerStatsCollector();
    }

    public static class ApplicationResponse {
        private ReturnCode returnCode;
        private Throwable thrown = null;

        public ApplicationResponse(ReturnCode returnCode) {
            this.returnCode = returnCode;
        }

        public void setReturnCode(ReturnCode returnCode) {
            this.returnCode = returnCode;
        }

        public ReturnCode getReturnCode() {
            return this.returnCode;
        }

        public void setThrown(Throwable t) {
            this.thrown = t;
        }

        public Throwable getThrown() {
            return this.thrown;
        }

        public static enum ReturnCode {
            SUCCESS(0),
            INVALID_ARGUMENTS(1),
            CONDITION_RECEIVED(3),
            UNEXPECTED_EXCEPTION(4),
            INVOCATION_TARGET_EXCEPTION(5),
            NO_CLASS_DEF_FOUND_ERROR(7),
            NO_SUCH_METHOD_ERROR(9),
            JDBC_STATIC_GET_CLASS_FAILED(10),
            JDBC_STATIC_GET_METHOD_FAILED(11),
            JDBC_STATIC_INVOKE_METHOD_FAILED(12),
            CLASS_NOT_INSTANTIABLE_ERROR(13),
            ABEND_RECEIVED_AND_SET(22);

            private int numericValue;

            private ReturnCode(int numericValue) {
                this.numericValue = numericValue;
            }

            public int getNumericValue() {
                return this.numericValue;
            }
        }
    }
}

