/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.jvmevents.DelegateEventResponder;
import com.ibm.cics.server.internal.OSGiWrapper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

@InjectLogging(isEnabled=false)
public class Activator
implements BundleActivator {
    private static final Logger cicsLog = LoggerFactory.getLogger(Activator.class);
    private static boolean isShutdownExpected = false;
    private static DelegateEventResponder eventResponder;

    public static void setEventResponder(DelegateEventResponder responder) {
        eventResponder = responder;
    }

    @InjectLogging
    public void stop(BundleContext bundleContext) throws Exception {
        cicsLog.logEntry("stop", new Object[]{bundleContext});
        OSGiWrapper.cleanUpServices();
        if (!isShutdownExpected && eventResponder != null) {
            eventResponder.postSelfTermination();
            cicsLog.logEvent("Terminating EventResponder", new Object[0]);
        }
        cicsLog.logExit("stop");
    }

    public void start(BundleContext arg0) throws Exception {
        cicsLog.logEntryExit("Server bundle activated", new Object[0]);
    }

    public static void setExpectShutDown(boolean newValue) {
        isShutdownExpected = newValue;
    }
}

