/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal;

import com.ibm.cics.common.CICSThreadLocalManager;
import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateCicsApiPermissions;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.DelegateIsCics;
import com.ibm.cics.osgi.CICSTaskService;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.TaskAlreadyBoundRuntimeException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@InjectLogging(isEnabled=false)
public class ApiState {
    private static final ThreadLocal<Integer> cachedResults = CICSThreadLocalManager.createThreadLocal();
    private static CICSTaskService taskService;
    private static Logger cicsLog;

    public static int getApiStatus(boolean lateBind, boolean inLibertyAndThreadPoolActive) {
        String thisMethod = "getApiStatus";
        int apiStatus = -1;
        if (cicsLog == null) {
            cicsLog = LoggerFactory.getLogger(ApiState.class);
        }
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("getApiStatus", new Object[]{"lateBind", Boolean.toString(lateBind), "inLibertyAndThreadPoolActive", Boolean.toString(inLibertyAndThreadPoolActive)});
        }
        if (inLibertyAndThreadPoolActive) {
            apiStatus = ApiState.checkApiAllowedAndThreadLocal(apiStatus);
        }
        if (apiStatus == -1) {
            apiStatus = ApiState.checkCachedResultsStatus(apiStatus);
        }
        try {
            if (apiStatus == -1) {
                DelegateCicsApiPermissions permissions = ApiState.callDelegateIsCics();
                apiStatus = ApiState.getStatus(permissions);
                cachedResults.set(apiStatus);
            }
        }
        catch (Exception e) {
            cicsLog.logError("getApiStatus", "caught exception", (Throwable)e);
        }
        catch (UnsatisfiedLinkError ule) {
            cicsLog.logError("getApiStatus", "native code not available!", (Throwable)ule);
        }
        if (apiStatus == 1 && lateBind && inLibertyAndThreadPoolActive) {
            apiStatus = ApiState.doLateBind(apiStatus);
        }
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            cicsLog.logExit("getApiStatus", new Object[]{"the apiStatus (value)", Integer.toString(apiStatus), "the apiStatus (name)", DelegateCicsApiPermissions.findFromValue((int)apiStatus).name()});
        }
        return apiStatus;
    }

    @InjectLogging
    private static int doLateBind(int n) {
        BundleContext ctx;
        ServiceReference servRef;
        int theApiStatus;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("doLateBind", new Object[]{new Integer(n)});
        }
        String thisMethod = "doLateBind";
        int apiStatus = theApiStatus;
        if (taskService == null && (servRef = (ctx = FrameworkUtil.getBundle(CICSTaskService.class).getBundleContext()).getServiceReference(CICSTaskService.class)) != null) {
            taskService = (CICSTaskService)ctx.getService(servRef);
        }
        if (taskService != null) {
            try {
                if (taskService.bindTask()) {
                    cicsLog.logEvent("doLateBind", new Object[]{"Task bound to current thread. Setting CICS_REGION_AND_API_ALLOWED"});
                    apiStatus = 2;
                }
            }
            catch (TaskAlreadyBoundRuntimeException tabe) {
                throw new RuntimeException("Unexpected condition", tabe);
            }
        }
        int n2 = apiStatus;
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            int n3 = n2;
            cicsLog.logExit("doLateBind", new Object[]{new Integer(n3)});
            n2 = n3;
        }
        return n2;
    }

    private static int getStatus(DelegateCicsApiPermissions permissions) {
        int status;
        switch (permissions) {
            case NOT_CICS_REGION: {
                status = 0;
                break;
            }
            case CICS_REGION_BUT_API_DISALLOWED: {
                status = 1;
                break;
            }
            case CICS_REGION_AND_API_ALLOWED: {
                status = 2;
                break;
            }
            case UNABLE_TO_DETERMINE_STATUS: {
                status = -1;
                break;
            }
            default: {
                String msg = "Logic error. Unexpected return value from ApiState.getStatus";
                throw new RuntimeException(msg);
            }
        }
        if (cicsLog.shouldTrace(LogType.EVENT)) {
            cicsLog.logEvent("getStatus", new Object[]{"permissions", Integer.toString(permissions.getValue()), ": status", Integer.toString(status)});
        }
        return status;
    }

    private static DelegateCicsApiPermissions callDelegateIsCics() {
        String thisMethod = "callDelegateIsCics";
        DelegateIsCics delegate = DelegateFactoryLoader.getDelegateFactory().getDelegateIsCics();
        DelegateCicsApiPermissions permissions = DelegateCicsApiPermissions.NOT_CICS_REGION;
        try {
            permissions = delegate.isCics();
        }
        catch (DelegateError err) {
            cicsLog.logError("callDelegateIsCics", "exception:", (Throwable)err);
            DelegateErrorHandler.handleUncheckedError(err);
        }
        if (cicsLog.shouldTrace(LogType.EVENT)) {
            cicsLog.logEvent("callDelegateIsCics", new Object[]{"permissions.getValue()", Integer.toString(permissions.getValue())});
        }
        return permissions;
    }

    private static int checkCachedResultsStatus(int theApiStatus) {
        int apiStatus = theApiStatus;
        Integer cachedResult = cachedResults.get();
        if (cachedResult != null) {
            apiStatus = cachedResult;
        }
        cicsLog.logEvent("checkCachedResultsStatus", new Object[]{"apiStatus", Integer.toString(apiStatus)});
        return apiStatus;
    }

    private static int checkApiAllowedAndThreadLocal(int theApiStatus) {
        ThreadLocal apiAllowed = CICSThreadLocalManager.getThreadLocal((String)"API_ALLOWED");
        int apiStatus = theApiStatus;
        if (apiAllowed != null && apiAllowed.get() != null) {
            apiStatus = (Boolean)apiAllowed.get() == Boolean.TRUE ? 2 : 1;
        }
        cicsLog.logEvent("checkApiAllowedAndThreadLocal", new Object[]{"apiStatus", Integer.toString(apiStatus)});
        return apiStatus;
    }
}

