/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal;

import com.ibm.cics.common.CICSThreadLocalManager;
import com.ibm.cics.common.EnvironmentConstants;
import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.DelegateThreadFactory;
import com.ibm.cics.osgi.CICSThreadJoiner;
import com.ibm.cics.osgi.classification.ICICSHttpRunnable;
import com.ibm.cics.server.CICSTransactionCallable;
import com.ibm.cics.server.CICSTransactionRunnable;
import com.ibm.cics.server.CICSWebAppStateHolder;
import com.ibm.cics.server.CicsThreadingRuntimeException;
import com.ibm.cics.server.FutureWrapper;
import com.ibm.cics.server.Task;
import com.ibm.cics.server.Wrapper;
import com.ibm.cics.server.internal.TrackedRunnable;
import com.ibm.cics.wlp.CICSHttpRunnableExtended;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import org.osgi.framework.ServiceReference;

@InjectLogging(isEnabled=false)
public class CICSBasicThreadFactory
implements ThreadFactory,
CICSThreadJoiner {
    static final Logger cicsLog = LoggerFactory.getLogger(CICSBasicThreadFactory.class);
    static final boolean IS_LIBERTY = EnvironmentConstants.env.isLiberty();
    protected static int THREAD_JOIN_TIMEOUT;
    private static int TRIGGER_TIMEOUT;
    private static final String DEFAULT_TRANID = "CJSA";
    private static final String TRIGGER_OBJECT_NAME = "TRIGGER";
    static final String CICS_UNCLASSIFIED_USERID;
    static final String CICS_UNCLASSIFIED_TRANID;
    private ThreadGroup threadGroup;
    String executorName;
    boolean zosSecurityActive;
    final Map<Integer, Runnable> runnables = Collections.synchronizedMap(new LinkedHashMap());
    DelegateThreadFactory threadFactory;
    volatile boolean tidyUpRunning = false;
    Thread TIDYUP_THREAD = new Thread("-TidyUpThread"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            String thisMethod = "TidyUpThread";
            while (true) {
                try {
                    while (true) {
                        cicsLog.logDeepDebug("TidyUpThread", "Entering sleep");
                        5.sleep(THREAD_JOIN_TIMEOUT);
                        cicsLog.logDeepDebug("TidyUpThread", "Woken from sleep");
                        long currentTime = System.currentTimeMillis();
                        Map<Integer, Runnable> map = CICSBasicThreadFactory.this.runnables;
                        synchronized (map) {
                            Iterator<Integer> it = CICSBasicThreadFactory.this.runnables.keySet().iterator();
                            while (it.hasNext()) {
                                Integer taskNumber = it.next();
                                Runnable runnable = CICSBasicThreadFactory.this.runnables.get(taskNumber);
                                if (!(runnable instanceof TrackedRunnable)) continue;
                                TrackedRunnable worker = (TrackedRunnable)runnable;
                                if (currentTime <= worker.getTimestamp() + (long)THREAD_JOIN_TIMEOUT) break;
                                cicsLog.logEvent("TidyUpThread", new Object[]{"removing timed-out runnable for Task = ", String.valueOf(taskNumber)});
                                it.remove();
                                Runnable userRunnable = worker.getRunnable();
                                if (!(userRunnable instanceof ICICSHttpRunnable)) continue;
                                cicsLog.logEvent("TidyUpThread", new Object[]{"closing WLP connection for Task = ", String.valueOf(taskNumber)});
                                try {
                                    ((CICSHttpRunnableExtended)userRunnable).sendError(503, "Service Unavailable");
                                }
                                catch (Exception e) {
                                    cicsLog.logError("TidyUpThread", "tried to send Http Error", (Throwable)e);
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException e) {
                    cicsLog.logError("TidyUpThread", "Interrupted", (Throwable)e);
                    continue;
                }
                catch (RuntimeException re) {
                    cicsLog.logError("TidyUpThread", "RuntimeException", (Throwable)re);
                    throw re;
                }
                catch (Error e) {
                    cicsLog.logError("TidyUpThread", new Object[]{"An Error was thrown"});
                    throw e;
                }
                break;
            }
        }
    };

    public CICSBasicThreadFactory() {
        this.TIDYUP_THREAD.setDaemon(true);
        cicsLog.logEntryExit("constructor", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    protected void activate(Map<String, Object> map) {
        void componentConfig;
        cicsLog.logEntry("activate", new Object[]{map});
        this.executorName = String.valueOf(componentConfig.get("executorName"));
        this.threadGroup = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

            @Override
            public ThreadGroup run() {
                return new ThreadGroup(CICSBasicThreadFactory.this.executorName + " Thread Group");
            }
        });
        this.threadFactory = DelegateFactoryLoader.getDelegateFactory().createDelegateThreadFactory();
        cicsLog.logExit("activate");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    protected void modified(Map<String, Object> map) {
        void componentConfig;
        cicsLog.logEntry("modified", new Object[]{map});
        this.executorName = String.valueOf(componentConfig.get("executorName"));
        this.threadGroup = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

            @Override
            public ThreadGroup run() {
                return new ThreadGroup(CICSBasicThreadFactory.this.executorName + " Thread Group");
            }
        });
        cicsLog.logExit("modified");
    }

    protected void deactivate() {
        cicsLog.logEntryExit("deactivate", new Object[0]);
        this.threadGroup = null;
    }

    protected void setSecurityActive(ServiceReference<?> dummyService) {
        cicsLog.logEntryExit("setSecurityActive", new Object[]{"ON"});
        this.zosSecurityActive = true;
    }

    protected void setSecurityInactive(ServiceReference<?> dummyService) {
        cicsLog.logEntryExit("setSecurityInactive", new Object[]{"OFF"});
        this.zosSecurityActive = false;
    }

    public void joinAsThread(String threadId) throws Exception {
        throw new Exception("CICSBasicThreadFactory does not support pooling with ThreadID");
    }

    @InjectLogging
    public void joinAsThread() throws Throwable {
        cicsLog.logEntry("joinAsThread");
        CICSWebAppStateHolder.setWebAppException(null);
        this.joinAsThreadInternal();
        if (CICSWebAppStateHolder.getWebAppException() != null) {
            try {
                throw CICSWebAppStateHolder.getWebAppException();
            }
            catch (Throwable throwable) {
                CICSWebAppStateHolder.remove();
                throw throwable;
            }
        }
        cicsLog.logExit("joinAsThread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinAsThreadInternal() throws Exception {
        String thisMethod = "joinAsThreadInternal";
        int taskNum = Task.getTask().getTaskNumber();
        Integer taskId = taskNum;
        cicsLog.logEntry("joinAsThreadInternal", new Object[]{taskId});
        Runnable worker = null;
        Runnable trigger = null;
        Object object = this.runnables;
        synchronized (object) {
            worker = this.runnables.remove(taskId);
            if (worker == null) {
                trigger = new Runnable(){

                    @Override
                    public void run() {
                    }

                    public String toString() {
                        return CICSBasicThreadFactory.TRIGGER_OBJECT_NAME;
                    }
                };
                this.runnables.put(taskId, trigger);
                cicsLog.logEvent("joinAsThreadInternal", new Object[]{"Trigger added for 'Task Id' = ", taskId});
            }
        }
        if (trigger != null) {
            object = trigger;
            synchronized (object) {
                trigger.wait(TRIGGER_TIMEOUT);
            }
        }
        if (worker == null) {
            worker = this.runnables.remove(taskId);
            if (worker == null) {
                throw new Exception("No Runnable found for Joining Thread. Task id = " + taskId + ".");
            }
            if (TRIGGER_OBJECT_NAME.equals(worker.toString())) {
                throw new Exception("No work found for Task " + taskId + ". The work this Task was started to perform has already timed-out.");
            }
            cicsLog.logInfo("joinAsThreadInternal", new Object[]{"work found after pause. Task id = " + taskId});
        }
        ((TrackedRunnable)worker).setThread(Thread.currentThread());
        worker.run();
        cicsLog.logExit("joinAsThreadInternal", new Object[]{"Success"});
    }

    @Override
    public Thread newThread(final Runnable runnable) {
        String thisMethod = "newThread";
        cicsLog.logEntry("newThread", new Object[]{runnable});
        Thread newThread = AccessController.doPrivileged(new PrivilegedAction<Thread>(){
            int newTaskNumber = 0;
            String userid = null;
            String tranid = null;
            String uri = null;
            String clientIPAddress = null;
            int clientPort = 0;
            int clientIPFamily = 0;
            String serverIPAddress = null;
            int serverPort = 0;
            int serverIPFamily = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Thread run() {
                cicsLog.logEntry("newThread", new Object[]{"run"});
                if (!CICSBasicThreadFactory.this.tidyUpRunning) {
                    CICSBasicThreadFactory.this.tidyUpRunning = true;
                    CICSBasicThreadFactory.this.TIDYUP_THREAD.start();
                }
                boolean isLibertyHttpRunnable = false;
                this.tranid = CICSBasicThreadFactory.DEFAULT_TRANID;
                if (!IS_LIBERTY) {
                    if (null != CICS_UNCLASSIFIED_TRANID) {
                        this.tranid = CICS_UNCLASSIFIED_TRANID;
                    }
                    if (null != CICS_UNCLASSIFIED_USERID) {
                        this.userid = CICS_UNCLASSIFIED_USERID;
                    }
                }
                int initiatingTaskNumber = 0;
                if (Wrapper.getApiStatus(false) == 2) {
                    cicsLog.logEvent("newThread", new Object[]{"parent thread has a CICS Task environment"});
                    try {
                        Task parent = Task.getTask();
                        initiatingTaskNumber = parent.getTaskNumber();
                        this.tranid = parent.getTransactionName();
                        this.userid = parent.getUSERID();
                    }
                    catch (Exception e) {
                        cicsLog.logEvent("newThread", new Object[]{"parent thread is API allowed, but has no Task environment", e});
                    }
                } else {
                    cicsLog.logEvent("newThread", new Object[]{"parent thread has no Task environment"});
                    ThreadLocal localUserID = CICSThreadLocalManager.getThreadLocal((String)"localUserID");
                    if (localUserID != null) {
                        this.userid = (String)localUserID.get();
                    }
                }
                CICSHttpRunnableExtended cicsHttpRunnable = null;
                TrackedRunnable worker = (TrackedRunnable)runnable;
                Runnable userRunnable = worker.getRunnable();
                cicsLog.logEvent("newThread", new Object[]{"Internal runnable ", userRunnable});
                if (IS_LIBERTY && userRunnable instanceof CICSHttpRunnableExtended) {
                    isLibertyHttpRunnable = true;
                    cicsHttpRunnable = (CICSHttpRunnableExtended)userRunnable;
                    this.userid = cicsHttpRunnable.getUserid();
                    this.uri = cicsHttpRunnable.getURL();
                    String queryString = cicsHttpRunnable.getQueryString();
                    if (queryString != null) {
                        this.uri = this.uri + "?" + queryString;
                    }
                    this.clientIPAddress = cicsHttpRunnable.getRemoteIPAddress();
                    this.clientPort = cicsHttpRunnable.getRemotePort();
                    this.clientIPFamily = cicsHttpRunnable.getRemoteIPFamily();
                    this.serverIPAddress = cicsHttpRunnable.getLocalIPAddress();
                    this.serverPort = cicsHttpRunnable.getLocalPort();
                    this.serverIPFamily = cicsHttpRunnable.getLocalIPFamily();
                    if (cicsLog.shouldTrace(LogType.DEBUG)) {
                        cicsLog.logEvent("newThread", new Object[]{"uri = ", this.uri, ", client IP = " + this.clientIPAddress, ", client Port = " + this.clientPort, ", client IP Family = " + this.clientIPFamily, ", server IP = " + this.serverIPAddress, ", server Port = " + this.serverPort, ", server IP Family = " + this.serverIPFamily});
                    }
                }
                if (userRunnable instanceof CICSTransactionRunnable) {
                    CICSTransactionRunnable tranRunnable = (CICSTransactionRunnable)userRunnable;
                    this.tranid = tranRunnable.getTranid();
                    cicsLog.logEvent("newThread", new Object[]{"CICSTransactionRunnable detected, tranid='", this.tranid, "'"});
                } else if (userRunnable instanceof FutureWrapper) {
                    FutureWrapper origin = (FutureWrapper)userRunnable;
                    cicsLog.logEvent("newThread", new Object[]{"FutureTask detected", origin.getClass()});
                    Callable callable = origin.getCallable();
                    if (callable instanceof CICSTransactionCallable) {
                        this.tranid = ((CICSTransactionCallable)callable).getTranid();
                        cicsLog.logEvent("newThread", new Object[]{"CICSTransactionCallable detected, tranid='", this.tranid, "'"});
                    }
                }
                worker.setTimestamp(System.currentTimeMillis());
                CicsThreadingRuntimeException threadException = null;
                try {
                    this.newTaskNumber = CICSBasicThreadFactory.this.threadFactory.createCICSThread(this.userid, this.uri, initiatingTaskNumber, isLibertyHttpRunnable, this.clientIPAddress, this.clientPort, this.clientIPFamily, this.serverIPAddress, this.serverPort, this.serverIPFamily, CICSBasicThreadFactory.this.zosSecurityActive, this.tranid);
                }
                catch (DelegateError ex) {
                    threadException = new CicsThreadingRuntimeException((Exception)((Object)ex));
                }
                if (threadException != null) {
                    if (IS_LIBERTY) {
                        if (cicsHttpRunnable == null) {
                            cicsLog.logEvent("newThread", new Object[]{"there is no CICS Http runnable, unable to return error to browser"});
                            throw threadException;
                        }
                        try {
                            cicsHttpRunnable.sendError(threadException.getHttpResponseCode());
                        }
                        catch (Exception e) {
                            cicsLog.logError("newThread", "failed to send error to browser", (Throwable)e);
                        }
                    }
                    throw threadException;
                }
                Runnable oldValue = CICSBasicThreadFactory.this.runnables.put(this.newTaskNumber, worker);
                if (oldValue != null) {
                    if (CICSBasicThreadFactory.TRIGGER_OBJECT_NAME.equals(oldValue.toString())) {
                        Runnable runnable2 = oldValue;
                        synchronized (runnable2) {
                            oldValue.notify();
                        }
                        cicsLog.logEvent("newThread", new Object[]{"trigger object found and notified for task id = ", String.valueOf(this.newTaskNumber)});
                    } else {
                        cicsLog.logError("newThread", new Object[]{"unexpected runnable found for task id = " + this.newTaskNumber});
                    }
                }
                cicsLog.logExit("newThread", new Object[]{"Task = ", String.valueOf(this.newTaskNumber)});
                return null;
            }
        });
        return newThread;
    }

    static {
        CICS_UNCLASSIFIED_USERID = EnvironmentConstants.env.getCicsUnclassifiedUserid();
        CICS_UNCLASSIFIED_TRANID = EnvironmentConstants.env.getCicsUnclassifiedTranid();
        try {
            THREAD_JOIN_TIMEOUT = Integer.parseInt(EnvironmentConstants.env.getThreadJoinTimeout());
        }
        catch (NumberFormatException e) {
            THREAD_JOIN_TIMEOUT = 30000;
        }
        try {
            TRIGGER_TIMEOUT = Integer.parseInt(EnvironmentConstants.env.getTriggerTimeout());
        }
        catch (NumberFormatException e) {
            TRIGGER_TIMEOUT = 500;
        }
    }
}

