/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.server.internal.TrackedRunnable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@InjectLogging(isEnabled=false)
public class CICSThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger cicsLog = LoggerFactory.getLogger(CICSThreadPoolExecutor.class);
    private ThreadFactory threadFactory;

    public CICSThreadPoolExecutor(int coreThreads, int corePoolSize, long keepAliveMillis, TimeUnit milliseconds, BlockingQueue<Runnable> workQueue, ThreadFactory cicsThreadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(corePoolSize, corePoolSize, keepAliveMillis, milliseconds, workQueue, cicsThreadFactory, rejectedExecutionHandler);
        if (cicsLog.shouldTrace(LogType.ENTRYEXIT)) {
            cicsLog.logEntryExit("constructor", new Object[]{String.valueOf(coreThreads), String.valueOf(corePoolSize), String.valueOf(keepAliveMillis), workQueue, cicsThreadFactory, rejectedExecutionHandler});
        }
        this.threadFactory = cicsThreadFactory;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectLogging
    public void execute(Runnable runnable) throws RejectedExecutionException {
        void usersRunnable;
        cicsLog.logEntry("execute", new Object[]{runnable});
        if (this.isShutdown()) {
            this.rejectedExecution((Runnable)usersRunnable);
        }
        TrackedRunnable worker = new TrackedRunnable((Runnable)usersRunnable);
        this.threadFactory.newThread(worker);
        cicsLog.logExit("execute");
    }

    protected <V> RunnableFuture<V> newTaskFor(Callable<V> callable) {
        return new FutureTask<V>(callable);
    }

    protected <V> RunnableFuture<V> newTaskFor(Runnable runnable, V result) {
        return new FutureTask<V>(runnable, result);
    }

    protected void rejectedExecution(Runnable r) throws RejectedExecutionException {
        throw new RejectedExecutionException();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(";poolSize=").append(this.getPoolSize());
        sb.append(",activeThreads=").append(this.getActiveCount());
        sb.append(",completedTasks=").append(this.getCompletedTaskCount());
        sb.append(",workers=[");
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
    }
}

