/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal;

import com.ibm.cics.server.CommAreaHolder;
import com.ibm.cics.server.invocation.InvocationProxy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MainMethodInvocationProxy
implements InvocationProxy {
    private static final String MAIN_METHOD = "main";
    private final Class<?> userClass;
    private final Method method;
    private final Object[] arguments = new Object[1];

    public MainMethodInvocationProxy(Class<?> userClass) throws NoSuchMethodException {
        this(userClass, null);
    }

    public MainMethodInvocationProxy(Class<?> userClass, Method method) throws NoSuchMethodException {
        this.userClass = userClass;
        this.method = this.getMainMethod(method);
    }

    private Method getMainMethod(Method cachedMethod) throws NoSuchMethodException {
        if (cachedMethod != null) {
            return cachedMethod;
        }
        try {
            return this.userClass.getMethod(MAIN_METHOD, CommAreaHolder.class);
        }
        catch (NoSuchMethodException e) {
            return this.userClass.getMethod(MAIN_METHOD, String[].class);
        }
    }

    @Override
    public boolean setArguments(CommAreaHolder commarea, String[] args) {
        if (this.method.getParameterTypes()[0] == CommAreaHolder.class) {
            this.arguments[0] = commarea;
            return true;
        }
        this.arguments[0] = args;
        return false;
    }

    @Override
    public void invoke() throws InvocationTargetException {
        try {
            this.method.invoke(this.userClass, this.arguments);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    @Override
    public String getClassName() {
        return this.userClass.getName();
    }
}

