/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal;

import com.ibm.cics.server.CicsException;
import com.ibm.cics.server.Version;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ManifestReader {
    public Version getExportPackageVersion(String packageName) throws CicsException {
        String exportedPackages;
        Class<ManifestReader> clazz = ManifestReader.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar") && !classPath.startsWith("bundleresource")) {
            throw new CicsException("ManifestReader class not packaged within a jar or bundleresource.", null);
        }
        String manifestPath = classPath.replaceAll("/com/ibm/cics/server/internal/ManifestReader.class", "/META-INF/MANIFEST.MF");
        try {
            URL manifestURL = new URL(manifestPath);
            try (InputStream stream = manifestURL.openStream();){
                Manifest manifest = new Manifest(stream);
                Attributes attrs = manifest.getMainAttributes();
                exportedPackages = attrs.getValue("Export-Package");
            }
        }
        catch (IOException ex) {
            throw new CicsException(ex.getMessage(), ex);
        }
        int indexOfTargetPackage = exportedPackages.indexOf(packageName);
        if (indexOfTargetPackage < 0) {
            throw new CicsException("Manifest does not contain target package ('" + packageName + "')", null);
        }
        String packageNameWithEscapedDots = packageName.replaceAll("[.]", "[.]");
        String regex = ".*" + packageNameWithEscapedDots + ";version=[\"](\\d+[.]\\d+[.]\\d+)[\"].*";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(exportedPackages);
        boolean isMatchFound = m.find();
        if (!isMatchFound) {
            throw new CicsException("Manifest does not contain a version of the target package ('" + packageName + "')", null);
        }
        String versionStr = m.group(1);
        Version version = new Version(versionStr);
        return version;
    }
}

