/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal;

import com.ibm.cics.osgi.CICSThreadJoiner;
import com.ibm.cics.server.CommAreaHolder;
import java.util.Collection;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class ThreadJoiner {
    private static BundleContext bc;
    private static ServiceReference<?> pooledThreadFactoryRef;
    private static ServiceReference<?> basicThreadFactoryRef;
    private static CICSThreadJoiner pooledJoiner;
    private static CICSThreadJoiner basicJoiner;

    public static void main(String[] args) throws Throwable {
        ThreadJoiner.getPooledJoinerService().joinAsThread(args[0]);
    }

    public static void main(CommAreaHolder args) throws Throwable {
        ThreadJoiner.getBasicJoinerService().joinAsThread();
    }

    private static CICSThreadJoiner getPooledJoinerService() throws Throwable {
        if (bc == null) {
            Bundle bund = FrameworkUtil.getBundle(ThreadJoiner.class);
            if (bund.getState() == 4) {
                bund.start();
            }
            bc = bund.getBundleContext();
        }
        if (pooledThreadFactoryRef == null) {
            String filterString = "(service.type=POOLED)";
            Collection refs = bc.getServiceReferences(CICSThreadJoiner.class, filterString);
            if (refs.size() > 1) {
                throw new Exception("Internal error: ThreadJoiner - too many matches to PooledThreadJoiner Service!");
            }
            pooledThreadFactoryRef = (ServiceReference)refs.iterator().next();
        }
        if (pooledThreadFactoryRef == null) {
            throw new Exception("Internal error: ThreadJoiner - cannot find a registered implementation of CICSThreadJoiner from PooledThreadFactory");
        }
        if (pooledJoiner == null) {
            pooledJoiner = (CICSThreadJoiner)bc.getService(pooledThreadFactoryRef);
        }
        return pooledJoiner;
    }

    private static CICSThreadJoiner getBasicJoinerService() throws Throwable {
        if (bc == null) {
            Bundle bund = FrameworkUtil.getBundle(ThreadJoiner.class);
            if (bund.getState() == 4) {
                bund.start();
            }
            bc = bund.getBundleContext();
        }
        if (basicThreadFactoryRef == null) {
            String filterString = "(service.type=BASIC)";
            Collection refs = bc.getServiceReferences(CICSThreadJoiner.class, filterString);
            if (refs.size() > 1) {
                throw new Exception("Internal error: ThreadJoiner - too many matches to BasicThreadJoiner Service!");
            }
            basicThreadFactoryRef = (ServiceReference)refs.iterator().next();
        }
        if (basicThreadFactoryRef == null) {
            throw new Exception("Internal error: ThreadJoiner - cannot find a registered implementation of CICSThreadJoiner from BasicThreadFactory");
        }
        if (basicJoiner == null) {
            basicJoiner = (CICSThreadJoiner)bc.getService(basicThreadFactoryRef);
        }
        return basicJoiner;
    }
}

