/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal.invocation.processor;

import com.ibm.cics.server.internal.invocation.processor.AnnotatedMethod;
import com.ibm.cics.server.internal.invocation.processor.AnnotatedType;
import com.ibm.cics.server.internal.invocation.processor.LinkableTargetMetadataBuilder;
import com.ibm.cics.server.internal.invocation.processor.Messages;
import com.ibm.cics.server.internal.invocation.processor.ProxyClassGenerator;
import com.ibm.cics.server.internal.invocation.processor.WriterException;
import com.ibm.cics.server.invocation.CICSProgram;
import com.ibm.cics.server.invocation.binding.LinkableTargetMetadata;
import com.ibm.cics.server.invocation.binding.LinkableTargets;
import com.ibm.cics.server.invocation.binding.ObjectFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class AnnotationMetadataWriter {
    private static final String METADATA_PACKAGE = "com.ibm.cics.server.invocation.metadata";
    private static final String PROXY_PACKAGE = "com.ibm.cics.server.invocation.proxy";
    private static final String METADATA_EXTENSION = "xml";
    private ProcessingEnvironment processingEnv;
    private LinkableTargetMetadataBuilder metadataBuilder;

    public AnnotationMetadataWriter(ProcessingEnvironment theProcessingEnv) {
        this.processingEnv = theProcessingEnv;
        this.metadataBuilder = new LinkableTargetMetadataBuilder();
    }

    public AnnotationMetadataWriter(ProcessingEnvironment env, LinkableTargetMetadataBuilder builder) {
        this.processingEnv = env;
        this.metadataBuilder = builder;
    }

    public void writeMetadata(AnnotatedType annotatedType) throws WriterException {
        String typeName = annotatedType.getType().getQualifiedName().toString();
        List<AnnotatedMethod> annotatedMethods = annotatedType.getMethods();
        Element[] originatingElements = new ExecutableElement[annotatedMethods.size()];
        for (int i = 0; i < annotatedMethods.size(); ++i) {
            originatingElements[i] = annotatedMethods.get(i).getAnnotatedMethodElement();
        }
        ObjectFactory factory = new ObjectFactory();
        try {
            String metadataFileName = AnnotationMetadataWriter.getMetadataFileName(typeName);
            FileObject resource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, METADATA_PACKAGE, metadataFileName, originatingElements);
            LinkableTargets linkableTargets = factory.createLinkableTargets();
            List linkableTargetMetadata = linkableTargets.getLinkableTargetMetadata();
            for (AnnotatedMethod annotatedMethod : annotatedMethods) {
                LinkableTargetMetadata metadata = this.metadataBuilder.buildMetadataFor(typeName, annotatedMethod);
                linkableTargetMetadata.add(metadata);
                this.createProxyClass(annotatedMethod, annotatedType, (ExecutableElement[])originatingElements);
            }
            JAXBContext jc = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName(), (ClassLoader)ObjectFactory.class.getClassLoader());
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            try (Writer writer = resource.openWriter();){
                m.marshal((Object)linkableTargets, writer);
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
            String message = MessageFormat.format(Messages.getString("AnnotationMetadataWriter.ERROR__WRITE"), CICSProgram.class.getSimpleName());
            throw new WriterException(message, annotatedType.getType());
        }
        catch (IOException e) {
            e.printStackTrace();
            String message = MessageFormat.format(Messages.getString("AnnotationMetadataWriter.ERROR__WRITE"), CICSProgram.class.getSimpleName());
            throw new WriterException(message, annotatedType.getType());
        }
    }

    private void createProxyClass(AnnotatedMethod annotatedMethod, AnnotatedType annotatedType, ExecutableElement[] originatingElements) throws IOException {
        String destinationPackage = this.getDestinationPackage(annotatedMethod, annotatedType);
        String proxyFileName = AnnotationMetadataWriter.getProxyClassName(annotatedMethod.getUUID());
        FileObject pojoClass = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, destinationPackage, proxyFileName + ".class", originatingElements);
        ProxyClassGenerator generator = new ProxyClassGenerator(annotatedMethod, annotatedType);
        try (OutputStream os = pojoClass.openOutputStream();){
            os.write(generator.generate(destinationPackage));
        }
        if (annotatedMethod.getTargetType() == CICSProgram.TargetType.POJO) {
            FileObject osgiPojoClass = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, destinationPackage + ".osgi", proxyFileName + ".class", originatingElements);
            ProxyClassGenerator osgiGenerator = new ProxyClassGenerator(annotatedMethod, annotatedType);
            try (OutputStream os = osgiPojoClass.openOutputStream();){
                os.write(osgiGenerator.generateOSGi(destinationPackage + ".osgi"));
            }
        }
    }

    private String getDestinationPackage(AnnotatedMethod annotatedMethod, AnnotatedType annotatedType) {
        String destPackage = PROXY_PACKAGE;
        if (annotatedMethod.getTargetType() == CICSProgram.TargetType.SPRINGBEAN) {
            destPackage = this.processingEnv.getElementUtils().getPackageOf(annotatedType.getType()).getQualifiedName().toString();
            if (!destPackage.equals("")) {
                destPackage = destPackage + ".";
            }
            destPackage = destPackage + "cics.proxy";
        }
        return destPackage;
    }

    private static String getMetadataFileName(String typeName) {
        return typeName + "." + METADATA_EXTENSION;
    }

    private static String getProxyClassName(String uuid) {
        return ProxyClassGenerator.getNewSimpleClassName(uuid);
    }
}

