/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.invocation.template;

import com.ibm.cics.server.invocation.InvocationProxy;
import com.ibm.cics.server.invocation.template.UserClass;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.PostConstruct;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SpringBeanInvocationProxyTemplate
implements InvocationProxy {
    private static final int PROXY_VERSION = 2;
    @Autowired
    private UserClass autowiredObject;
    @Value(value="#{systemEnvironment['com.ibm.cics.jvmserver.name']}")
    private String jvmServer;

    @Override
    public void invoke() throws InvocationTargetException {
        try {
            this.doInvoke();
        }
        catch (Throwable t) {
            throw new InvocationTargetException(t);
        }
    }

    public int getProxyVersion() {
        return 2;
    }

    private void doInvoke() throws Throwable {
        this.autowiredObject.instanceMethod();
    }

    @PostConstruct
    @jakarta.annotation.PostConstruct
    public void register() {
        if (this.jvmServer != null) {
            try {
                InitialContext jndi = new InitialContext();
                jndi.rebind(this.getClass().getSimpleName(), (Object)this);
            }
            catch (NamingException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

