/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.features;

import com.ibm.cloud.cloudant.features.ChangesFollower;
import com.ibm.cloud.cloudant.v1.model.PostChangesOptions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;

class ChangesOptionsHelper {
    static final long MIN_CLIENT_TIMEOUT = Duration.ofMinutes(1L).toMillis();
    static final long LONGPOLL_TIMEOUT = MIN_CLIENT_TIMEOUT - TimeUnit.SECONDS.toMillis(3L);
    private static final String singleOptionErrorFormat = "The option %s is invalid when using %s.";
    private static final String multipleOptionErrorFormat = "The options %s are invalid when using %s.";

    private ChangesOptionsHelper() {
    }

    static PostChangesOptions cloneOptions(PostChangesOptions options) {
        return ChangesOptionsHelper.buildOptions(options, null);
    }

    static PostChangesOptions cloneOptionsWithModeAndNewLimit(PostChangesOptions options, ChangesFollower.Mode mode, Long limit) {
        return ChangesOptionsHelper.buildOptions(options, b -> {
            switch (mode) {
                case FINITE: {
                    b.feed("normal");
                    break;
                }
                case LISTEN: {
                    b.feed("longpoll");
                    b.timeout(LONGPOLL_TIMEOUT);
                }
            }
            if (limit != null) {
                b.limit(limit);
            }
        });
    }

    static PostChangesOptions cloneOptionsWithNewSince(PostChangesOptions options, String since) {
        return ChangesOptionsHelper.buildOptions(options, b -> b.since(since));
    }

    private static PostChangesOptions buildOptions(PostChangesOptions originalOptions, Consumer<PostChangesOptions.Builder> extraOpts) {
        PostChangesOptions.Builder builder = originalOptions.newBuilder();
        Optional.ofNullable(extraOpts).ifPresent(builderConsumer -> builderConsumer.accept(builder));
        return builder.build();
    }

    private static String throwInvalidOptionsMessageWith(List<String> invalidOptions) {
        String errorMsgFormat = invalidOptions.size() > 1 ? multipleOptionErrorFormat : singleOptionErrorFormat;
        String errorMsg = String.format(errorMsgFormat, invalidOptions.stream().collect(Collectors.joining("', '", "'", "'")), ChangesFollower.class.getSimpleName());
        throw new IllegalArgumentException(errorMsg);
    }

    static void validateOptions(PostChangesOptions options) {
        ArrayList<String> invalidOptions = new ArrayList<String>();
        if (options.descending() != null) {
            invalidOptions.add("descending");
        }
        if (options.feed() != null) {
            invalidOptions.add("feed");
        }
        if (options.heartbeat() != null) {
            invalidOptions.add("heartbeat");
        }
        if (options.lastEventId() != null) {
            invalidOptions.add("lastEventId");
        }
        if (options.timeout() != null) {
            invalidOptions.add("timeout");
        }
        if (options.filter() != null && !"_selector".equals(options.filter())) {
            invalidOptions.add(String.format("filter=%s", options.filter()));
        }
        if (invalidOptions.size() > 0) {
            ChangesOptionsHelper.throwInvalidOptionsMessageWith(invalidOptions);
        }
    }
}

