/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.platform_services.posture_management.v1;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.platform_services.common.SdkCommon;
import com.ibm.cloud.platform_services.posture_management.v1.model.CreateValidationOptions;
import com.ibm.cloud.platform_services.posture_management.v1.model.ListProfilesOptions;
import com.ibm.cloud.platform_services.posture_management.v1.model.ListScopesOptions;
import com.ibm.cloud.platform_services.posture_management.v1.model.ProfilesList;
import com.ibm.cloud.platform_services.posture_management.v1.model.Result;
import com.ibm.cloud.platform_services.posture_management.v1.model.ScopesList;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import java.lang.reflect.Type;
import java.util.Map;
import okhttp3.HttpUrl;

public class PostureManagement
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "posture_management";

    public static PostureManagement newInstance() {
        return PostureManagement.newInstance(DEFAULT_SERVICE_NAME);
    }

    public static PostureManagement newInstance(String serviceName) {
        Authenticator authenticator = ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName);
        PostureManagement service = new PostureManagement(serviceName, authenticator);
        service.configureService(serviceName);
        return service;
    }

    public PostureManagement(String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
    }

    public ServiceCall<Result> createValidation(CreateValidationOptions createValidationOptions) {
        Validator.notNull((Object)((Object)createValidationOptions), (String)"createValidationOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/posture/v1/scans/validations"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"createValidation");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"account_id", String.valueOf(createValidationOptions.accountId())});
        JsonObject contentJson = new JsonObject();
        if (createValidationOptions.scopeId() != null) {
            contentJson.addProperty("scope_id", createValidationOptions.scopeId());
        }
        if (createValidationOptions.profileId() != null) {
            contentJson.addProperty("profile_id", createValidationOptions.profileId());
        }
        if (createValidationOptions.groupProfileId() != null) {
            contentJson.addProperty("group_profile_id", createValidationOptions.groupProfileId());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Result>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ProfilesList> listProfiles(ListProfilesOptions listProfilesOptions) {
        Validator.notNull((Object)((Object)listProfilesOptions), (String)"listProfilesOptions cannot be null");
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/posture/v1/profiles"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listProfiles");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"account_id", String.valueOf(listProfilesOptions.accountId())});
        if (listProfilesOptions.name() != null) {
            builder.query(new Object[]{"name", String.valueOf(listProfilesOptions.name())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ProfilesList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ScopesList> listScopes(ListScopesOptions listScopesOptions) {
        Validator.notNull((Object)((Object)listScopesOptions), (String)"listScopesOptions cannot be null");
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/posture/v1/scopes"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listScopes");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"account_id", String.valueOf(listScopesOptions.accountId())});
        if (listScopesOptions.name() != null) {
            builder.query(new Object[]{"name", String.valueOf(listScopesOptions.name())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ScopesList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

