/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.platform_services.resource_controller.v2.model;

import com.ibm.cloud.platform_services.resource_controller.v2.ResourceController;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ListResourceInstancesOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ResourceInstance;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ResourceInstancesList;
import com.ibm.cloud.sdk.core.util.UrlHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class ResourceInstancesPager {
    protected boolean hasNext;
    protected ListResourceInstancesOptions options;
    protected ResourceController client;
    protected PageContext pageContext;

    protected ResourceInstancesPager() {
    }

    public ResourceInstancesPager(ResourceController client, ListResourceInstancesOptions options) {
        if (options.start() != null) {
            throw new IllegalArgumentException("The options 'start' field should not be set");
        }
        this.hasNext = true;
        this.client = client;
        this.options = options.newBuilder().build();
        this.pageContext = new PageContext();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public List<ResourceInstance> getNext() {
        String queryParam;
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more results available");
        }
        ListResourceInstancesOptions.Builder builder = this.options.newBuilder();
        if (this.pageContext.getNext() != null) {
            builder.start(this.pageContext.getNext());
        }
        this.options = builder.build();
        ResourceInstancesList result = (ResourceInstancesList)((Object)this.client.listResourceInstances(this.options).execute().getResult());
        String next = null;
        if (result.getNextUrl() != null && (queryParam = UrlHelper.getQueryParam((String)result.getNextUrl(), (String)"start")) != null) {
            next = queryParam;
        }
        this.pageContext.setNext(next);
        if (next == null) {
            this.hasNext = false;
        }
        return result.getResources();
    }

    public List<ResourceInstance> getAll() {
        ArrayList<ResourceInstance> results = new ArrayList<ResourceInstance>();
        while (this.hasNext()) {
            List<ResourceInstance> nextPage = this.getNext();
            results.addAll(nextPage);
        }
        return results;
    }

    private static class PageContext {
        private String next;

        private PageContext() {
        }

        public String getNext() {
            return this.next;
        }

        public void setNext(String next) {
            this.next = next;
        }
    }
}

