/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.platform_services.resource_controller.v2.model;

import com.ibm.cloud.platform_services.resource_controller.v2.ResourceController;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ListResourceKeysOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ResourceKey;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ResourceKeysList;
import com.ibm.cloud.sdk.core.util.UrlHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class ResourceKeysPager {
    protected boolean hasNext;
    protected ListResourceKeysOptions options;
    protected ResourceController client;
    protected PageContext pageContext;

    protected ResourceKeysPager() {
    }

    public ResourceKeysPager(ResourceController client, ListResourceKeysOptions options) {
        if (options.start() != null) {
            throw new IllegalArgumentException("The options 'start' field should not be set");
        }
        this.hasNext = true;
        this.client = client;
        this.options = options.newBuilder().build();
        this.pageContext = new PageContext();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public List<ResourceKey> getNext() {
        String queryParam;
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more results available");
        }
        ListResourceKeysOptions.Builder builder = this.options.newBuilder();
        if (this.pageContext.getNext() != null) {
            builder.start(this.pageContext.getNext());
        }
        this.options = builder.build();
        ResourceKeysList result = (ResourceKeysList)((Object)this.client.listResourceKeys(this.options).execute().getResult());
        String next = null;
        if (result.getNextUrl() != null && (queryParam = UrlHelper.getQueryParam((String)result.getNextUrl(), (String)"start")) != null) {
            next = queryParam;
        }
        this.pageContext.setNext(next);
        if (next == null) {
            this.hasNext = false;
        }
        return result.getResources();
    }

    public List<ResourceKey> getAll() {
        ArrayList<ResourceKey> results = new ArrayList<ResourceKey>();
        while (this.hasNext()) {
            List<ResourceKey> nextPage = this.getNext();
            results.addAll(nextPage);
        }
        return results;
    }

    private static class PageContext {
        private String next;

        private PageContext() {
        }

        public String getNext() {
            return this.next;
        }

        public void setNext(String next) {
            this.next = next;
        }
    }
}

