/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.platform_services.resource_controller.v2;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.platform_services.common.SdkCommon;
import com.ibm.cloud.platform_services.resource_controller.v2.model.CancelLastopResourceInstanceOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.CreateResourceAliasOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.CreateResourceBindingOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.CreateResourceInstanceOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.CreateResourceKeyOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.DeleteResourceAliasOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.DeleteResourceBindingOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.DeleteResourceInstanceOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.DeleteResourceKeyOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.GetResourceAliasOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.GetResourceBindingOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.GetResourceInstanceOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.GetResourceKeyOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ListReclamationsOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ListResourceAliasesForInstanceOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ListResourceAliasesOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ListResourceBindingsForAliasOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ListResourceBindingsOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ListResourceInstancesOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ListResourceKeysForInstanceOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ListResourceKeysOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.LockResourceInstanceOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.Reclamation;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ReclamationsList;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ResourceAlias;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ResourceAliasesList;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ResourceBinding;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ResourceBindingsList;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ResourceInstance;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ResourceInstancesList;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ResourceKey;
import com.ibm.cloud.platform_services.resource_controller.v2.model.ResourceKeysList;
import com.ibm.cloud.platform_services.resource_controller.v2.model.RunReclamationActionOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.UnlockResourceInstanceOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.UpdateResourceAliasOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.UpdateResourceBindingOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.UpdateResourceInstanceOptions;
import com.ibm.cloud.platform_services.resource_controller.v2.model.UpdateResourceKeyOptions;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;

public class ResourceController
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "resource_controller";
    public static final String DEFAULT_SERVICE_URL = "https://resource-controller.cloud.ibm.com";

    public static ResourceController newInstance() {
        return ResourceController.newInstance(DEFAULT_SERVICE_NAME);
    }

    public static ResourceController newInstance(String serviceName) {
        Authenticator authenticator = ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName);
        ResourceController service = new ResourceController(serviceName, authenticator);
        service.configureService(serviceName);
        return service;
    }

    public ResourceController(String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
    }

    public ServiceCall<ResourceInstancesList> listResourceInstances(ListResourceInstancesOptions listResourceInstancesOptions) {
        if (listResourceInstancesOptions == null) {
            listResourceInstancesOptions = new ListResourceInstancesOptions.Builder().build();
        }
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_instances"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listResourceInstances");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listResourceInstancesOptions.guid() != null) {
            builder.query(new Object[]{"guid", String.valueOf(listResourceInstancesOptions.guid())});
        }
        if (listResourceInstancesOptions.name() != null) {
            builder.query(new Object[]{"name", String.valueOf(listResourceInstancesOptions.name())});
        }
        if (listResourceInstancesOptions.resourceGroupId() != null) {
            builder.query(new Object[]{"resource_group_id", String.valueOf(listResourceInstancesOptions.resourceGroupId())});
        }
        if (listResourceInstancesOptions.resourceId() != null) {
            builder.query(new Object[]{"resource_id", String.valueOf(listResourceInstancesOptions.resourceId())});
        }
        if (listResourceInstancesOptions.resourcePlanId() != null) {
            builder.query(new Object[]{"resource_plan_id", String.valueOf(listResourceInstancesOptions.resourcePlanId())});
        }
        if (listResourceInstancesOptions.type() != null) {
            builder.query(new Object[]{"type", String.valueOf(listResourceInstancesOptions.type())});
        }
        if (listResourceInstancesOptions.subType() != null) {
            builder.query(new Object[]{"sub_type", String.valueOf(listResourceInstancesOptions.subType())});
        }
        if (listResourceInstancesOptions.limit() != null) {
            builder.query(new Object[]{"limit", String.valueOf(listResourceInstancesOptions.limit())});
        }
        if (listResourceInstancesOptions.start() != null) {
            builder.query(new Object[]{"start", String.valueOf(listResourceInstancesOptions.start())});
        }
        if (listResourceInstancesOptions.state() != null) {
            builder.query(new Object[]{"state", String.valueOf(listResourceInstancesOptions.state())});
        }
        if (listResourceInstancesOptions.updatedFrom() != null) {
            builder.query(new Object[]{"updated_from", String.valueOf(listResourceInstancesOptions.updatedFrom())});
        }
        if (listResourceInstancesOptions.updatedTo() != null) {
            builder.query(new Object[]{"updated_to", String.valueOf(listResourceInstancesOptions.updatedTo())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceInstancesList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceInstancesList> listResourceInstances() {
        return this.listResourceInstances(null);
    }

    public ServiceCall<ResourceInstance> createResourceInstance(CreateResourceInstanceOptions createResourceInstanceOptions) {
        Validator.notNull((Object)((Object)createResourceInstanceOptions), (String)"createResourceInstanceOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_instances"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createResourceInstance");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (createResourceInstanceOptions.entityLock() != null) {
            builder.header(new Object[]{"Entity-Lock", createResourceInstanceOptions.entityLock()});
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createResourceInstanceOptions.name());
        contentJson.addProperty("target", createResourceInstanceOptions.target());
        contentJson.addProperty("resource_group", createResourceInstanceOptions.resourceGroup());
        contentJson.addProperty("resource_plan_id", createResourceInstanceOptions.resourcePlanId());
        if (createResourceInstanceOptions.tags() != null) {
            contentJson.add("tags", GsonSingleton.getGson().toJsonTree(createResourceInstanceOptions.tags()));
        }
        if (createResourceInstanceOptions.allowCleanup() != null) {
            contentJson.addProperty("allow_cleanup", createResourceInstanceOptions.allowCleanup());
        }
        if (createResourceInstanceOptions.parameters() != null) {
            contentJson.add("parameters", GsonSingleton.getGson().toJsonTree(createResourceInstanceOptions.parameters()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceInstance>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceInstance> getResourceInstance(GetResourceInstanceOptions getResourceInstanceOptions) {
        Validator.notNull((Object)((Object)getResourceInstanceOptions), (String)"getResourceInstanceOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", getResourceInstanceOptions.id());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_instances/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getResourceInstance");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceInstance>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteResourceInstance(DeleteResourceInstanceOptions deleteResourceInstanceOptions) {
        Validator.notNull((Object)((Object)deleteResourceInstanceOptions), (String)"deleteResourceInstanceOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", deleteResourceInstanceOptions.id());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_instances/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteResourceInstance");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (deleteResourceInstanceOptions.recursive() != null) {
            builder.query(new Object[]{"recursive", String.valueOf(deleteResourceInstanceOptions.recursive())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceInstance> updateResourceInstance(UpdateResourceInstanceOptions updateResourceInstanceOptions) {
        Validator.notNull((Object)((Object)updateResourceInstanceOptions), (String)"updateResourceInstanceOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", updateResourceInstanceOptions.id());
        RequestBuilder builder = RequestBuilder.patch((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_instances/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"updateResourceInstance");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (updateResourceInstanceOptions.name() != null) {
            contentJson.addProperty("name", updateResourceInstanceOptions.name());
        }
        if (updateResourceInstanceOptions.parameters() != null) {
            contentJson.add("parameters", GsonSingleton.getGson().toJsonTree(updateResourceInstanceOptions.parameters()));
        }
        if (updateResourceInstanceOptions.resourcePlanId() != null) {
            contentJson.addProperty("resource_plan_id", updateResourceInstanceOptions.resourcePlanId());
        }
        if (updateResourceInstanceOptions.allowCleanup() != null) {
            contentJson.addProperty("allow_cleanup", updateResourceInstanceOptions.allowCleanup());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceInstance>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceAliasesList> listResourceAliasesForInstance(ListResourceAliasesForInstanceOptions listResourceAliasesForInstanceOptions) {
        Validator.notNull((Object)((Object)listResourceAliasesForInstanceOptions), (String)"listResourceAliasesForInstanceOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", listResourceAliasesForInstanceOptions.id());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_instances/{id}/resource_aliases", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listResourceAliasesForInstance");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listResourceAliasesForInstanceOptions.limit() != null) {
            builder.query(new Object[]{"limit", String.valueOf(listResourceAliasesForInstanceOptions.limit())});
        }
        if (listResourceAliasesForInstanceOptions.start() != null) {
            builder.query(new Object[]{"start", String.valueOf(listResourceAliasesForInstanceOptions.start())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceAliasesList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceKeysList> listResourceKeysForInstance(ListResourceKeysForInstanceOptions listResourceKeysForInstanceOptions) {
        Validator.notNull((Object)((Object)listResourceKeysForInstanceOptions), (String)"listResourceKeysForInstanceOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", listResourceKeysForInstanceOptions.id());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_instances/{id}/resource_keys", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listResourceKeysForInstance");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listResourceKeysForInstanceOptions.limit() != null) {
            builder.query(new Object[]{"limit", String.valueOf(listResourceKeysForInstanceOptions.limit())});
        }
        if (listResourceKeysForInstanceOptions.start() != null) {
            builder.query(new Object[]{"start", String.valueOf(listResourceKeysForInstanceOptions.start())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceKeysList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceInstance> lockResourceInstance(LockResourceInstanceOptions lockResourceInstanceOptions) {
        Validator.notNull((Object)((Object)lockResourceInstanceOptions), (String)"lockResourceInstanceOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", lockResourceInstanceOptions.id());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_instances/{id}/lock", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"lockResourceInstance");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceInstance>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceInstance> unlockResourceInstance(UnlockResourceInstanceOptions unlockResourceInstanceOptions) {
        Validator.notNull((Object)((Object)unlockResourceInstanceOptions), (String)"unlockResourceInstanceOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", unlockResourceInstanceOptions.id());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_instances/{id}/lock", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"unlockResourceInstance");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceInstance>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceInstance> cancelLastopResourceInstance(CancelLastopResourceInstanceOptions cancelLastopResourceInstanceOptions) {
        Validator.notNull((Object)((Object)cancelLastopResourceInstanceOptions), (String)"cancelLastopResourceInstanceOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", cancelLastopResourceInstanceOptions.id());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_instances/{id}/last_operation", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"cancelLastopResourceInstance");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceInstance>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceKeysList> listResourceKeys(ListResourceKeysOptions listResourceKeysOptions) {
        if (listResourceKeysOptions == null) {
            listResourceKeysOptions = new ListResourceKeysOptions.Builder().build();
        }
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_keys"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listResourceKeys");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listResourceKeysOptions.guid() != null) {
            builder.query(new Object[]{"guid", String.valueOf(listResourceKeysOptions.guid())});
        }
        if (listResourceKeysOptions.name() != null) {
            builder.query(new Object[]{"name", String.valueOf(listResourceKeysOptions.name())});
        }
        if (listResourceKeysOptions.resourceGroupId() != null) {
            builder.query(new Object[]{"resource_group_id", String.valueOf(listResourceKeysOptions.resourceGroupId())});
        }
        if (listResourceKeysOptions.resourceId() != null) {
            builder.query(new Object[]{"resource_id", String.valueOf(listResourceKeysOptions.resourceId())});
        }
        if (listResourceKeysOptions.limit() != null) {
            builder.query(new Object[]{"limit", String.valueOf(listResourceKeysOptions.limit())});
        }
        if (listResourceKeysOptions.start() != null) {
            builder.query(new Object[]{"start", String.valueOf(listResourceKeysOptions.start())});
        }
        if (listResourceKeysOptions.updatedFrom() != null) {
            builder.query(new Object[]{"updated_from", String.valueOf(listResourceKeysOptions.updatedFrom())});
        }
        if (listResourceKeysOptions.updatedTo() != null) {
            builder.query(new Object[]{"updated_to", String.valueOf(listResourceKeysOptions.updatedTo())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceKeysList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceKeysList> listResourceKeys() {
        return this.listResourceKeys(null);
    }

    public ServiceCall<ResourceKey> createResourceKey(CreateResourceKeyOptions createResourceKeyOptions) {
        Validator.notNull((Object)((Object)createResourceKeyOptions), (String)"createResourceKeyOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_keys"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createResourceKey");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createResourceKeyOptions.name());
        contentJson.addProperty("source", createResourceKeyOptions.source());
        if (createResourceKeyOptions.parameters() != null) {
            contentJson.add("parameters", GsonSingleton.getGson().toJsonTree((Object)createResourceKeyOptions.parameters()));
        }
        if (createResourceKeyOptions.role() != null) {
            contentJson.addProperty("role", createResourceKeyOptions.role());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceKey>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceKey> getResourceKey(GetResourceKeyOptions getResourceKeyOptions) {
        Validator.notNull((Object)((Object)getResourceKeyOptions), (String)"getResourceKeyOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", getResourceKeyOptions.id());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_keys/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getResourceKey");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceKey>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteResourceKey(DeleteResourceKeyOptions deleteResourceKeyOptions) {
        Validator.notNull((Object)((Object)deleteResourceKeyOptions), (String)"deleteResourceKeyOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", deleteResourceKeyOptions.id());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_keys/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteResourceKey");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceKey> updateResourceKey(UpdateResourceKeyOptions updateResourceKeyOptions) {
        Validator.notNull((Object)((Object)updateResourceKeyOptions), (String)"updateResourceKeyOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", updateResourceKeyOptions.id());
        RequestBuilder builder = RequestBuilder.patch((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_keys/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"updateResourceKey");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", updateResourceKeyOptions.name());
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceKey>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceBindingsList> listResourceBindings(ListResourceBindingsOptions listResourceBindingsOptions) {
        if (listResourceBindingsOptions == null) {
            listResourceBindingsOptions = new ListResourceBindingsOptions.Builder().build();
        }
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_bindings"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listResourceBindings");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listResourceBindingsOptions.guid() != null) {
            builder.query(new Object[]{"guid", String.valueOf(listResourceBindingsOptions.guid())});
        }
        if (listResourceBindingsOptions.name() != null) {
            builder.query(new Object[]{"name", String.valueOf(listResourceBindingsOptions.name())});
        }
        if (listResourceBindingsOptions.resourceGroupId() != null) {
            builder.query(new Object[]{"resource_group_id", String.valueOf(listResourceBindingsOptions.resourceGroupId())});
        }
        if (listResourceBindingsOptions.resourceId() != null) {
            builder.query(new Object[]{"resource_id", String.valueOf(listResourceBindingsOptions.resourceId())});
        }
        if (listResourceBindingsOptions.regionBindingId() != null) {
            builder.query(new Object[]{"region_binding_id", String.valueOf(listResourceBindingsOptions.regionBindingId())});
        }
        if (listResourceBindingsOptions.limit() != null) {
            builder.query(new Object[]{"limit", String.valueOf(listResourceBindingsOptions.limit())});
        }
        if (listResourceBindingsOptions.start() != null) {
            builder.query(new Object[]{"start", String.valueOf(listResourceBindingsOptions.start())});
        }
        if (listResourceBindingsOptions.updatedFrom() != null) {
            builder.query(new Object[]{"updated_from", String.valueOf(listResourceBindingsOptions.updatedFrom())});
        }
        if (listResourceBindingsOptions.updatedTo() != null) {
            builder.query(new Object[]{"updated_to", String.valueOf(listResourceBindingsOptions.updatedTo())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceBindingsList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceBindingsList> listResourceBindings() {
        return this.listResourceBindings(null);
    }

    public ServiceCall<ResourceBinding> createResourceBinding(CreateResourceBindingOptions createResourceBindingOptions) {
        Validator.notNull((Object)((Object)createResourceBindingOptions), (String)"createResourceBindingOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_bindings"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createResourceBinding");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("source", createResourceBindingOptions.source());
        contentJson.addProperty("target", createResourceBindingOptions.target());
        if (createResourceBindingOptions.name() != null) {
            contentJson.addProperty("name", createResourceBindingOptions.name());
        }
        if (createResourceBindingOptions.parameters() != null) {
            contentJson.add("parameters", GsonSingleton.getGson().toJsonTree((Object)createResourceBindingOptions.parameters()));
        }
        if (createResourceBindingOptions.role() != null) {
            contentJson.addProperty("role", createResourceBindingOptions.role());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceBinding>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceBinding> getResourceBinding(GetResourceBindingOptions getResourceBindingOptions) {
        Validator.notNull((Object)((Object)getResourceBindingOptions), (String)"getResourceBindingOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", getResourceBindingOptions.id());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_bindings/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getResourceBinding");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceBinding>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteResourceBinding(DeleteResourceBindingOptions deleteResourceBindingOptions) {
        Validator.notNull((Object)((Object)deleteResourceBindingOptions), (String)"deleteResourceBindingOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", deleteResourceBindingOptions.id());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_bindings/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteResourceBinding");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceBinding> updateResourceBinding(UpdateResourceBindingOptions updateResourceBindingOptions) {
        Validator.notNull((Object)((Object)updateResourceBindingOptions), (String)"updateResourceBindingOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", updateResourceBindingOptions.id());
        RequestBuilder builder = RequestBuilder.patch((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_bindings/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"updateResourceBinding");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", updateResourceBindingOptions.name());
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceBinding>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceAliasesList> listResourceAliases(ListResourceAliasesOptions listResourceAliasesOptions) {
        if (listResourceAliasesOptions == null) {
            listResourceAliasesOptions = new ListResourceAliasesOptions.Builder().build();
        }
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_aliases"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listResourceAliases");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listResourceAliasesOptions.guid() != null) {
            builder.query(new Object[]{"guid", String.valueOf(listResourceAliasesOptions.guid())});
        }
        if (listResourceAliasesOptions.name() != null) {
            builder.query(new Object[]{"name", String.valueOf(listResourceAliasesOptions.name())});
        }
        if (listResourceAliasesOptions.resourceInstanceId() != null) {
            builder.query(new Object[]{"resource_instance_id", String.valueOf(listResourceAliasesOptions.resourceInstanceId())});
        }
        if (listResourceAliasesOptions.regionInstanceId() != null) {
            builder.query(new Object[]{"region_instance_id", String.valueOf(listResourceAliasesOptions.regionInstanceId())});
        }
        if (listResourceAliasesOptions.resourceId() != null) {
            builder.query(new Object[]{"resource_id", String.valueOf(listResourceAliasesOptions.resourceId())});
        }
        if (listResourceAliasesOptions.resourceGroupId() != null) {
            builder.query(new Object[]{"resource_group_id", String.valueOf(listResourceAliasesOptions.resourceGroupId())});
        }
        if (listResourceAliasesOptions.limit() != null) {
            builder.query(new Object[]{"limit", String.valueOf(listResourceAliasesOptions.limit())});
        }
        if (listResourceAliasesOptions.start() != null) {
            builder.query(new Object[]{"start", String.valueOf(listResourceAliasesOptions.start())});
        }
        if (listResourceAliasesOptions.updatedFrom() != null) {
            builder.query(new Object[]{"updated_from", String.valueOf(listResourceAliasesOptions.updatedFrom())});
        }
        if (listResourceAliasesOptions.updatedTo() != null) {
            builder.query(new Object[]{"updated_to", String.valueOf(listResourceAliasesOptions.updatedTo())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceAliasesList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceAliasesList> listResourceAliases() {
        return this.listResourceAliases(null);
    }

    public ServiceCall<ResourceAlias> createResourceAlias(CreateResourceAliasOptions createResourceAliasOptions) {
        Validator.notNull((Object)((Object)createResourceAliasOptions), (String)"createResourceAliasOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_aliases"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createResourceAlias");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createResourceAliasOptions.name());
        contentJson.addProperty("source", createResourceAliasOptions.source());
        contentJson.addProperty("target", createResourceAliasOptions.target());
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceAlias>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceAlias> getResourceAlias(GetResourceAliasOptions getResourceAliasOptions) {
        Validator.notNull((Object)((Object)getResourceAliasOptions), (String)"getResourceAliasOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", getResourceAliasOptions.id());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_aliases/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getResourceAlias");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceAlias>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteResourceAlias(DeleteResourceAliasOptions deleteResourceAliasOptions) {
        Validator.notNull((Object)((Object)deleteResourceAliasOptions), (String)"deleteResourceAliasOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", deleteResourceAliasOptions.id());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_aliases/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteResourceAlias");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (deleteResourceAliasOptions.recursive() != null) {
            builder.query(new Object[]{"recursive", String.valueOf(deleteResourceAliasOptions.recursive())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceAlias> updateResourceAlias(UpdateResourceAliasOptions updateResourceAliasOptions) {
        Validator.notNull((Object)((Object)updateResourceAliasOptions), (String)"updateResourceAliasOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", updateResourceAliasOptions.id());
        RequestBuilder builder = RequestBuilder.patch((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_aliases/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"updateResourceAlias");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", updateResourceAliasOptions.name());
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceAlias>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceBindingsList> listResourceBindingsForAlias(ListResourceBindingsForAliasOptions listResourceBindingsForAliasOptions) {
        Validator.notNull((Object)((Object)listResourceBindingsForAliasOptions), (String)"listResourceBindingsForAliasOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", listResourceBindingsForAliasOptions.id());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/resource_aliases/{id}/resource_bindings", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listResourceBindingsForAlias");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listResourceBindingsForAliasOptions.limit() != null) {
            builder.query(new Object[]{"limit", String.valueOf(listResourceBindingsForAliasOptions.limit())});
        }
        if (listResourceBindingsForAliasOptions.start() != null) {
            builder.query(new Object[]{"start", String.valueOf(listResourceBindingsForAliasOptions.start())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ResourceBindingsList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ReclamationsList> listReclamations(ListReclamationsOptions listReclamationsOptions) {
        if (listReclamationsOptions == null) {
            listReclamationsOptions = new ListReclamationsOptions.Builder().build();
        }
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/reclamations"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listReclamations");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listReclamationsOptions.accountId() != null) {
            builder.query(new Object[]{"account_id", String.valueOf(listReclamationsOptions.accountId())});
        }
        if (listReclamationsOptions.resourceInstanceId() != null) {
            builder.query(new Object[]{"resource_instance_id", String.valueOf(listReclamationsOptions.resourceInstanceId())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ReclamationsList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ReclamationsList> listReclamations() {
        return this.listReclamations(null);
    }

    public ServiceCall<Reclamation> runReclamationAction(RunReclamationActionOptions runReclamationActionOptions) {
        Validator.notNull((Object)((Object)runReclamationActionOptions), (String)"runReclamationActionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", runReclamationActionOptions.id());
        pathParamsMap.put("action_name", runReclamationActionOptions.actionName());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/reclamations/{id}/actions/{action_name}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"runReclamationAction");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (runReclamationActionOptions.requestBy() != null) {
            contentJson.addProperty("request_by", runReclamationActionOptions.requestBy());
        }
        if (runReclamationActionOptions.comment() != null) {
            contentJson.addProperty("comment", runReclamationActionOptions.comment());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Reclamation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

