/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.platform_services.resource_controller.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CreateResourceInstanceOptions
extends GenericModel {
    protected String name;
    protected String target;
    protected String resourceGroup;
    protected String resourcePlanId;
    protected List<String> tags;
    protected Boolean allowCleanup;
    protected Map<String, Object> parameters;
    protected Boolean entityLock;

    protected CreateResourceInstanceOptions() {
    }

    protected CreateResourceInstanceOptions(Builder builder) {
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        Validator.notNull((Object)builder.target, (String)"target cannot be null");
        Validator.notNull((Object)builder.resourceGroup, (String)"resourceGroup cannot be null");
        Validator.notNull((Object)builder.resourcePlanId, (String)"resourcePlanId cannot be null");
        this.name = builder.name;
        this.target = builder.target;
        this.resourceGroup = builder.resourceGroup;
        this.resourcePlanId = builder.resourcePlanId;
        this.tags = builder.tags;
        this.allowCleanup = builder.allowCleanup;
        this.parameters = builder.parameters;
        this.entityLock = builder.entityLock;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String name() {
        return this.name;
    }

    public String target() {
        return this.target;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public String resourcePlanId() {
        return this.resourcePlanId;
    }

    public List<String> tags() {
        return this.tags;
    }

    public Boolean allowCleanup() {
        return this.allowCleanup;
    }

    public Map<String, Object> parameters() {
        return this.parameters;
    }

    public Boolean entityLock() {
        return this.entityLock;
    }

    public static class Builder {
        private String name;
        private String target;
        private String resourceGroup;
        private String resourcePlanId;
        private List<String> tags;
        private Boolean allowCleanup;
        private Map<String, Object> parameters;
        private Boolean entityLock;

        private Builder(CreateResourceInstanceOptions createResourceInstanceOptions) {
            this.name = createResourceInstanceOptions.name;
            this.target = createResourceInstanceOptions.target;
            this.resourceGroup = createResourceInstanceOptions.resourceGroup;
            this.resourcePlanId = createResourceInstanceOptions.resourcePlanId;
            this.tags = createResourceInstanceOptions.tags;
            this.allowCleanup = createResourceInstanceOptions.allowCleanup;
            this.parameters = createResourceInstanceOptions.parameters;
            this.entityLock = createResourceInstanceOptions.entityLock;
        }

        public Builder() {
        }

        public Builder(String name, String target, String resourceGroup, String resourcePlanId) {
            this.name = name;
            this.target = target;
            this.resourceGroup = resourceGroup;
            this.resourcePlanId = resourcePlanId;
        }

        public CreateResourceInstanceOptions build() {
            return new CreateResourceInstanceOptions(this);
        }

        public Builder addTags(String tags) {
            Validator.notNull((Object)tags, (String)"tags cannot be null");
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.add(tags);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        public Builder resourceGroup(String resourceGroup) {
            this.resourceGroup = resourceGroup;
            return this;
        }

        public Builder resourcePlanId(String resourcePlanId) {
            this.resourcePlanId = resourcePlanId;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder allowCleanup(Boolean allowCleanup) {
            this.allowCleanup = allowCleanup;
            return this;
        }

        public Builder parameters(Map<String, Object> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder entityLock(Boolean entityLock) {
            this.entityLock = entityLock;
            return this;
        }
    }
}

