/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.monitor;

import com.ibm.db2.cmx.internal.controller.ControlDriver;
import com.ibm.db2.cmx.internal.controller.HttpControllerAgentImpl;
import com.ibm.db2.cmx.internal.controller.NPXControllerAgentImpl;
import com.ibm.db2.cmx.internal.core.JSONHelper;
import com.ibm.db2.cmx.internal.core.Message;
import com.ibm.db2.cmx.internal.json4j.JSONArray;
import com.ibm.db2.cmx.internal.metadata.DataBeanStatementExecution;
import com.ibm.db2.cmx.internal.metadata.DataBeanTransactionExecution;
import com.ibm.db2.cmx.internal.monitor.ClientInfoCache;
import com.ibm.db2.cmx.internal.monitor.MonitorAgentImpl;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxiedJdbcConnectionInvocationHandler;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PeriodicTask
extends TimerTask {
    private static Logger logger__ = Log.getCMXClientLogger();
    private Map<String, DataBeanTransactionExecution> transactionDataPool_ = new HashMap<String, DataBeanTransactionExecution>();
    private Map<String, DataBeanStatementExecution> statementDataPool_ = new HashMap<String, DataBeanStatementExecution>();
    private ClientInfoCache clientInfoCache_ = new ClientInfoCache();
    private ClientInfoCache endUOWClientInfoCache_ = new ClientInfoCache();
    private ClientInfoCache endUOWSettingsCache_ = new ClientInfoCache();
    private List<DataBeanTransactionExecution> inflightList_ = null;
    private int wasNumFreeCons_ = -1;
    private int wasPoolSize_ = -1;
    private WeakReference<MonitorAgentImpl> monitorAgentWeakReference_ = null;
    private Thread shutdownHook_ = null;
    private boolean isShutdownProcessing_ = false;
    private int intervalSeconds_;
    private long intervalEndMillis_;
    private boolean isCancelled_ = false;

    public void setIntervalSeconds(int n2) {
        this.intervalSeconds_ = n2;
        this.intervalEndMillis_ = System.currentTimeMillis() + (long)(this.intervalSeconds_ * 1000);
    }

    public PeriodicTask(MonitorAgentImpl monitorAgentImpl) {
        this.monitorAgentWeakReference_ = new WeakReference<MonitorAgentImpl>(monitorAgentImpl);
    }

    @Override
    public boolean cancel() {
        this.isCancelled_ = true;
        if (this.shutdownHook_ != null && !this.isShutdownProcessing_) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook_);
        }
        this.shutdownHook_ = null;
        return super.cancel();
    }

    public boolean isCancelled() {
        return this.isCancelled_;
    }

    @Override
    public void run() {
        try {
            MonitorAgentImpl monitorAgentImpl = (MonitorAgentImpl)this.monitorAgentWeakReference_.get();
            if (monitorAgentImpl == null) {
                this.cancel();
            } else {
                this.run(monitorAgentImpl);
            }
        }
        catch (Throwable throwable) {
            DataLogger.logTrappedMonitoringExceptionDebug(logger__, this, "run", throwable, "Trapped throwable in run");
            try {
                this.cancel();
                this.transactionDataPool_.clear();
                this.statementDataPool_.clear();
                if (this.inflightList_ != null) {
                    this.inflightList_.clear();
                }
                this.clientInfoCache_.clear();
                this.endUOWClientInfoCache_.clear();
                this.endUOWSettingsCache_.clear();
            }
            catch (Throwable throwable2) {
                DataLogger.logTrappedMonitoringExceptionDebug(logger__, this, "run", throwable2, "Trapped throwable while cleaning up in run");
            }
        }
    }

    public void run(MonitorAgentImpl monitorAgentImpl) {
        try {
            this.isCancelled_ = false;
            if (!this.isShutdownProcessing_ && this.shutdownHook_ == null) {
                this.shutdownHook_ = AccessController.doPrivileged(new ShutdownHookAction(this, "shutdownhook"));
            }
            if (this.intervalIsUp() || this.isShutdownProcessing_) {
                this.sendIntervalData(monitorAgentImpl);
                DataLogger.logRuntimeMemoryUsage(logger__);
                DataLogger.logActiveBeans(logger__, monitorAgentImpl, this);
            } else {
                List<DataBeanTransactionExecution> list = monitorAgentImpl.getPostTransactionsToSend();
                if (list.size() > 0) {
                    this.aggregate(list, monitorAgentImpl.getServerVersion());
                }
            }
        }
        catch (Throwable throwable) {
            DataLogger.logTrappedMonitoringExceptionDebug(logger__, this, "run(MonitorAgentImple ma)", throwable, "Trapped throwable in run(MonitorAgentImple ma)");
            try {
                this.cancel();
                monitorAgentImpl.unsynchronizedTransactionBeanClear();
                this.transactionDataPool_.clear();
                this.statementDataPool_.clear();
                if (this.inflightList_ != null) {
                    this.inflightList_.clear();
                }
                this.clientInfoCache_.clear();
                this.endUOWClientInfoCache_.clear();
                this.endUOWSettingsCache_.clear();
            }
            catch (Throwable throwable2) {
                DataLogger.logTrappedMonitoringExceptionDebug(logger__, this, "run(MonitorAgentImple ma)", throwable2, "Trapped throwable while cleaning up in run(MonitorAgentImple ma)");
            }
        }
    }

    public void logActiveBeans(Logger logger) {
        logger.fine("inflightList_ size = " + (this.inflightList_ != null ? this.inflightList_.size() : 0));
        logger.fine("transactionDataPool_ size = " + this.transactionDataPool_.size());
        logger.fine("statementDataPool_ size = " + this.statementDataPool_.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void aggregateInflight(List<DataBeanTransactionExecution> list) {
        try {
            for (int i10 = 0; i10 < list.size(); ++i10) {
                DataBeanTransactionExecution dataBeanTransactionExecution = list.get(i10);
                String string = dataBeanTransactionExecution.getKey();
                DataBeanTransactionExecution dataBeanTransactionExecution2 = this.transactionDataPool_.get(string);
                if (dataBeanTransactionExecution2 != null) {
                    dataBeanTransactionExecution = dataBeanTransactionExecution.cloneForInflight();
                    dataBeanTransactionExecution2.aggregateInflight(dataBeanTransactionExecution);
                    continue;
                }
                dataBeanTransactionExecution = dataBeanTransactionExecution.cloneForInflight();
                dataBeanTransactionExecution.prepareForAggregation();
                dataBeanTransactionExecution.aggregatedClientInfoCacheIndex_ = this.clientInfoCache_.getIndex(dataBeanTransactionExecution.getClientInfoString(), dataBeanTransactionExecution.clientInfoFields);
                dataBeanTransactionExecution.aggregatedEUOWClientInfoCacheIndex_ = this.endUOWClientInfoCache_.getIndex(dataBeanTransactionExecution.getEUOWClientInfoString(), dataBeanTransactionExecution.endUOWclientInfoFields_);
                this.transactionDataPool_.put(string, dataBeanTransactionExecution);
            }
        }
        finally {
            list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void aggregate(List<DataBeanTransactionExecution> list, int n2) {
        int n3 = -1;
        int n4 = 0;
        try {
            for (int i10 = 0; i10 < list.size(); ++i10) {
                int n5;
                DataBeanTransactionExecution dataBeanTransactionExecution = list.get(i10);
                String string = dataBeanTransactionExecution.getKey();
                DataBeanTransactionExecution dataBeanTransactionExecution2 = this.transactionDataPool_.get(string);
                if (dataBeanTransactionExecution2 != null) {
                    n5 = dataBeanTransactionExecution2.aggregatedClientInfoCacheIndex_;
                    n3 = dataBeanTransactionExecution2.aggregatedEUOWClientInfoCacheIndex_;
                    n4 = dataBeanTransactionExecution2.aggregatedEUOWSettingsCacheIndex_;
                    dataBeanTransactionExecution2.aggregate(dataBeanTransactionExecution);
                } else {
                    n5 = this.clientInfoCache_.getIndex(dataBeanTransactionExecution.getClientInfoString(), dataBeanTransactionExecution.clientInfoFields);
                    n3 = this.endUOWClientInfoCache_.getIndex(dataBeanTransactionExecution.getEUOWClientInfoString(), dataBeanTransactionExecution.endUOWclientInfoFields_);
                    n4 = this.endUOWSettingsCache_.getIndex(dataBeanTransactionExecution.getEUOWSettingsString(), dataBeanTransactionExecution.endUOWSettings_);
                    dataBeanTransactionExecution.prepareForAggregation();
                    dataBeanTransactionExecution.aggregatedClientInfoCacheIndex_ = n5;
                    dataBeanTransactionExecution.aggregatedEUOWClientInfoCacheIndex_ = n3;
                    dataBeanTransactionExecution.aggregatedEUOWSettingsCacheIndex_ = n4;
                    this.transactionDataPool_.put(string, dataBeanTransactionExecution);
                }
                if (dataBeanTransactionExecution.statementExecutions_ != null && dataBeanTransactionExecution.statementExecutions_.size() > 0) {
                    for (int i11 = 0; i11 < dataBeanTransactionExecution.statementExecutions_.size(); ++i11) {
                        DataBeanStatementExecution dataBeanStatementExecution = dataBeanTransactionExecution.statementExecutions_.get(i11);
                        dataBeanStatementExecution.authid_ = dataBeanTransactionExecution.authid_;
                        String string2 = dataBeanStatementExecution.getKey(n2) + string;
                        DataBeanStatementExecution dataBeanStatementExecution2 = this.statementDataPool_.get(string2);
                        if (dataBeanStatementExecution2 != null) {
                            dataBeanStatementExecution2.aggregate(dataBeanStatementExecution);
                            continue;
                        }
                        dataBeanStatementExecution.prepareForAggregation();
                        dataBeanStatementExecution.aggregatedClientInfoCacheIndex_ = n5;
                        dataBeanStatementExecution.aggregatedEUOWClientInfoCacheIndex_ = n3;
                        dataBeanStatementExecution.aggregatedEUOWSettingsCacheIndex_ = n4;
                        this.statementDataPool_.put(string2, dataBeanStatementExecution);
                    }
                }
                if (dataBeanTransactionExecution.wasGetConnectionData_ == null || dataBeanTransactionExecution.wasGetConnectionData_.length < 5) continue;
                this.wasNumFreeCons_ = (Integer)dataBeanTransactionExecution.wasGetConnectionData_[3];
                this.wasPoolSize_ = (Integer)dataBeanTransactionExecution.wasGetConnectionData_[4];
            }
        }
        finally {
            list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInflightTransactions(MonitorAgentImpl monitorAgentImpl) {
        WeakHashMap<Object, Object> weakHashMap;
        if (this.inflightList_ == null) {
            this.inflightList_ = new ArrayList<DataBeanTransactionExecution>();
        }
        WeakHashMap<Object, Object> weakHashMap2 = weakHashMap = monitorAgentImpl.proxiedDataSource_.getActiveConnectionInvocationHandlers();
        synchronized (weakHashMap2) {
            for (ProxiedJdbcConnectionInvocationHandler proxiedJdbcConnectionInvocationHandler : weakHashMap.keySet()) {
                DataBeanTransactionExecution dataBeanTransactionExecution;
                if (proxiedJdbcConnectionInvocationHandler == null || (dataBeanTransactionExecution = proxiedJdbcConnectionInvocationHandler.transactionBean_) == null || !dataBeanTransactionExecution.transactionStarted()) continue;
                if (logger__.isLoggable(Level.FINER)) {
                    logger__.finer("Processing inflight connection: " + DataLogger.getShortName(proxiedJdbcConnectionInvocationHandler));
                }
                this.inflightList_.add(dataBeanTransactionExecution);
            }
        }
        if (logger__.isLoggable(Level.FINER)) {
            logger__.finer("Processing " + this.inflightList_.size() + " active transactions");
        }
        this.aggregateInflight(this.inflightList_);
    }

    public Message createMessage(MonitorAgentImpl monitorAgentImpl) {
        Object object;
        Object object2;
        List<DataBeanTransactionExecution> list = monitorAgentImpl.getPostTransactionsToSend();
        int n2 = monitorAgentImpl.getNegotiatedVersion();
        if (list.size() > 0) {
            this.aggregate(list, n2);
        }
        if (n2 >= 2) {
            this.processInflightTransactions(monitorAgentImpl);
        }
        JSONArray jSONArray = new JSONArray();
        Iterator<String> iterator = this.transactionDataPool_.keySet().iterator();
        long l10 = -1L;
        int n3 = -1;
        while (iterator.hasNext()) {
            object2 = this.transactionDataPool_.get(iterator.next());
            if (((DataBeanTransactionExecution)object2).aggregatedWasMaxPoolWaitTime_ > l10) {
                l10 = ((DataBeanTransactionExecution)object2).aggregatedWasMaxPoolWaitTime_;
                n3 = ((DataBeanTransactionExecution)object2).aggregatedWasMaxPoolWaitTimeType_;
            }
            if (monitorAgentImpl.isHttp_) {
                jSONArray.add(((DataBeanTransactionExecution)object2).toJSON_DSM());
                continue;
            }
            jSONArray.add(((DataBeanTransactionExecution)object2).toJSON(n2));
        }
        this.transactionDataPool_.clear();
        object2 = new JSONArray();
        if (l10 > -1L) {
            ((JSONArray)object2).add((Object)(this.wasPoolSize_ - this.wasNumFreeCons_));
            ((JSONArray)object2).add((Object)this.wasNumFreeCons_);
            ((JSONArray)object2).add((Object)n3);
            ((JSONArray)object2).add((Object)l10);
        }
        JSONArray jSONArray2 = new JSONArray();
        iterator = this.statementDataPool_.keySet().iterator();
        while (iterator.hasNext()) {
            if (monitorAgentImpl.isHttp_) {
                jSONArray2.add(this.statementDataPool_.get(iterator.next()).toJSON_DSM());
                continue;
            }
            jSONArray2.add(this.statementDataPool_.get(iterator.next()).toJSON(n2));
        }
        this.statementDataPool_.clear();
        JSONArray jSONArray3 = new JSONArray();
        int n4 = 2;
        jSONArray3.add((Object)monitorAgentImpl.proxiedDataSource_.getDatasourceId());
        if (monitorAgentImpl.isHttp_) {
            jSONArray3.add(monitorAgentImpl.proxiedDataSource_.getControlDataSource().getDataSourceId());
        }
        jSONArray3.add((Object)System.currentTimeMillis());
        jSONArray3.add((Object)monitorAgentImpl.intervalSeconds_);
        jSONArray3.add((Object)1);
        jSONArray3.add(this.clientInfoCache_.toJSONArray());
        if (n2 >= 3 && !monitorAgentImpl.isHttp_) {
            jSONArray3.add(this.endUOWClientInfoCache_.toJSONArray());
            jSONArray3.add(this.endUOWSettingsCache_.toJSONArray());
        }
        if (!monitorAgentImpl.sendConnectionData_ || monitorAgentImpl.postConnectionBean_ == null) {
            jSONArray3.add(new JSONArray());
        } else if (monitorAgentImpl.isHttp_) {
            jSONArray3.add(monitorAgentImpl.postConnectionBean_.toJSON_DSM());
            n4 = 1;
        } else {
            jSONArray3.add(monitorAgentImpl.postConnectionBean_.toJSON(n2));
        }
        jSONArray3.add(jSONArray2);
        jSONArray3.add(jSONArray);
        jSONArray3.add(object2);
        JSONArray jSONArray4 = new JSONArray();
        if (monitorAgentImpl.isHttp_) {
            jSONArray4.add("14");
            jSONArray4.add(ControlDriver.getInstance().getUUID());
            jSONArray4.add(ControlDriver.getInstance().getDriverID());
        } else {
            jSONArray4.add("peri");
        }
        if (n2 >= 4) {
            jSONArray4.add((Object)monitorAgentImpl.dispatchToken_);
        }
        jSONArray4.add(jSONArray3);
        if (monitorAgentImpl.httpCA_ instanceof NPXControllerAgentImpl) {
            try {
                object = this.buildWriteParameters(n4, "CIDB.STORE.NAME", "CIDB-SERVER-NAME");
                ((NPXControllerAgentImpl)monitorAgentImpl.httpCA_).writePayloadToNewton(monitorAgentImpl.proxiedDataSource_.getDatasourceId(), (JSONArray)object, jSONArray4);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                System.err.println(sQLException.getMessage());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.err.println(iOException.getMessage());
            }
        }
        object = monitorAgentImpl.isHttp_ ? new Message("ClientPropertyProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray4))) : new Message("Monitor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray4)));
        return object;
    }

    private JSONArray buildWriteParameters(int n2, String string, String string2) {
        JSONArray jSONArray = new JSONArray(4);
        jSONArray.add(0, string);
        jSONArray.add(1, string2);
        jSONArray.add(2, (Object)n2);
        if (logger__.isLoggable(Level.FINER)) {
            jSONArray.add(3, (Object)1);
        } else {
            jSONArray.add(3, (Object)0);
        }
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "buildWriteParameters", "writeParameters built for writePayload call:  " + jSONArray.toString());
        }
        return jSONArray;
    }

    public synchronized void sendIntervalData(MonitorAgentImpl monitorAgentImpl) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "sendIntervalData", "ENTRY " + Arrays.deepToString(new Object[]{monitorAgentImpl}));
        }
        try {
            block26: {
                block25: {
                    if (!monitorAgentImpl.bGotInitialIntervalPropertes_ && monitorAgentImpl.proxiedDataSource_.hasInitialLookupOccurred()) {
                        monitorAgentImpl.proxiedDataSource_.getIntervalProperties();
                        monitorAgentImpl.bGotInitialIntervalPropertes_ = true;
                    }
                    this.resetInterval();
                    if (!monitorAgentImpl.isConnectionActive()) {
                        try {
                            if (logger__.isLoggable(Level.FINE)) {
                                DataLogger.logConnectedComponents(logger__, this, "sendIntervalData", "connecting to monitor agent: ");
                            }
                            monitorAgentImpl.getConnection();
                            monitorAgentImpl.isConnectionActive_ = true;
                        }
                        catch (IOException iOException) {
                            if (!logger__.isLoggable(Level.FINEST)) break block25;
                            DataLogger.logTrappedMonitoringException(logger__, this, "sendIntervalData", iOException, "monitor agent connect failed: " + monitorAgentImpl.connection_);
                        }
                    }
                }
                if (!monitorAgentImpl.isHttp_ && !monitorAgentImpl.isConnected()) {
                    monitorAgentImpl.isConnectionActive_ = false;
                    try {
                        if (logger__.isLoggable(Level.FINE)) {
                            DataLogger.logConnectedComponents(logger__, this, "sendIntervalData", "monitor agent is disconnected, attempting reconnect: " + monitorAgentImpl.connection_);
                        }
                        monitorAgentImpl.connection_.reconnect();
                        monitorAgentImpl.isConnectionActive_ = true;
                    }
                    catch (IOException iOException) {
                        if (!logger__.isLoggable(Level.FINEST)) break block26;
                        DataLogger.logTrappedMonitoringException(logger__, this, "sendIntervalData", iOException, "monitor agent is disconnected, reconnect failed: " + monitorAgentImpl.connection_);
                    }
                }
            }
            if (monitorAgentImpl.isConnected()) {
                Message message = this.createMessage(monitorAgentImpl);
                if (monitorAgentImpl.isHttp_) {
                    if (monitorAgentImpl.httpCA_ instanceof HttpControllerAgentImpl) {
                        ((HttpControllerAgentImpl)monitorAgentImpl.httpCA_).sendHttpEIPayloadWithReceive(message);
                    }
                } else if (this.isShutdownProcessing_) {
                    monitorAgentImpl.connection_.sendMessage(message);
                    monitorAgentImpl.connection_.close();
                } else {
                    monitorAgentImpl.connection_.queueMessage(message);
                }
                if (logger__.isLoggable(Level.FINE)) {
                    DataLogger.logConnectedComponents(logger__, this, "sendIntervalData", "Monitor data was sent");
                }
                if (monitorAgentImpl.sendConnectionData_ && monitorAgentImpl.postConnectionBean_ != null) {
                    monitorAgentImpl.sendConnectionData_ = false;
                }
                this.clientInfoCache_.clear();
                this.endUOWClientInfoCache_.clear();
                this.endUOWSettingsCache_.clear();
            } else {
                this.cancel();
                monitorAgentImpl.unsynchronizedTransactionBeanClear();
                this.transactionDataPool_.clear();
                this.statementDataPool_.clear();
                if (this.inflightList_ != null) {
                    this.inflightList_.clear();
                }
                this.clientInfoCache_.clear();
                this.endUOWClientInfoCache_.clear();
                this.endUOWSettingsCache_.clear();
            }
            monitorAgentImpl.proxiedDataSource_.getIntervalProperties();
        }
        catch (Throwable throwable) {
            DataLogger.logTrappedMonitoringExceptionDebug(logger__, this, "sendIntervalData", throwable, "Trapped throwable in sendIntervalData");
            try {
                this.cancel();
                monitorAgentImpl.unsynchronizedTransactionBeanClear();
                this.transactionDataPool_.clear();
                this.statementDataPool_.clear();
                if (this.inflightList_ != null) {
                    this.inflightList_.clear();
                }
                this.clientInfoCache_.clear();
                this.endUOWClientInfoCache_.clear();
                this.endUOWSettingsCache_.clear();
            }
            catch (Throwable throwable2) {
                DataLogger.logTrappedMonitoringExceptionDebug(logger__, this, "sendIntervalData", throwable2, "Trapped throwable while cleaning up in sendIntervalData");
            }
        }
    }

    private boolean intervalIsUp() {
        boolean bl2 = System.currentTimeMillis() >= this.intervalEndMillis_;
        return bl2;
    }

    private void resetInterval() {
        this.intervalEndMillis_ += (long)(this.intervalSeconds_ * 1000);
    }

    class ShutdownHookRunnable
    implements Runnable {
        TimerTask tt_;

        public ShutdownHookRunnable(TimerTask timerTask) {
            this.tt_ = timerTask;
        }

        @Override
        public void run() {
            try {
                DataLogger.logMonitorMessage(logger__, this, "run", "Running shutdown hook");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            PeriodicTask.this.isShutdownProcessing_ = true;
            this.tt_.cancel();
            this.tt_.run();
        }
    }

    public static class ShutdownHookAction
    implements PrivilegedAction<Thread> {
        private PeriodicTask periodicTask_ = null;
        private String name_ = null;

        public ShutdownHookAction(PeriodicTask periodicTask, String string) {
            this.periodicTask_ = periodicTask;
            this.name_ = string;
        }

        @Override
        public Thread run() {
            PeriodicTask periodicTask = this.periodicTask_;
            periodicTask.getClass();
            Thread thread = new Thread((Runnable)periodicTask.new ShutdownHookRunnable(this.periodicTask_), this.name_);
            try {
                Runtime.getRuntime().addShutdownHook(thread);
            }
            catch (IllegalStateException illegalStateException) {
                DataLogger.logThrowable(null, illegalStateException);
            }
            return thread;
        }
    }
}

