/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client;

import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.DnsNameResolverProvider;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class StaticEtcdNameResolverFactory
extends NameResolver.Factory {
    public static final String ETCD = "etcd";
    protected static final NameResolver.Factory DNS_PROVIDER = new DnsNameResolverProvider();
    protected static final Pattern ADDR_PATT = Pattern.compile("(?:https?://)?([a-zA-Z0-9\\-.]+)(?::(\\d+))?");
    private final URI[] uris;

    public StaticEtcdNameResolverFactory(List<String> endpoints) {
        if (endpoints == null || endpoints.isEmpty()) {
            throw new IllegalArgumentException("endpoints");
        }
        int count = endpoints.size();
        this.uris = new URI[count];
        for (int i = 0; i < count; ++i) {
            String endpoint = endpoints.get(i).trim();
            Matcher m = ADDR_PATT.matcher(endpoint);
            if (!m.matches()) {
                throw new IllegalArgumentException("invalid endpoint: " + endpoint);
            }
            String portStr = m.group(2);
            if (portStr == null) {
                portStr = String.valueOf(2379);
            }
            this.uris[i] = URI.create("dns:///" + m.group(1) + ":" + portStr);
        }
        if (count > 1) {
            Collections.shuffle(Arrays.asList(this.uris));
        }
    }

    public NameResolver newNameResolver(URI targetUri, NameResolver.Helper helper) {
        if (!ETCD.equals(targetUri.getScheme())) {
            return null;
        }
        if (this.uris.length == 1) {
            return new SubResolver((URI)this.uris[0], (NameResolver.Helper)helper).resolver;
        }
        final SubResolver[] resolvers = this.createSubResolvers(helper);
        return new NameResolver(){
            int currentCount = 0;

            public void start(final NameResolver.Listener listener) {
                for (final SubResolver sr : resolvers) {
                    sr.resolver.start(new NameResolver.Listener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onAddresses(List<EquivalentAddressGroup> servers, Attributes attributes) {
                            SubResolver[] subResolverArray = resolvers;
                            synchronized (resolvers) {
                                sr.eagList = servers;
                                List newList = Stream.of(resolvers).flatMap(r -> r.eagList.stream()).collect(Collectors.toList());
                                currentCount = newList.size();
                                listener.onAddresses(newList, Attributes.EMPTY);
                                // ** MonitorExit[var3_3] (shouldn't be in output)
                                return;
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onError(Status error) {
                            SubResolver[] subResolverArray = resolvers;
                            synchronized (resolvers) {
                                if (currentCount == 0) {
                                    listener.onError(error);
                                }
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return;
                            }
                        }
                    });
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void refresh() {
                SubResolver[] subResolverArray = resolvers;
                synchronized (resolvers) {
                    for (SubResolver sr : resolvers) {
                        sr.resolver.refresh();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }

            public String getServiceAuthority() {
                return StaticEtcdNameResolverFactory.ETCD;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void shutdown() {
                SubResolver[] subResolverArray = resolvers;
                synchronized (resolvers) {
                    for (SubResolver sr : resolvers) {
                        sr.resolver.shutdown();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
    }

    private SubResolver[] createSubResolvers(NameResolver.Helper helper) {
        int count = this.uris.length;
        SubResolver[] resolvers = new SubResolver[count];
        for (int i = 0; i < count; ++i) {
            resolvers[i] = new SubResolver(this.uris[i], helper);
        }
        return resolvers;
    }

    public String getDefaultScheme() {
        return ETCD;
    }

    static class SubResolver {
        final NameResolver resolver;
        List<EquivalentAddressGroup> eagList = Collections.emptyList();

        public SubResolver(URI uri, NameResolver.Helper helper) {
            this.resolver = DNS_PROVIDER.newNameResolver(uri, helper);
        }
    }
}

