/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client.utils;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import com.ibm.etcd.api.PutRequest;
import com.ibm.etcd.api.RangeRequest;
import com.ibm.etcd.client.EtcdClient;
import com.ibm.etcd.client.GrpcClient;
import com.ibm.etcd.client.ListenerObserver;
import com.ibm.etcd.client.kv.KvClient;
import com.ibm.etcd.client.lease.PersistentLease;
import com.ibm.etcd.client.utils.RangeCache;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;

public class PersistentLeaseKey
extends AbstractFuture<ByteString>
implements AutoCloseable {
    private final EtcdClient client;
    protected final ByteString key;
    protected final ListenerObserver<PersistentLease.LeaseState> stateObserver;
    private final RangeCache rangeCache;
    private PersistentLease lease;
    private Executor executor;
    private volatile ByteString defaultValue;
    protected boolean leaseActive;
    protected ListenableFuture<?> updateFuture;
    protected SettableFuture<Object> closeFuture;

    public PersistentLeaseKey(EtcdClient client, PersistentLease lease, ByteString key, ByteString defaultValue, RangeCache rangeCache) {
        this.client = (EtcdClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.rangeCache = rangeCache;
        this.lease = lease;
        this.key = (ByteString)Preconditions.checkNotNull((Object)key, (Object)"key");
        this.defaultValue = defaultValue;
        this.stateObserver = this::leaseStateChanged;
    }

    protected void leaseStateChanged(boolean c, PersistentLease.LeaseState newState, Throwable t) {
        this.executor.execute(() -> {
            if (newState == PersistentLease.LeaseState.ACTIVE) {
                this.leaseActive = true;
                this.putKey(this.lease.getLeaseId());
            } else {
                this.leaseActive = false;
            }
        });
    }

    @Deprecated
    protected boolean isActive() {
        return this.leaseActive;
    }

    public PersistentLeaseKey(EtcdClient client, ByteString key, ByteString defaultValue, RangeCache rangeCache) {
        this(client, client.getSessionLease(), key, defaultValue, rangeCache);
    }

    public synchronized void start() {
        if (this.executor != null) {
            throw new IllegalStateException("already started");
        }
        if (this.closeFuture != null) {
            throw new IllegalStateException("closed");
        }
        this.executor = GrpcClient.serialized(this.client.getExecutor());
        if (this.lease == null) {
            this.lease = this.client.getSessionLease();
        }
        this.lease.addStateObserver(this.stateObserver, true);
    }

    public ListenableFuture<ByteString> startWithFuture() {
        this.start();
        return this;
    }

    public void setDefaultValue(ByteString value) {
        this.defaultValue = (ByteString)Preconditions.checkNotNull((Object)value, (Object)"value");
    }

    protected void putKey(long leaseId) {
        ListenableFuture fut;
        if (leaseId == 0L || this.closeFuture != null) {
            return;
        }
        if (this.updateFuture != null && !this.updateFuture.isDone()) {
            this.updateFuture.cancel(false);
            return;
        }
        PutRequest.Builder putBld = PutRequest.newBuilder().setKey(this.key).setLease(leaseId);
        KvClient.FluentTxnRequest req = (KvClient.FluentTxnRequest)this.client.getKvClient().txnIf().exists(this.key).backoffRetry(() -> this.closeFuture == null && this.leaseActive);
        if (this.rangeCache == null) {
            fut = ((KvClient.FluentTxnSuccOps)req.then().put(putBld.setIgnoreValue(true))).elseDo().put(putBld.setIgnoreValue(false).setValue(this.defaultValue)).async(this.executor);
        } else {
            RangeRequest getOp = RangeRequest.newBuilder().setKey(this.key).build();
            ListenableFuture txnFut = ((KvClient.FluentTxnSuccOps)((KvClient.FluentTxnSuccOps)req.then().put(putBld.setIgnoreValue(true))).get(getOp)).elseDo().put(putBld.setIgnoreValue(false).setValue(this.defaultValue)).get(getOp).async(this.executor);
            fut = Futures.transform(txnFut, tr -> this.rangeCache.offerUpdate(tr.getResponses(1).getResponseRange().getKvs(0), false), (Executor)MoreExecutors.directExecutor());
        }
        if (!this.isDone()) {
            fut = Futures.transform(fut, r -> this.set(this.key), (Executor)MoreExecutors.directExecutor());
        }
        Futures.addCallback((ListenableFuture)fut, (v, t) -> {
            if (t instanceof CancellationException && this.leaseActive) {
                this.putKey(leaseId);
            }
        }, (Executor)MoreExecutors.directExecutor());
        this.updateFuture = fut;
    }

    protected void interruptTask() {
        this.close();
    }

    @Override
    public void close() {
        this.closeWithFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<?> closeWithFuture() {
        boolean notStarted = false;
        PersistentLeaseKey persistentLeaseKey = this;
        synchronized (persistentLeaseKey) {
            if (this.closeFuture != null) {
                return this.closeFuture;
            }
            this.closeFuture = SettableFuture.create();
            if (this.executor == null) {
                notStarted = true;
            } else {
                this.lease.removeStateObserver(this.stateObserver);
                this.executor.execute(() -> {
                    if (this.updateFuture == null || this.updateFuture.isDone()) {
                        this.deleteKey();
                    } else {
                        this.updateFuture.addListener(this::deleteKey, this.executor);
                    }
                });
            }
        }
        this.setException(new CancellationException("closed"));
        if (notStarted) {
            this.closeFuture.set(null);
        }
        return this.closeFuture;
    }

    private void deleteKey() {
        ((KvClient.FluentDeleteRequest)this.client.getKvClient().delete(this.key).backoffRetry(() -> this.lease.getState() != PersistentLease.LeaseState.CLOSED)).async().addListener(() -> this.closeFuture.set(null), MoreExecutors.directExecutor());
    }
}

