/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.cache;

import com.ibm.fhir.cache.CacheKey;
import com.ibm.fhir.cache.annotation.Cacheable;
import com.ibm.fhir.cache.util.CacheSupport;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class CachingProxy {
    private CachingProxy() {
    }

    public static <T> T newInstance(Class<T> interfaceClass, T target) {
        Objects.requireNonNull(interfaceClass, "interfaceClass");
        Objects.requireNonNull(target, "target");
        return interfaceClass.cast(Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new CachingInvocationHandler(target)));
    }

    public static boolean hasCacheableMethod(Class<?> targetClass) {
        Objects.requireNonNull(targetClass, "targetClass");
        for (Method method : targetClass.getMethods()) {
            if (!CachingProxy.isCacheable(method)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCacheable(Method method) {
        return method.isAnnotationPresent(Cacheable.class);
    }

    private static class CachingInvocationHandler
    implements InvocationHandler {
        private static final Object NULL = new Object();
        private final Object target;
        private final Class<?> targetClass;
        private final Map<Method, Method> targetMethodCache = new ConcurrentHashMap<Method, Method>();
        private final Map<Class<? extends KeyGenerator>, KeyGenerator> keyGeneratorCache = new ConcurrentHashMap<Class<? extends KeyGenerator>, KeyGenerator>();
        private final Map<Method, Map<CacheKey, Object>> resultCacheMap = new ConcurrentHashMap<Method, Map<CacheKey, Object>>();

        public CachingInvocationHandler(Object target) {
            this.target = Objects.requireNonNull(target, "target");
            this.targetClass = target.getClass();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Method targetMethod = this.targetMethodCache.computeIfAbsent(method, k -> this.computeTargetMethod(method));
                if (CachingProxy.isCacheable(targetMethod)) {
                    Cacheable cacheable = targetMethod.getAnnotation(Cacheable.class);
                    KeyGenerator keyGenerator = this.getKeyGenerator(cacheable.keyGeneratorClass());
                    CacheKey key = keyGenerator.generate(this.target, targetMethod, args);
                    Map resultCache = this.resultCacheMap.computeIfAbsent(targetMethod, k -> this.createCacheAsMap(cacheable));
                    Object result = resultCache.computeIfAbsent(key, k -> this.computeResult(targetMethod, args));
                    return result != NULL ? result : null;
                }
                return targetMethod.invoke(this.target, args);
            }
            catch (WrappedException e) {
                Exception unwrapped = this.unwrap(e);
                if (unwrapped instanceof InvocationTargetException && unwrapped.getCause() instanceof Exception) {
                    throw unwrapped.getCause();
                }
                throw unwrapped;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof Exception) {
                    throw e.getCause();
                }
                throw e;
            }
        }

        private Method computeTargetMethod(Method method) {
            try {
                return this.targetClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (Exception e) {
                throw this.wrap(e);
            }
        }

        private KeyGenerator getKeyGenerator(Class<? extends KeyGenerator> keyGeneratorClass) {
            if (KeyGenerator.class.equals(keyGeneratorClass)) {
                return KeyGenerator.DEFAULT;
            }
            return this.keyGeneratorCache.computeIfAbsent(keyGeneratorClass, k -> this.computeKeyGenerator(keyGeneratorClass));
        }

        private KeyGenerator computeKeyGenerator(Class<? extends KeyGenerator> keyGeneratorClass) {
            try {
                return keyGeneratorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw this.wrap(e);
            }
        }

        private <K, V> Map<K, V> createCacheAsMap(Cacheable cacheable) {
            return CacheSupport.createCacheAsMap(cacheable.maximumSize(), Duration.of(cacheable.duration(), cacheable.unit()));
        }

        private Object computeResult(Method targetMethod, Object[] args) {
            try {
                Object result = targetMethod.invoke(this.target, args);
                return result != null ? result : NULL;
            }
            catch (Exception e) {
                throw this.wrap(e);
            }
        }

        private WrappedException wrap(Exception e) {
            return new WrappedException(e);
        }

        private Exception unwrap(WrappedException e) {
            return (Exception)e.getCause();
        }

        private static class WrappedException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            public WrappedException(Exception e) {
                super(e);
            }
        }
    }

    public static interface KeyGenerator {
        public static final KeyGenerator DEFAULT = new KeyGenerator(){

            @Override
            public CacheKey generate(Object target, Method method, Object[] args) {
                return CacheKey.key(method, args);
            }
        };

        public CacheKey generate(Object var1, Method var2, Object[] var3);
    }
}

