/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.cache.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Map;

public final class CacheSupport {
    private CacheSupport() {
    }

    public static <K, V> Cache<K, V> createCache(Duration duration) {
        return CacheSupport.createCache(duration, false);
    }

    public static <K, V> Cache<K, V> createCache(Duration duration, boolean recordStats) {
        if (recordStats) {
            return Caffeine.newBuilder().expireAfterWrite(duration).recordStats().build();
        }
        return Caffeine.newBuilder().expireAfterWrite(duration).build();
    }

    public static <K, V> Cache<K, V> createCache(int maximumSize) {
        return CacheSupport.createCache(maximumSize, false);
    }

    public static <K, V> Cache<K, V> createCache(int maximumSize, boolean recordStats) {
        if (recordStats) {
            return Caffeine.newBuilder().maximumSize((long)maximumSize).recordStats().build();
        }
        return Caffeine.newBuilder().maximumSize((long)maximumSize).build();
    }

    public static <K, V> Cache<K, V> createCache(int maximumSize, Duration duration) {
        return CacheSupport.createCache(maximumSize, duration, false);
    }

    public static <K, V> Cache<K, V> createCache(int maximumSize, Duration duration, boolean recordStats) {
        if (recordStats) {
            return Caffeine.newBuilder().maximumSize((long)maximumSize).expireAfterWrite(duration).recordStats().build();
        }
        return Caffeine.newBuilder().maximumSize((long)maximumSize).expireAfterWrite(duration).build();
    }

    public static <K, V> Map<K, V> createCacheAsMap(Duration duration) {
        Cache<K, V> cache = CacheSupport.createCache(duration);
        return cache.asMap();
    }

    public static <K, V> Map<K, V> createCacheAsMap(int maximumSize) {
        Cache<K, V> cache = CacheSupport.createCache(maximumSize);
        return cache.asMap();
    }

    public static <K, V> Map<K, V> createCacheAsMap(int maximumSize, Duration duration) {
        Cache<K, V> cache = CacheSupport.createCache(maximumSize, duration);
        return cache.asMap();
    }
}

