/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.cache;

import java.util.Arrays;
import java.util.Objects;

public class CacheKey {
    private final Object[] values;
    private final int hashCode;

    private CacheKey(Object[] values) {
        Objects.requireNonNull(values, "values");
        if (values.length == 0) {
            throw new IllegalStateException("CacheKey values array length cannot be zero");
        }
        this.values = values;
        this.hashCode = Arrays.deepHashCode(values);
    }

    public Object[] values() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheKey other = (CacheKey)obj;
        return Arrays.deepEquals(this.values, other.values);
    }

    public String toString() {
        return Arrays.deepToString(this.values);
    }

    public static CacheKey key(Object ... values) {
        return new CacheKey(values);
    }
}

