/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.ibm.fhir.cache.util.CacheSupport;
import com.ibm.fhir.core.TenantIdProvider;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class CacheManager {
    private static final Map<String, Map<String, Cache<?, ?>>> TENANT_CACHE_MAPS = new ConcurrentHashMap();
    private static final TenantIdProvider TENANT_ID_PROVIDER = TenantIdProvider.provider();

    private CacheManager() {
    }

    public Set<String> getCacheNames() {
        String tenantId = TENANT_ID_PROVIDER.getTenantId();
        return TENANT_CACHE_MAPS.getOrDefault(tenantId, Collections.emptyMap()).keySet();
    }

    public static <K, V> Cache<K, V> getCache(String cacheName) {
        Objects.requireNonNull(cacheName, "cacheName");
        String tenantId = TENANT_ID_PROVIDER.getTenantId();
        Map tenantCacheMap = TENANT_CACHE_MAPS.getOrDefault(tenantId, Collections.emptyMap());
        return (Cache)tenantCacheMap.get(cacheName);
    }

    public static <K, V> Cache<K, V> getCache(String cacheName, Configuration configuration) {
        Objects.requireNonNull(cacheName, "cacheName");
        Objects.requireNonNull(configuration, "configuration");
        String tenantId = TENANT_ID_PROVIDER.getTenantId();
        Map tenantCacheMap = TENANT_CACHE_MAPS.computeIfAbsent(tenantId, k -> new ConcurrentHashMap());
        return tenantCacheMap.computeIfAbsent(cacheName, k -> CacheManager.createCache(configuration));
    }

    public static <K, V> Map<K, V> getCacheAsMap(String cacheName) {
        Objects.requireNonNull(cacheName, "cacheName");
        Cache<K, V> cache = CacheManager.getCache(cacheName);
        return cache != null ? cache.asMap() : null;
    }

    public static <K, V> Map<K, V> getCacheAsMap(String cacheName, Configuration configuration) {
        Objects.requireNonNull(cacheName, "cacheName");
        Objects.requireNonNull(configuration, "configuration");
        Cache<K, V> cache = CacheManager.getCache(cacheName, configuration);
        return cache.asMap();
    }

    public static CacheStats getCacheStats(String cacheName) {
        Cache cache = CacheManager.getCache(cacheName);
        return cache != null ? cache.stats() : null;
    }

    public static void invalidate(String cacheName, Object key) {
        Cache cache = CacheManager.getCache(cacheName);
        if (cache != null) {
            cache.invalidate(key);
        }
    }

    public static void invalidateAll(String cacheName) {
        Cache cache = CacheManager.getCache(cacheName);
        if (cache != null) {
            cache.invalidateAll();
        }
    }

    public static boolean isManaged(String cacheName) {
        if (cacheName != null) {
            String tenantId = TENANT_ID_PROVIDER.getTenantId();
            return TENANT_CACHE_MAPS.getOrDefault(tenantId, Collections.emptyMap()).containsKey(cacheName);
        }
        return false;
    }

    public static void removeCache(String cacheName) {
        String tenantId;
        Map<String, Cache<?, ?>> tenantCacheMap;
        if (cacheName != null && (tenantCacheMap = TENANT_CACHE_MAPS.get(tenantId = TENANT_ID_PROVIDER.getTenantId())) != null) {
            tenantCacheMap.remove(cacheName);
        }
    }

    private static <K, V> Cache<K, V> createCache(Configuration configuration) {
        if (Objects.nonNull(configuration.getMaximumSize()) && Objects.nonNull(configuration.getDuration())) {
            return CacheSupport.createCache(configuration.getMaximumSize(), configuration.getDuration(), true);
        }
        if (Objects.nonNull(configuration.getMaximumSize())) {
            return CacheSupport.createCache((int)configuration.getMaximumSize(), true);
        }
        return CacheSupport.createCache(configuration.getDuration(), true);
    }

    public static class Configuration {
        private final Integer maximumSize;
        private final Duration duration;

        private Configuration(int maximumSize) {
            this(maximumSize, null);
        }

        private Configuration(Duration duration) {
            this(null, duration);
        }

        private Configuration(Integer maximumSize, Duration duration) {
            this.maximumSize = maximumSize;
            this.duration = duration;
        }

        public Integer getMaximumSize() {
            return this.maximumSize;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Configuration other = (Configuration)obj;
            return Objects.equals(this.maximumSize, other.maximumSize) && Objects.equals(this.duration, other.duration);
        }

        public int hashCode() {
            return Objects.hash(this.maximumSize, this.duration);
        }

        public static Configuration of(int maximumSize) {
            return new Configuration(maximumSize);
        }

        public static Configuration of(int maximumSize, Duration duration) {
            Objects.requireNonNull(duration, "duration");
            return new Configuration(maximumSize, duration);
        }

        public static Configuration of(Duration duration) {
            Objects.requireNonNull(duration, "duration");
            return new Configuration(duration);
        }
    }
}

