/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.client;

import com.ibm.fhir.client.FHIRParameters;
import com.ibm.fhir.client.FHIRRequestHeader;
import com.ibm.fhir.client.FHIRResponse;
import com.ibm.fhir.model.resource.Bundle;
import com.ibm.fhir.model.resource.Resource;
import jakarta.json.JsonObject;
import java.security.KeyStore;
import javax.ws.rs.client.WebTarget;

public interface FHIRClient {
    public static final String PROPNAME_BASE_URL = "fhirclient.rest.base.url";
    public static final String PROPNAME_DEFAULT_MIMETYPE = "fhirclient.default.mimetype";
    public static final String PROPNAME_OAUTH2_ENABLED = "fhirclient.oAuth2.enabled";
    public static final String PROPNAME_OAUTH2_TOKEN = "fhirclient.oAuth2.accessToken";
    public static final String PROPNAME_BASIC_AUTH_ENABLED = "fhirclient.basicauth.enabled";
    public static final String PROPNAME_CLIENT_USERNAME = "fhirclient.basicauth.username";
    public static final String PROPNAME_CLIENT_PASSWORD = "fhirclient.basicauth.password";
    public static final String PROPNAME_CLIENT_AUTH_ENABLED = "fhirclient.clientauth.enabled";
    public static final String PROPNAME_TRUSTSTORE_LOCATION = "fhirclient.truststore.location";
    public static final String PROPNAME_TRUSTSTORE_PASSWORD = "fhirclient.truststore.password";
    public static final String PROPNAME_KEYSTORE_LOCATION = "fhirclient.keystore.location";
    public static final String PROPNAME_KEYSTORE_PASSWORD = "fhirclient.keystore.password";
    public static final String PROPNAME_KEYSTORE_KEY_PASSWORD = "fhirclient.keystore.key.password";
    public static final String PROPNAME_LOGGING_ENABLED = "fhirclient.logging.enabled";
    public static final String PROPNAME_HOSTNAME_VERIFICATION_ENABLED = "fhirclient.hostnameVerification.enabled";
    public static final String PROPNAME_HTTP_TIMEOUT = "fhirclient.http.receive.timeout";
    public static final String PROPNAME_HTTP_RETURN_PREF = "fhirclient.http.return.pref";
    public static final String PROPNAME_TENANT_ID = "fhirclient.tenant.id";

    public String getDefaultBaseUrl();

    public WebTarget getWebTarget() throws Exception;

    public WebTarget getWebTarget(String var1) throws Exception;

    public void setDefaultMimeType(String var1) throws Exception;

    public String getDefaultMimeType() throws Exception;

    public void setOAuth2AccessToken(String var1) throws Exception;

    public String getOAuth2AccessToken() throws Exception;

    public FHIRResponse metadata(FHIRRequestHeader ... var1) throws Exception;

    public FHIRResponse create(Resource var1, FHIRRequestHeader ... var2) throws Exception;

    public FHIRResponse conditionalCreate(Resource var1, FHIRParameters var2, FHIRRequestHeader ... var3) throws Exception;

    public FHIRResponse create(JsonObject var1, FHIRRequestHeader ... var2) throws Exception;

    public FHIRResponse conditionalCreate(JsonObject var1, FHIRParameters var2, FHIRRequestHeader ... var3) throws Exception;

    public FHIRResponse update(Resource var1, FHIRRequestHeader ... var2) throws Exception;

    public FHIRResponse conditionalUpdate(Resource var1, FHIRParameters var2, FHIRRequestHeader ... var3) throws Exception;

    public FHIRResponse update(JsonObject var1, FHIRRequestHeader ... var2) throws Exception;

    public FHIRResponse conditionalUpdate(JsonObject var1, FHIRParameters var2, FHIRRequestHeader ... var3) throws Exception;

    public FHIRResponse delete(String var1, String var2, FHIRRequestHeader ... var3) throws Exception;

    public FHIRResponse conditionalDelete(String var1, FHIRParameters var2, FHIRRequestHeader ... var3) throws Exception;

    public FHIRResponse read(String var1, String var2, FHIRRequestHeader ... var3) throws Exception;

    public FHIRResponse vread(String var1, String var2, String var3, FHIRRequestHeader ... var4) throws Exception;

    public FHIRResponse history(String var1, String var2, FHIRParameters var3, FHIRRequestHeader ... var4) throws Exception;

    public FHIRResponse history(FHIRParameters var1, FHIRRequestHeader ... var2) throws Exception;

    public FHIRResponse search(String var1, FHIRParameters var2, FHIRRequestHeader ... var3) throws Exception;

    public FHIRResponse _search(String var1, FHIRParameters var2, FHIRRequestHeader ... var3) throws Exception;

    public FHIRResponse searchAll(FHIRParameters var1, boolean var2, FHIRRequestHeader ... var3) throws Exception;

    public FHIRResponse validate(Resource var1, FHIRRequestHeader ... var2) throws Exception;

    public FHIRResponse validate(JsonObject var1, FHIRRequestHeader ... var2) throws Exception;

    public FHIRResponse batch(Bundle var1, FHIRRequestHeader ... var2) throws Exception;

    public FHIRResponse transaction(Bundle var1, FHIRRequestHeader ... var2) throws Exception;

    public FHIRResponse invoke(String var1, FHIRParameters var2, FHIRRequestHeader ... var3) throws Exception;

    public FHIRResponse invoke(String var1, Resource var2, FHIRRequestHeader ... var3) throws Exception;

    public FHIRResponse invoke(String var1, String var2, FHIRParameters var3, FHIRRequestHeader ... var4) throws Exception;

    public FHIRResponse invoke(String var1, String var2, Resource var3, FHIRRequestHeader ... var4) throws Exception;

    public FHIRResponse invoke(String var1, String var2, String var3, FHIRParameters var4, FHIRRequestHeader ... var5) throws Exception;

    public FHIRResponse invoke(String var1, String var2, String var3, Resource var4, FHIRRequestHeader ... var5) throws Exception;

    public FHIRResponse invoke(String var1, String var2, String var3, String var4, FHIRParameters var5, FHIRRequestHeader ... var6) throws Exception;

    public FHIRResponse invoke(String var1, String var2, String var3, String var4, Resource var5, FHIRRequestHeader ... var6) throws Exception;

    public KeyStore getTrustStore();

    public String getTenantId();
}

