/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.client;

import com.ibm.fhir.model.type.code.ResourceType;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

public class FHIRParameters {
    public static final String COUNT = "_count";
    public static final String FORMAT = "_format";
    public static final String PAGE = "_page";
    public static final String SINCE = "_since";
    private MultivaluedMap<String, String> parameters = new MultivaluedHashMap();

    public FHIRParameters format(String mimeType) {
        return this.queryParam(FORMAT, mimeType);
    }

    public FHIRParameters count(int count) {
        return this.queryParam(COUNT, Integer.toString(count));
    }

    public FHIRParameters page(int page) {
        return this.queryParam(PAGE, Integer.toString(page));
    }

    public FHIRParameters since(String since) {
        return this.queryParam(SINCE, since);
    }

    public FHIRParameters clear() {
        this.parameters.clear();
        return this;
    }

    public FHIRParameters queryParam(String name, String value) {
        this.addSinglevaluedParameter(name, value);
        return this;
    }

    public FHIRParameters searchParam(String name, Modifier modifier, String ... values) {
        String parameterName = name + ":" + modifier.text();
        String value = this.getValueString(values);
        this.addMultivaluedParameter(parameterName, value);
        return this;
    }

    public FHIRParameters searchParam(String name, ResourceType resourceType, String ... values) {
        String parameterName = name + ":" + resourceType.getValue();
        String value = this.getValueString(values);
        this.addMultivaluedParameter(parameterName, value);
        return this;
    }

    public FHIRParameters searchParam(String name, ValuePrefix prefix, String ... values) {
        String value = prefix.text() + this.getValueString(values);
        this.addMultivaluedParameter(name, value);
        return this;
    }

    private String getValueString(String[] values) {
        StringBuilder sb = new StringBuilder();
        boolean needComma = false;
        for (int i = 0; i < values.length; ++i) {
            if (needComma) {
                sb.append(",");
            }
            sb.append(values[i]);
            needComma = true;
        }
        return sb.toString();
    }

    public FHIRParameters searchParam(String name, String ... values) {
        for (int i = 0; i < values.length; ++i) {
            this.addMultivaluedParameter(name, values[i]);
        }
        return this;
    }

    public final MultivaluedMap<String, String> getParameterMap() {
        return this.parameters;
    }

    private synchronized MultivaluedMap<String, String> getParameters() {
        if (this.parameters == null) {
            this.parameters = new MultivaluedHashMap();
        }
        return this.parameters;
    }

    public void addMultivaluedParameter(String name, String value) {
        this.getParameters().add((Object)name, (Object)value);
    }

    public void addSinglevaluedParameter(String name, String value) {
        this.getParameters().putSingle((Object)name, (Object)value);
    }

    public String queryString(boolean includeSeparator) {
        StringBuilder sb = new StringBuilder();
        if (this.getParameters() != null) {
            boolean needSeparator = includeSeparator;
            for (Map.Entry mapEntry : this.getParameters().entrySet()) {
                for (String value : (List)mapEntry.getValue()) {
                    if (needSeparator) {
                        sb.append("&");
                    }
                    sb.append((String)mapEntry.getKey());
                    sb.append("=");
                    sb.append(value);
                    needSeparator = true;
                }
            }
        }
        return sb.toString();
    }

    public String queryString() {
        return this.queryString(true);
    }

    public String toString() {
        return "FHIRParameters[parameters=" + (this.getParameters() != null ? this.getParameters().toString() : "<null>]");
    }

    public static enum ValuePrefix {
        EQ("eq"),
        NE("ne"),
        GT("gt"),
        LT("lt"),
        GE("ge"),
        LE("le"),
        SA("sa"),
        EB("eb"),
        AP("ap");

        private String text;

        private ValuePrefix(String p) {
            this.text = p;
        }

        public String text() {
            return this.text;
        }
    }

    public static enum Modifier {
        MISSING("missing"),
        EXACT("exact"),
        CONTAINS("contains"),
        TEXT("text"),
        IN("in"),
        BELOW("below"),
        ABOVE("above"),
        NOT("not"),
        NOT_IN("not-in"),
        IDENTIFIER("identifier"),
        OF_TYPE("of-type"),
        ITERATE("iterate");

        private String text;

        private Modifier(String m) {
            this.text = m;
        }

        public String text() {
            return this.text;
        }
    }
}

