/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.client.impl;

import java.io.IOException;
import java.util.Base64;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MultivaluedMap;

public class FHIRBasicAuthenticator
implements ClientRequestFilter {
    private String username;
    private String password;

    protected FHIRBasicAuthenticator() {
    }

    public FHIRBasicAuthenticator(String user, String password) {
        this.setUsername(user);
        this.setPassword(password);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void filter(ClientRequestContext ctxt) throws IOException {
        if (this.getUsername() != null && !this.getUsername().isEmpty()) {
            MultivaluedMap headers = ctxt.getHeaders();
            String basicAuthToken = this.getUsername() + ":" + this.getPassword();
            String basicAuthString = "Basic " + Base64.getEncoder().encodeToString(basicAuthToken.getBytes());
            headers.add((Object)"Authorization", (Object)basicAuthString);
        }
    }
}

