/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.client.impl;

import com.ibm.fhir.client.FHIRClient;
import com.ibm.fhir.client.FHIRParameters;
import com.ibm.fhir.client.FHIRRequestHeader;
import com.ibm.fhir.client.FHIRResponse;
import com.ibm.fhir.client.impl.FHIRBasicAuthenticator;
import com.ibm.fhir.client.impl.FHIROAuth2Authenticator;
import com.ibm.fhir.client.impl.FHIRResponseImpl;
import com.ibm.fhir.core.FHIRUtilities;
import com.ibm.fhir.core.HTTPReturnPreference;
import com.ibm.fhir.model.resource.Bundle;
import com.ibm.fhir.model.resource.Parameters;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.code.BundleType;
import com.ibm.fhir.provider.FHIRJsonPatchProvider;
import com.ibm.fhir.provider.FHIRJsonProvider;
import com.ibm.fhir.provider.FHIRProvider;
import jakarta.json.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.ext.logging.event.LogMessageFormatter;

public class FHIRClientImpl
implements FHIRClient {
    private static final String KEYSTORE_TYPE = "pkcs12";
    private Client client = null;
    private Properties clientProperties = null;
    private String baseEndpointURL = null;
    private String defaultMimeType = "application/fhir+json";
    private boolean basicAuthEnabled = false;
    private String basicAuthUsername = null;
    private String basicAuthPassword = null;
    private boolean clientAuthEnabled = false;
    private String trustStoreLocation = null;
    private String trustStorePassword = null;
    private String keyStoreLocation = null;
    private String keyStorePassword = null;
    private String keyStoreKeyPassword = null;
    private boolean oAuth2Enabled = false;
    private String accessToken = null;
    private KeyStore trustStore = null;
    private KeyStore keyStore = null;
    private boolean loggingEnabled = false;
    private boolean hostnameVerificationEnabled = true;
    private HTTPReturnPreference httpReturnPref = HTTPReturnPreference.MINIMAL;
    private int httpTimeout;
    private String tenantId;

    public FHIRClientImpl(Properties props) throws Exception {
        KeyStore ks;
        this.initProperties(props);
        ClientBuilder cb = (ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register((Object)new FHIRProvider(RuntimeType.CLIENT))).register((Object)new FHIRJsonProvider(RuntimeType.CLIENT))).register((Object)new FHIRJsonPatchProvider(RuntimeType.CLIENT));
        if (this.isBasicAuthEnabled()) {
            cb = (ClientBuilder)cb.register((Object)new FHIRBasicAuthenticator(this.getBasicAuthUsername(), this.getBasicAuthPassword()));
        }
        if (this.isOAuth2Enabled()) {
            cb = (ClientBuilder)cb.register((Object)new FHIROAuth2Authenticator(this.getOAuth2AccessToken()));
        }
        if (this.isOAuth2Enabled() || this.isClientAuthEnabled()) {
            cb = cb.keyStore(this.getKeyStore(), this.getKeyStoreKeyPassword());
        }
        if ((ks = this.getTrustStore()) != null) {
            cb = cb.trustStore(ks);
        }
        if (this.usingSSLTransport() && !this.isHostnameVerificationEnabled()) {
            cb = cb.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            });
        }
        cb.property("http.receive.timeout", (Object)this.getHttpTimeout());
        cb.property("use.async.http.conduit", (Object)false);
        if (this.isLoggingEnabled()) {
            cb.property("org.apache.cxf.logging.enable", (Object)"true");
            LoggingFeature feat = new LoggingFeature();
            feat.setPrettyLogging(true);
            feat.setVerbose(true);
            feat.setSender((LogEventSender)new LF());
            cb.register((Object)feat);
        }
        cb.property("thread.safe.client", (Object)true);
        this.client = cb.build();
    }

    @Override
    public FHIRResponse metadata(FHIRRequestHeader ... headers) throws Exception {
        WebTarget endpoint = this.getWebTarget();
        Invocation.Builder builder = endpoint.path("metadata").request(new String[]{this.getDefaultMimeType()});
        builder = this.addRequestHeaders(builder, headers);
        Response response = builder.get();
        return new FHIRResponseImpl(response);
    }

    @Override
    public FHIRResponse create(Resource resource, FHIRRequestHeader ... headers) throws Exception {
        if (resource == null) {
            throw new IllegalArgumentException("The 'resource' argument is required but was null.");
        }
        String resourceType = resource.getClass().getSimpleName();
        return this._create(resource, resourceType, null, headers);
    }

    @Override
    public FHIRResponse create(JsonObject resource, FHIRRequestHeader ... headers) throws Exception {
        if (resource == null) {
            throw new IllegalArgumentException("The 'resource' argument is required but was null.");
        }
        String resourceType = resource.getString("resourceType");
        if (resourceType == null || resourceType.isEmpty()) {
            throw new IllegalArgumentException("Unable to retrieve the resource type from the resource.");
        }
        return this._create(resource, resourceType, null, headers);
    }

    @Override
    public FHIRResponse conditionalCreate(Resource resource, FHIRParameters parameters, FHIRRequestHeader ... headers) throws Exception {
        if (resource == null) {
            throw new IllegalArgumentException("The 'resource' argument is required but was null.");
        }
        String resourceType = resource.getClass().getSimpleName();
        if (parameters == null || parameters.getParameterMap() == null || parameters.getParameterMap().isEmpty()) {
            throw new IllegalArgumentException("The 'parameters' argument must be non-null and must contain at least one search query parameter");
        }
        return this._create(resource, resourceType, parameters, headers);
    }

    @Override
    public FHIRResponse conditionalCreate(JsonObject resource, FHIRParameters parameters, FHIRRequestHeader ... headers) throws Exception {
        if (resource == null) {
            throw new IllegalArgumentException("The 'resource' argument is required but was null.");
        }
        String resourceType = resource.getString("resourceType");
        if (resourceType == null || resourceType.isEmpty()) {
            throw new IllegalArgumentException("Unable to retrieve the resource type from the resource.");
        }
        if (parameters == null || parameters.getParameterMap() == null || parameters.getParameterMap().isEmpty()) {
            throw new IllegalArgumentException("The 'parameters' argument must be non-null and must contain at least one search query parameter");
        }
        return this._create(resource, resourceType, parameters, headers);
    }

    private <T> FHIRResponse _create(T resource, String resourceType, FHIRParameters parameters, FHIRRequestHeader ... headers) throws Exception {
        WebTarget endpoint = this.getWebTarget();
        Entity entity = Entity.entity(resource, (String)this.getDefaultMimeType());
        Invocation.Builder builder = endpoint.path(resourceType).request(new String[]{this.getDefaultMimeType()});
        headers = this.addIfNoneExistHeader(headers, parameters);
        headers = this.addHttpPreferHeader(headers, this.getHttpReturnPref());
        builder = this.addRequestHeaders(builder, headers);
        Response response = builder.post(entity);
        return new FHIRResponseImpl(response);
    }

    private FHIRRequestHeader[] addIfNoneExistHeader(FHIRRequestHeader[] headers, FHIRParameters ifNoneExistQuery) {
        if (ifNoneExistQuery == null) {
            return headers;
        }
        FHIRRequestHeader ifNoneExistHeader = new FHIRRequestHeader("If-None-Exist", ifNoneExistQuery.queryString(false));
        int headersSize = headers != null ? headers.length : 0;
        FHIRRequestHeader[] result = new FHIRRequestHeader[headersSize + 1];
        if (headers != null) {
            for (int i = 0; i < headers.length; ++i) {
                result[i] = headers[i];
            }
        }
        result[result.length - 1] = ifNoneExistHeader;
        return result;
    }

    private FHIRRequestHeader[] addHttpPreferHeader(FHIRRequestHeader[] headers, HTTPReturnPreference returnPref) {
        if (headers != null) {
            for (FHIRRequestHeader fhirRequestHeader : headers) {
                if (!"Prefer".equals(fhirRequestHeader.getName())) continue;
                return headers;
            }
        }
        FHIRRequestHeader preferHeader = new FHIRRequestHeader("Prefer", "return=" + returnPref.value());
        int headersSize = headers != null ? headers.length : 0;
        FHIRRequestHeader[] result = new FHIRRequestHeader[headersSize + 1];
        if (headers != null) {
            for (int i = 0; i < headers.length; ++i) {
                result[i] = headers[i];
            }
        }
        result[result.length - 1] = preferHeader;
        return result;
    }

    @Override
    public FHIRResponse update(Resource resource, FHIRRequestHeader ... headers) throws Exception {
        String resourceId;
        if (resource == null) {
            throw new IllegalArgumentException("The 'resource' argument is required but was null.");
        }
        String resourceType = resource.getClass().getSimpleName();
        String string = resourceId = resource.getId() != null ? resource.getId() : null;
        if (resourceId == null || resourceId.isEmpty()) {
            throw new IllegalArgumentException("Unable to retrieve the resource id from the resource.");
        }
        return this._update(resource, resourceType, resourceId, null, headers);
    }

    @Override
    public FHIRResponse update(JsonObject resource, FHIRRequestHeader ... headers) throws Exception {
        if (resource == null) {
            throw new IllegalArgumentException("The 'resource' argument is required but was null.");
        }
        String resourceType = resource.getString("resourceType");
        if (resourceType == null || resourceType.isEmpty()) {
            throw new IllegalArgumentException("Unable to retrieve the resource type from the resource.");
        }
        String resourceId = resource.getString("id");
        if (resourceId == null || resourceId.isEmpty()) {
            throw new IllegalArgumentException("Unable to retrieve the resource id from the resource.");
        }
        return this._update(resource, resourceType, resourceId, null, headers);
    }

    @Override
    public FHIRResponse conditionalUpdate(Resource resource, FHIRParameters parameters, FHIRRequestHeader ... headers) throws Exception {
        if (resource == null) {
            throw new IllegalArgumentException("The 'resource' argument is required but was null.");
        }
        String resourceType = resource.getClass().getSimpleName();
        if (parameters == null || parameters.getParameterMap() == null || parameters.getParameterMap().isEmpty()) {
            throw new IllegalArgumentException("The 'parameters' argument must be non-null and must contain at least one search query parameter");
        }
        return this._update(resource, resourceType, null, parameters, headers);
    }

    @Override
    public FHIRResponse conditionalUpdate(JsonObject resource, FHIRParameters parameters, FHIRRequestHeader ... headers) throws Exception {
        if (resource == null) {
            throw new IllegalArgumentException("The 'resource' argument is required but was null.");
        }
        String resourceType = resource.getString("resourceType");
        if (resourceType == null || resourceType.isEmpty()) {
            throw new IllegalArgumentException("Unable to retrieve the resource type from the resource.");
        }
        if (parameters == null || parameters.getParameterMap() == null || parameters.getParameterMap().isEmpty()) {
            throw new IllegalArgumentException("The 'parameters' argument must be non-null and must contain at least one search query parameter");
        }
        return this._update(resource, resourceType, null, parameters, headers);
    }

    private <T> FHIRResponse _update(T resource, String resourceType, String resourceId, FHIRParameters parameters, FHIRRequestHeader ... headers) throws Exception {
        WebTarget endpoint = this.getWebTarget();
        Entity entity = Entity.entity(resource, (String)this.getDefaultMimeType());
        endpoint = endpoint.path(resourceType);
        endpoint = resourceId != null ? endpoint.path(resourceId) : this.addParametersToWebTarget(endpoint, parameters);
        Invocation.Builder builder = endpoint.request(new String[]{this.getDefaultMimeType()});
        builder = this.addRequestHeaders(builder, headers);
        Response response = builder.put(entity);
        return new FHIRResponseImpl(response);
    }

    @Override
    public FHIRResponse delete(String resourceType, String resourceId, FHIRRequestHeader ... headers) throws Exception {
        if (resourceType == null) {
            throw new IllegalArgumentException("The 'resourceType' argument is required but was null.");
        }
        if (resourceId == null) {
            throw new IllegalArgumentException("The 'resourceId' argument is required but was null.");
        }
        return this._delete(resourceType, resourceId, null, headers);
    }

    @Override
    public FHIRResponse conditionalDelete(String resourceType, FHIRParameters parameters, FHIRRequestHeader ... headers) throws Exception {
        if (resourceType == null) {
            throw new IllegalArgumentException("The 'resourceType' argument is required but was null.");
        }
        if (parameters == null || parameters.getParameterMap() == null || parameters.getParameterMap().isEmpty()) {
            throw new IllegalArgumentException("The 'parameters' argument must be non-null and must contain at least one search query parameter");
        }
        return this._delete(resourceType, null, parameters, headers);
    }

    private FHIRResponse _delete(String resourceType, String resourceId, FHIRParameters parameters, FHIRRequestHeader ... headers) throws Exception {
        WebTarget endpoint = this.getWebTarget();
        endpoint = endpoint.path(resourceType);
        endpoint = resourceId != null ? endpoint.path(resourceId) : this.addParametersToWebTarget(endpoint, parameters);
        Invocation.Builder builder = endpoint.request(new String[]{this.getDefaultMimeType()});
        builder = this.addRequestHeaders(builder, headers);
        Response response = builder.delete();
        return new FHIRResponseImpl(response);
    }

    @Override
    public FHIRResponse read(String resourceType, String resourceId, FHIRRequestHeader ... headers) throws Exception {
        if (resourceType == null) {
            throw new IllegalArgumentException("The 'resourceType' argument is required but was null.");
        }
        if (resourceId == null) {
            throw new IllegalArgumentException("The 'resourceId' argument is required but was null.");
        }
        WebTarget endpoint = this.getWebTarget();
        Invocation.Builder builder = endpoint.path(resourceType).path(resourceId).request(new String[]{this.getDefaultMimeType()});
        builder = this.addRequestHeaders(builder, headers);
        Response response = builder.get();
        return new FHIRResponseImpl(response);
    }

    @Override
    public FHIRResponse vread(String resourceType, String resourceId, String versionId, FHIRRequestHeader ... headers) throws Exception {
        if (resourceType == null) {
            throw new IllegalArgumentException("The 'resourceType' argument is required but was null.");
        }
        if (resourceId == null) {
            throw new IllegalArgumentException("The 'resourceId' argument is required but was null.");
        }
        if (versionId == null) {
            throw new IllegalArgumentException("The 'versionId' argument is required but was null.");
        }
        WebTarget endpoint = this.getWebTarget();
        Invocation.Builder builder = endpoint.path(resourceType).path(resourceId).path("_history").path(versionId).request(new String[]{this.getDefaultMimeType()});
        builder = this.addRequestHeaders(builder, headers);
        Response response = builder.get();
        return new FHIRResponseImpl(response);
    }

    @Override
    public FHIRResponse history(String resourceType, String resourceId, FHIRParameters parameters, FHIRRequestHeader ... headers) throws Exception {
        if (resourceType == null) {
            throw new IllegalArgumentException("The 'resourceType' argument is required but was null.");
        }
        if (resourceId == null) {
            throw new IllegalArgumentException("The 'resourceId' argument is required but was null.");
        }
        WebTarget endpoint = this.getWebTarget();
        endpoint = endpoint.path(resourceType).path(resourceId).path("_history");
        endpoint = this.addParametersToWebTarget(endpoint, parameters);
        Invocation.Builder builder = endpoint.request(new String[]{this.getDefaultMimeType()});
        builder = this.addRequestHeaders(builder, headers);
        Response response = builder.get();
        return new FHIRResponseImpl(response);
    }

    @Override
    public FHIRResponse history(FHIRParameters parameters, FHIRRequestHeader ... headers) throws Exception {
        WebTarget endpoint = this.getWebTarget();
        endpoint = endpoint.path("_history");
        endpoint = this.addParametersToWebTarget(endpoint, parameters);
        Invocation.Builder builder = endpoint.request(new String[]{this.getDefaultMimeType()});
        builder = this.addRequestHeaders(builder, headers);
        Response response = builder.get();
        return new FHIRResponseImpl(response);
    }

    @Override
    public FHIRResponse search(String resourceType, FHIRParameters parameters, FHIRRequestHeader ... headers) throws Exception {
        if (resourceType == null) {
            throw new IllegalArgumentException("The 'resourceType' argument is required but was null.");
        }
        WebTarget endpoint = this.getWebTarget();
        endpoint = endpoint.path(resourceType);
        endpoint = this.addParametersToWebTarget(endpoint, parameters);
        Invocation.Builder builder = endpoint.request(new String[]{this.getDefaultMimeType()});
        builder = this.addRequestHeaders(builder, headers);
        Response response = builder.get();
        return new FHIRResponseImpl(response);
    }

    @Override
    public FHIRResponse _search(String resourceType, FHIRParameters parameters, FHIRRequestHeader ... headers) throws Exception {
        if (resourceType == null) {
            throw new IllegalArgumentException("The 'resourceType' argument is required but was null.");
        }
        WebTarget endpoint = this.getWebTarget();
        endpoint = endpoint.path(resourceType).path("_search");
        Form form = this.buildForm(parameters);
        Entity entity = Entity.form((Form)form);
        Invocation.Builder builder = endpoint.request(new String[]{this.getDefaultMimeType()});
        builder = this.addRequestHeaders(builder, headers);
        Response response = builder.post(entity);
        return new FHIRResponseImpl(response);
    }

    @Override
    public FHIRResponse searchAll(FHIRParameters parameters, boolean isPost, FHIRRequestHeader ... headers) throws Exception {
        Response response;
        WebTarget endpoint = this.getWebTarget();
        if (isPost) {
            endpoint = endpoint.path("/");
            endpoint = this.addParametersToWebTarget(endpoint, parameters);
            Invocation.Builder builder = endpoint.request(new String[]{this.getDefaultMimeType()});
            builder = this.addRequestHeaders(builder, headers);
            response = builder.get();
        } else {
            endpoint = endpoint.path("_search");
            Invocation.Builder builder = endpoint.request(new String[]{this.getDefaultMimeType()});
            builder = this.addRequestHeaders(builder, headers);
            Entity entity = Entity.form(parameters.getParameterMap());
            response = builder.post(entity);
        }
        return new FHIRResponseImpl(response);
    }

    @Override
    public FHIRResponse validate(Resource resource, FHIRRequestHeader ... headers) throws Exception {
        if (resource == null) {
            throw new IllegalArgumentException("The 'resource' argument is required but was null.");
        }
        String resourceType = resource.getClass().getSimpleName();
        return this._validate(resource, resourceType, headers);
    }

    @Override
    public FHIRResponse validate(JsonObject resource, FHIRRequestHeader ... headers) throws Exception {
        if (resource == null) {
            throw new IllegalArgumentException("The 'resource' argument is required but was null.");
        }
        String resourceType = resource.getString("resourceType");
        return this._validate(resource, resourceType, headers);
    }

    private <T> FHIRResponse _validate(T resource, String resourceType, FHIRRequestHeader ... headers) throws Exception {
        WebTarget endpoint = this.getWebTarget();
        Entity entity = Entity.entity(resource, (String)this.getDefaultMimeType());
        Invocation.Builder builder = endpoint.path(resourceType).path("$validate").request(new String[]{this.getDefaultMimeType()});
        builder = this.addRequestHeaders(builder, headers);
        Response response = builder.post(entity);
        return new FHIRResponseImpl(response);
    }

    @Override
    public FHIRResponse batch(Bundle bundle, FHIRRequestHeader ... headers) throws Exception {
        if (bundle == null) {
            throw new IllegalArgumentException("The 'bundle' argument is required but was null.");
        }
        return this._bundle(bundle, BundleType.BATCH, headers);
    }

    @Override
    public FHIRResponse transaction(Bundle bundle, FHIRRequestHeader ... headers) throws Exception {
        if (bundle == null) {
            throw new IllegalArgumentException("The 'bundle' argument is required but was null.");
        }
        return this._bundle(bundle, BundleType.TRANSACTION, headers);
    }

    @Override
    public FHIRResponse invoke(String operationName, FHIRParameters parameters, FHIRRequestHeader ... headers) throws Exception {
        if (operationName == null) {
            throw new IllegalArgumentException("The 'operationName' argument is required but was null.");
        }
        WebTarget endpoint = this.getWebTarget();
        endpoint = endpoint.path(operationName);
        endpoint = this.addParametersToWebTarget(endpoint, parameters);
        Invocation.Builder builder = endpoint.request(new String[]{this.getDefaultMimeType()});
        builder = this.addRequestHeaders(builder, headers);
        Response response = builder.get();
        return new FHIRResponseImpl(response);
    }

    @Override
    public FHIRResponse invoke(String operationName, Resource resource, FHIRRequestHeader ... headers) throws Exception {
        if (operationName == null) {
            throw new IllegalArgumentException("The 'operationName' argument is required but was null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("The 'resource' argument is required but was null.");
        }
        WebTarget endpoint = this.getWebTarget();
        Entity entity = Entity.entity((Object)((Parameters)resource), (String)this.getDefaultMimeType());
        Invocation.Builder builder = endpoint.path(operationName).request();
        builder = this.addRequestHeaders(builder, headers);
        Response response = builder.post(entity);
        return new FHIRResponseImpl(response);
    }

    @Override
    public FHIRResponse invoke(String resourceType, String operationName, FHIRParameters parameters, FHIRRequestHeader ... headers) throws Exception {
        if (resourceType == null) {
            throw new IllegalArgumentException("The 'resourceType' argument is required but was null.");
        }
        if (operationName == null) {
            throw new IllegalArgumentException("The 'operationName' argument is required but was null.");
        }
        WebTarget endpoint = this.getWebTarget();
        endpoint = endpoint.path(resourceType).path(operationName);
        endpoint = this.addParametersToWebTarget(endpoint, parameters);
        Invocation.Builder builder = endpoint.request(new String[]{this.getDefaultMimeType()});
        builder = this.addRequestHeaders(builder, headers);
        Response response = builder.get();
        return new FHIRResponseImpl(response);
    }

    @Override
    public FHIRResponse invoke(String resourceType, String operationName, Resource resource, FHIRRequestHeader ... headers) throws Exception {
        if (resourceType == null) {
            throw new IllegalArgumentException("The 'resourceType' argument is required but was null.");
        }
        if (operationName == null) {
            throw new IllegalArgumentException("The 'operationName' argument is required but was null.");
        }
        WebTarget endpoint = this.getWebTarget();
        Entity entity = Entity.entity((Object)((Parameters)resource), (String)this.getDefaultMimeType());
        Invocation.Builder builder = endpoint.path(resourceType).path(operationName).request();
        builder = this.addRequestHeaders(builder, headers);
        Response response = builder.post(entity);
        return new FHIRResponseImpl(response);
    }

    @Override
    public FHIRResponse invoke(String resourceType, String operationName, String resourceId, FHIRParameters parameters, FHIRRequestHeader ... headers) throws Exception {
        if (resourceType == null) {
            throw new IllegalArgumentException("The 'resourceType' argument is required but was null.");
        }
        if (operationName == null) {
            throw new IllegalArgumentException("The 'operationName' argument is required but was null.");
        }
        if (resourceId == null) {
            throw new IllegalArgumentException("The 'resourceId' argument is required but was null.");
        }
        WebTarget endpoint = this.getWebTarget();
        endpoint = endpoint.path(resourceType).path(resourceId).path(operationName);
        endpoint = this.addParametersToWebTarget(endpoint, parameters);
        Invocation.Builder builder = endpoint.request(new String[]{this.getDefaultMimeType()});
        builder = this.addRequestHeaders(builder, headers);
        Response response = builder.get();
        return new FHIRResponseImpl(response);
    }

    @Override
    public FHIRResponse invoke(String resourceType, String operationName, String resourceId, Resource resource, FHIRRequestHeader ... headers) throws Exception {
        if (resourceType == null) {
            throw new IllegalArgumentException("The 'resourceType' argument is required but was null.");
        }
        if (operationName == null) {
            throw new IllegalArgumentException("The 'operationName' argument is required but was null.");
        }
        if (resourceId == null) {
            throw new IllegalArgumentException("The 'resourceId' argument is required but was null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("The 'resource' argument is required but was null.");
        }
        WebTarget endpoint = this.getWebTarget();
        Entity entity = Entity.entity((Object)((Parameters)resource), (String)this.getDefaultMimeType());
        Invocation.Builder builder = endpoint.path(resourceType).path(resourceId).path(operationName).request();
        builder = this.addRequestHeaders(builder, headers);
        Response response = builder.post(entity);
        return new FHIRResponseImpl(response);
    }

    @Override
    public FHIRResponse invoke(String resourceType, String operationName, String resourceId, String versionId, FHIRParameters parameters, FHIRRequestHeader ... headers) throws Exception {
        if (resourceType == null) {
            throw new IllegalArgumentException("The 'resourceType' argument is required but was null.");
        }
        if (operationName == null) {
            throw new IllegalArgumentException("The 'operationName' argument is required but was null.");
        }
        if (resourceId == null) {
            throw new IllegalArgumentException("The 'resourceId' argument is required but was null.");
        }
        if (versionId == null) {
            throw new IllegalArgumentException("The 'versionId' argument is required but was null.");
        }
        WebTarget endpoint = this.getWebTarget();
        endpoint = endpoint.path(resourceType).path(resourceId).path("_history").path(versionId).path(operationName);
        endpoint = this.addParametersToWebTarget(endpoint, parameters);
        Invocation.Builder builder = endpoint.request(new String[]{this.getDefaultMimeType()});
        builder = this.addRequestHeaders(builder, headers);
        Response response = builder.get();
        return new FHIRResponseImpl(response);
    }

    @Override
    public FHIRResponse invoke(String resourceType, String operationName, String resourceId, String versionId, Resource resource, FHIRRequestHeader ... headers) throws Exception {
        if (resourceType == null) {
            throw new IllegalArgumentException("The 'resourceType' argument is required but was null.");
        }
        if (operationName == null) {
            throw new IllegalArgumentException("The 'operationName' argument is required but was null.");
        }
        if (resourceId == null) {
            throw new IllegalArgumentException("The 'resourceId' argument is required but was null.");
        }
        if (versionId == null) {
            throw new IllegalArgumentException("The 'versionId' argument is required but was null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("The 'resource' argument is required but was null.");
        }
        WebTarget endpoint = this.getWebTarget();
        Entity entity = Entity.entity((Object)((Parameters)resource), (String)this.getDefaultMimeType());
        Invocation.Builder builder = endpoint.path(resourceType).path(resourceId).path("_history").path(versionId).path(operationName).request();
        builder = this.addRequestHeaders(builder, headers);
        Response response = builder.post(entity);
        return new FHIRResponseImpl(response);
    }

    private FHIRResponse _bundle(Bundle bundle, BundleType bundleType, FHIRRequestHeader ... headers) throws Exception {
        Bundle bundleNew = bundle.toBuilder().type(bundleType).build();
        WebTarget endpoint = this.getWebTarget();
        Entity entity = Entity.entity((Object)bundleNew, (String)this.getDefaultMimeType());
        Invocation.Builder builder = endpoint.request(new String[]{this.getDefaultMimeType()});
        builder = this.addRequestHeaders(builder, headers);
        Response response = builder.post(entity);
        return new FHIRResponseImpl(response);
    }

    private WebTarget addParametersToWebTarget(WebTarget endpoint, FHIRParameters parameters) {
        MultivaluedMap<String, String> parameterMap;
        if (parameters != null && (parameterMap = parameters.getParameterMap()) != null && !parameterMap.isEmpty()) {
            for (Map.Entry mapEntry : parameterMap.entrySet()) {
                for (String value : (List)mapEntry.getValue()) {
                    endpoint = endpoint.queryParam((String)mapEntry.getKey(), new Object[]{value});
                }
            }
        }
        return endpoint;
    }

    private Form buildForm(FHIRParameters parameters) {
        MultivaluedMap<String, String> parameterMap;
        Form form = new Form();
        if (parameters != null && (parameterMap = parameters.getParameterMap()) != null && !parameterMap.isEmpty()) {
            for (Map.Entry mapEntry : parameterMap.entrySet()) {
                for (String value : (List)mapEntry.getValue()) {
                    form.param((String)mapEntry.getKey(), value);
                }
            }
        }
        return form;
    }

    private Invocation.Builder addRequestHeaders(Invocation.Builder builder, FHIRRequestHeader[] headers) {
        if (headers != null) {
            for (FHIRRequestHeader header : headers) {
                if (header.getName() == null || header.getValue() == null) continue;
                builder = builder.header(header.getName(), header.getValue());
            }
        }
        if (this.tenantId != null) {
            builder = builder.header("X-FHIR-TENANT-ID", (Object)this.tenantId);
        }
        return builder;
    }

    @Override
    public String getDefaultBaseUrl() {
        return this.baseEndpointURL;
    }

    @Override
    public WebTarget getWebTarget() throws Exception {
        return this.client.target(this.getBaseEndpointURL());
    }

    @Override
    public WebTarget getWebTarget(String baseURL) throws Exception {
        return this.client.target(baseURL);
    }

    private void initProperties(Properties props) throws Exception {
        try {
            this.setClientProperties(props);
            Object s = this.getRequiredProperty("fhirclient.rest.base.url");
            if (!((String)s).endsWith("/")) {
                s = (String)s + "/";
            }
            this.setBaseEndpointURL((String)s);
            s = this.getProperty("fhirclient.default.mimetype", null);
            if (s != null && !((String)s).isEmpty()) {
                this.setDefaultMimeType((String)s);
            }
            this.setBasicAuthEnabled(Boolean.parseBoolean(this.getProperty("fhirclient.basicauth.enabled", "false")));
            if (this.isBasicAuthEnabled()) {
                this.setBasicAuthUsername(this.getRequiredProperty("fhirclient.basicauth.username"));
                this.setBasicAuthPassword(FHIRUtilities.decode((String)this.getRequiredProperty("fhirclient.basicauth.password")));
            }
            this.setOAuth2Enabled(Boolean.parseBoolean(this.getProperty("fhirclient.oAuth2.enabled", "false")));
            if (this.isOAuth2Enabled()) {
                this.setOAuth2AccessToken(FHIRUtilities.decode((String)this.getRequiredProperty("fhirclient.oAuth2.accessToken")));
            }
            this.setClientAuthEnabled(Boolean.parseBoolean(this.getProperty("fhirclient.clientauth.enabled", "false")));
            if (this.isOAuth2Enabled() || this.isClientAuthEnabled() || this.usingSSLTransport()) {
                String trustStoreLoc = this.getProperty("fhirclient.truststore.location", null);
                String trustStoreEncodedPwd = this.getProperty("fhirclient.truststore.password", null);
                if (trustStoreLoc != null && trustStoreEncodedPwd != null) {
                    this.setTrustStoreLocation(trustStoreLoc);
                    this.setTrustStorePassword(FHIRUtilities.decode((String)trustStoreEncodedPwd));
                    this.setTrustStore(this.loadKeyStoreFile(this.getTrustStoreLocation(), this.getTrustStorePassword(), KEYSTORE_TYPE));
                }
            }
            if (this.isOAuth2Enabled() || this.isClientAuthEnabled()) {
                this.setKeyStoreLocation(this.getRequiredProperty("fhirclient.keystore.location"));
                this.setKeyStorePassword(FHIRUtilities.decode((String)this.getRequiredProperty("fhirclient.keystore.password")));
                this.setKeyStoreKeyPassword(FHIRUtilities.decode((String)this.getRequiredProperty("fhirclient.keystore.key.password")));
                this.setKeyStore(this.loadKeyStoreFile(this.getKeyStoreLocation(), this.getKeyStorePassword(), KEYSTORE_TYPE));
            }
            this.setLoggingEnabled(Boolean.parseBoolean(this.getProperty("fhirclient.logging.enabled", "false")));
            this.setHostnameVerificationEnabled(Boolean.parseBoolean(this.getProperty("fhirclient.hostnameVerification.enabled", "true")));
            this.setHttpTimeout(Integer.parseUnsignedInt(this.getProperty("fhirclient.http.receive.timeout", "130000")));
            this.setTenantId(this.getProperty("fhirclient.tenant.id", null));
        }
        catch (Throwable t) {
            throw new Exception("Unexpected error while processing client properties.", t);
        }
    }

    private boolean usingSSLTransport() {
        return this.getBaseEndpointURL().startsWith("https:");
    }

    private KeyStore loadKeyStoreFile(String ksFilename, String ksPassword, String ksType) {
        InputStream is = null;
        try {
            File tsFile;
            KeyStore ks = KeyStore.getInstance(ksType);
            URL tsURL = Thread.currentThread().getContextClassLoader().getResource(ksFilename);
            if (tsURL != null) {
                is = tsURL.openStream();
            }
            if (is == null && (tsFile = new File(ksFilename)).exists()) {
                is = new FileInputStream(tsFile);
            }
            if (is == null) {
                throw new FileNotFoundException("KeyStore file '" + ksFilename + "' was not found.");
            }
            ks.load(is, ksPassword.toCharArray());
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalStateException("Error loading keystore file '" + ksFilename + "' : " + e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    private String getProperty(String propertyName, String defaultValue) {
        return this.clientProperties.getProperty(propertyName, defaultValue);
    }

    private String getRequiredProperty(String propertyName) throws Exception {
        String s = this.getProperty(propertyName, null);
        if (s == null) {
            throw new IllegalStateException("Required property '" + propertyName + "' not found in client properties object.");
        }
        return s;
    }

    private void setClientProperties(Properties clientProperties) {
        this.clientProperties = clientProperties;
    }

    public String getBaseEndpointURL() {
        return this.baseEndpointURL;
    }

    private void setBaseEndpointURL(String baseEndpointURL) {
        this.baseEndpointURL = baseEndpointURL;
    }

    @Override
    public void setDefaultMimeType(String mimeType) throws Exception {
        this.defaultMimeType = mimeType;
    }

    @Override
    public String getDefaultMimeType() throws Exception {
        return this.defaultMimeType;
    }

    @Override
    public void setOAuth2AccessToken(String accessToken) throws Exception {
        this.accessToken = accessToken;
    }

    @Override
    public String getOAuth2AccessToken() throws Exception {
        return this.accessToken;
    }

    private String getTrustStoreLocation() {
        return this.trustStoreLocation;
    }

    private void setTrustStoreLocation(String trustStoreLocation) {
        this.trustStoreLocation = trustStoreLocation;
    }

    private String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    private void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    @Override
    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    private void setTrustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
    }

    private boolean isOAuth2Enabled() {
        return this.oAuth2Enabled;
    }

    private void setOAuth2Enabled(boolean oAuth2Enabled) {
        this.oAuth2Enabled = oAuth2Enabled;
    }

    private boolean isBasicAuthEnabled() {
        return this.basicAuthEnabled;
    }

    private void setBasicAuthEnabled(boolean basicAuthEnabled) {
        this.basicAuthEnabled = basicAuthEnabled;
    }

    private String getBasicAuthUsername() {
        return this.basicAuthUsername;
    }

    private void setBasicAuthUsername(String basicAuthUsername) {
        this.basicAuthUsername = basicAuthUsername;
    }

    private String getBasicAuthPassword() {
        return this.basicAuthPassword;
    }

    private void setBasicAuthPassword(String basicAuthPassword) {
        this.basicAuthPassword = basicAuthPassword;
    }

    private boolean isClientAuthEnabled() {
        return this.clientAuthEnabled;
    }

    private void setClientAuthEnabled(boolean clientAuthEnabled) {
        this.clientAuthEnabled = clientAuthEnabled;
    }

    private KeyStore getKeyStore() {
        return this.keyStore;
    }

    private void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStoreLocation() {
        return this.keyStoreLocation;
    }

    public void setKeyStoreLocation(String keyStoreLocation) {
        this.keyStoreLocation = keyStoreLocation;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStoreKeyPassword() {
        return this.keyStoreKeyPassword;
    }

    public void setKeyStoreKeyPassword(String keyStoreKeyPassword) {
        this.keyStoreKeyPassword = keyStoreKeyPassword;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    public boolean isHostnameVerificationEnabled() {
        return this.hostnameVerificationEnabled;
    }

    public void setHostnameVerificationEnabled(boolean hostnameVerficationEnabled) {
        this.hostnameVerificationEnabled = hostnameVerficationEnabled;
    }

    public int getHttpTimeout() {
        return this.httpTimeout;
    }

    public void setHttpTimeout(int httpTimeout) {
        this.httpTimeout = httpTimeout;
    }

    public HTTPReturnPreference getHttpReturnPref() {
        return this.httpReturnPref;
    }

    public void setHttpReturnPref(HTTPReturnPreference returnPref) {
        this.httpReturnPref = returnPref;
    }

    @Override
    public String getTenantId() {
        return this.tenantId == null ? "default" : this.tenantId;
    }

    public static class LF
    implements LogEventSender {
        public void send(LogEvent event) {
            String msg = LogMessageFormatter.format((LogEvent)event);
            String id = "ID: " + event.getExchangeId();
            System.err.println(id + " " + msg);
        }
    }
}

