/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.client.impl;

import com.ibm.fhir.client.FHIRResponse;
import com.ibm.fhir.model.resource.Resource;
import jakarta.json.JsonObject;
import java.net.URI;
import java.time.Instant;
import java.util.Date;
import javax.ws.rs.core.Response;

public class FHIRResponseImpl
implements FHIRResponse {
    private Response response;

    protected FHIRResponseImpl() {
    }

    public FHIRResponseImpl(Response response) {
        this.response = response;
    }

    @Override
    public int getStatus() {
        return this.response.getStatus();
    }

    @Override
    public URI getLocationURI() throws Exception {
        String s;
        URI location = this.response.getLocation();
        if (location == null && (s = this.response.getHeaderString("Content-Location")) != null && !s.isEmpty()) {
            location = new URI(s);
        }
        return location;
    }

    @Override
    public String getLocation() throws Exception {
        URI location = this.response.getLocation();
        return location != null ? location.toString() : null;
    }

    @Override
    public Instant getLastModified() throws Exception {
        Instant lastModified = null;
        Date s = this.response.getLastModified();
        if (s != null) {
            lastModified = s.toInstant();
        }
        return lastModified;
    }

    @Override
    public String getETag() throws Exception {
        return this.response.getHeaderString("ETag");
    }

    @Override
    public <T> T getResource(Class<T> type) throws Exception {
        if (Resource.class.isAssignableFrom(type) || JsonObject.class.equals(type)) {
            return (T)this.response.readEntity(type);
        }
        throw new IllegalArgumentException("The 'type' parameter must be either '" + JsonObject.class.getName() + ".class' or a class derived from '" + Resource.class.getName() + ".class'.");
    }

    @Override
    public Response getResponse() throws Exception {
        return this.response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String[] parseLocation(String location) throws Exception {
        String[] result = null;
        if (location == null) {
            throw new NullPointerException("The 'location' parameter was specified as null.");
        }
        String[] tokens = location.split("/");
        if (location.contains("_history")) {
            if (tokens.length < 4) throw new IllegalArgumentException("Incorrect location value specified: " + location);
            result = new String[]{tokens[tokens.length - 4], tokens[tokens.length - 3], tokens[tokens.length - 1]};
            return result;
        } else {
            if (tokens.length < 2) throw new IllegalArgumentException("Incorrect location value specified: " + location);
            result = new String[]{tokens[tokens.length - 2], tokens[tokens.length - 1]};
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        String contentLengthStr = this.response.getHeaderString("Content-Length");
        int contentLength = -1;
        if (contentLengthStr != null && !contentLengthStr.isEmpty()) {
            contentLength = Integer.valueOf(contentLengthStr);
        }
        return !this.response.hasEntity() || contentLength == 0;
    }
}

