/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.config;

import com.ibm.fhir.config.PropertyGroup;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringSubstitutor;

public class ConfigurationService {
    private static final JsonReaderFactory JSON_READER_FACTORY = Json.createReaderFactory(null);
    public static final String PROPERTY_GROUP_CLASSNAME = "com.ibm.fhir.config.PROPERTY_GROUP_ClASSNAME";

    public static PropertyGroup loadConfiguration(String filename) throws Exception {
        try (InputStream is = ConfigurationService.resolveFile(filename);){
            PropertyGroup propertyGroup = ConfigurationService.loadConfiguration(is);
            return propertyGroup;
        }
    }

    public static PropertyGroup loadConfiguration(InputStream is) throws Exception {
        String templatedJson = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        String resolvedJson = StringSubstitutor.replace((Object)templatedJson, EnvironmentVariables.get());
        try (JsonReader reader = JSON_READER_FACTORY.createReader((Reader)new StringReader(resolvedJson));){
            JsonObject jsonObj = reader.readObject();
            reader.close();
            PropertyGroup propertyGroup = ConfigurationService.instantiatePropertyGroup(jsonObj);
            return propertyGroup;
        }
    }

    private static PropertyGroup instantiatePropertyGroup(JsonObject jsonObj) throws Exception {
        try {
            Constructor ctor;
            Class clazz = PropertyGroup.class;
            String className = System.getProperty(PROPERTY_GROUP_CLASSNAME);
            if (className != null && !className.isEmpty()) {
                Class<PropertyGroup> c = Class.forName(className);
                if (c.isAssignableFrom(PropertyGroup.class)) {
                    throw new IllegalArgumentException("Class '" + className + "' is not a subclass of PropertyGroup");
                }
                clazz = c;
            }
            if ((ctor = clazz.getConstructor(JsonObject.class)) == null) {
                throw new IllegalArgumentException("Could not retrieve required constructor from class '" + className + "'");
            }
            return (PropertyGroup)ctor.newInstance(jsonObj);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Invalid class specified for PROPERTY_GROUP_CLASSNAME property.", t);
        }
    }

    private static InputStream resolveFile(String filename) throws FileNotFoundException {
        File f = new File(filename);
        if (f.exists()) {
            return new FileInputStream(f);
        }
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        if (is != null) {
            return is;
        }
        throw new FileNotFoundException("File '" + filename + "' was not found.");
    }

    public static class EnvironmentVariables {
        public static Map<String, String> get() {
            return System.getenv();
        }
    }
}

