/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.config;

import com.ibm.fhir.config.FHIRConfiguration;
import com.ibm.fhir.config.FHIRRequestContext;
import com.ibm.fhir.config.PropertyGroup;
import com.ibm.fhir.config.ResourcesConfigAdapter;
import jakarta.json.JsonValue;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FHIRConfigHelper {
    private static final Logger log = Logger.getLogger(FHIRConfigHelper.class.getName());
    public static final String SEARCH_PROPERTY_TYPE_INCLUDE = "_include";
    public static final String SEARCH_PROPERTY_TYPE_REVINCLUDE = "_revinclude";
    public static final String RESOURCE_RESOURCE = "Resource";

    public static String getStringProperty(String propertyName, String defaultValue) {
        return FHIRConfigHelper.getTypedProperty(String.class, propertyName, defaultValue);
    }

    public static Boolean getBooleanProperty(String propertyName, Boolean defaultValue) {
        return FHIRConfigHelper.getTypedProperty(Boolean.class, propertyName, defaultValue);
    }

    public static Integer getIntProperty(String propertyName, Integer defaultValue) {
        return FHIRConfigHelper.getTypedProperty(Integer.class, propertyName, defaultValue);
    }

    public static Double getDoubleProperty(String propertyName, Double defaultValue) {
        return FHIRConfigHelper.getTypedProperty(Double.class, propertyName, defaultValue);
    }

    public static List<String> getStringListProperty(String propertyName) {
        return FHIRConfigHelper.getTypedProperty(List.class, propertyName, null);
    }

    public static PropertyGroup getPropertyGroup(String propertyName) {
        return FHIRConfigHelper.getTypedProperty(PropertyGroup.class, propertyName, null);
    }

    private static JsonValue getPropertyFromTenantOrDefault(String propertyName) {
        JsonValue result = null;
        PropertyGroup pg = null;
        String tenantId = FHIRRequestContext.get().getTenantId();
        try {
            pg = FHIRConfiguration.getInstance().loadConfigurationForTenant(tenantId);
            if (pg != null) {
                result = pg.getJsonValue(propertyName);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error loading configuration for tenant-id '" + tenantId + "': " + e.getMessage());
        }
        if (result == null && !"default".equals(tenantId)) {
            try {
                if (propertyName.startsWith("fhirServer/persistence/datasources") || propertyName.startsWith("fhirServer/persistence/payload")) {
                    result = null;
                } else {
                    pg = FHIRConfiguration.getInstance().loadConfiguration();
                    if (pg != null) {
                        result = pg.getJsonValue(propertyName);
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error loading default configuration: " + e.getMessage());
            }
        }
        return result;
    }

    private static <T> T getTypedProperty(Class<T> expectedDataType, String propertyName, T defaultValue) {
        Object result;
        block10: {
            result = null;
            JsonValue jsonValue = FHIRConfigHelper.getPropertyFromTenantOrDefault(propertyName);
            if (jsonValue != null) {
                Object obj = null;
                try {
                    obj = PropertyGroup.convertJsonValue(jsonValue);
                    if (obj == null) break block10;
                    if (expectedDataType.isAssignableFrom(obj.getClass())) {
                        result = obj;
                        break block10;
                    }
                    if (obj instanceof String) {
                        if (Boolean.class.equals(expectedDataType)) {
                            result = Boolean.valueOf((String)obj);
                            break block10;
                        }
                        if (Integer.class.equals(expectedDataType)) {
                            result = Integer.valueOf((String)obj);
                            break block10;
                        }
                        if (Double.class.equals(expectedDataType)) {
                            result = Double.valueOf((String)obj);
                            break block10;
                        }
                        throw new RuntimeException("Expected property " + propertyName + " to be of type " + expectedDataType.getName() + ", but was of type " + obj.getClass().getName());
                    }
                    if (obj instanceof Boolean) {
                        if (String.class.equals(expectedDataType)) {
                            result = ((Boolean)obj).toString();
                            break block10;
                        }
                        throw new RuntimeException("Expected property " + propertyName + " to be of type " + expectedDataType.getName() + ", but was of type " + obj.getClass().getName());
                    }
                    throw new RuntimeException("Expected property " + propertyName + " to be of type " + expectedDataType.getName() + ", but was of type " + obj.getClass().getName());
                }
                catch (Exception e) {
                    throw new RuntimeException("Unexpected error converting property '" + propertyName + "' to native type.", e);
                }
            }
        }
        return (T)(result != null ? result : (Object)defaultValue);
    }

    public static Set<String> getSupportedResourceTypes() {
        PropertyGroup rsrcsGroup = FHIRConfigHelper.getPropertyGroup("fhirServer/resources");
        try {
            ResourcesConfigAdapter configAdapter = new ResourcesConfigAdapter(rsrcsGroup);
            return configAdapter.getSupportedResourceTypes();
        }
        catch (Exception e) {
            log.throwing(FHIRConfigHelper.class.getName(), "getSupportedResourceTypes", e);
            throw new IllegalStateException(e);
        }
    }

    public static List<String> getSearchPropertyRestrictions(String resourceType, String propertyType) throws Exception {
        List<PropertyGroup.PropertyEntry> rsrcsEntries;
        PropertyGroup rsrcsGroup;
        String propertyField = null;
        if (SEARCH_PROPERTY_TYPE_INCLUDE.equals(propertyType)) {
            propertyField = "searchIncludes";
        } else if (SEARCH_PROPERTY_TYPE_REVINCLUDE.equals(propertyType)) {
            propertyField = "searchRevIncludes";
        }
        if (propertyField != null && (rsrcsGroup = FHIRConfigHelper.getPropertyGroup("fhirServer/resources")) != null && (rsrcsEntries = rsrcsGroup.getProperties()) != null && !rsrcsEntries.isEmpty()) {
            PropertyGroup resourceTypeGroup;
            for (PropertyGroup.PropertyEntry rsrcsEntry : rsrcsEntries) {
                if (!resourceType.equals(rsrcsEntry.getName()) || (resourceTypeGroup = (PropertyGroup)rsrcsEntry.getValue()) == null) continue;
                return resourceTypeGroup.getStringListProperty(propertyField);
            }
            for (PropertyGroup.PropertyEntry rsrcsEntry : rsrcsEntries) {
                if (!RESOURCE_RESOURCE.equals(rsrcsEntry.getName()) || (resourceTypeGroup = (PropertyGroup)rsrcsEntry.getValue()) == null) continue;
                return resourceTypeGroup.getStringListProperty(propertyField);
            }
        }
        return null;
    }
}

