/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.config;

import com.ibm.fhir.config.PropertyGroup;
import com.ibm.fhir.config.TenantSpecificPropertyGroupCache;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class FHIRConfiguration {
    private static final Logger log = Logger.getLogger(FHIRConfiguration.class.getName());
    public static final String CONFIG_LOCATION = "config";
    public static final String CONFIG_FILE_BASENAME = "fhir-server-config.json";
    public static final String DEFAULT_TENANT_ID = "default";
    public static final String DEFAULT_DATASTORE_ID = "default";
    public static final String PROPERTY_ORIGINAL_REQUEST_URI_HEADER_NAME = "fhirServer/core/originalRequestUriHeaderName";
    public static final String PROPERTY_TENANT_ID_HEADER_NAME = "fhirServer/core/tenantIdHeaderName";
    public static final String PROPERTY_DATASTORE_ID_HEADER_NAME = "fhirServer/core/datastoreIdHeaderName";
    public static final String PROPERTY_DEFAULT_TENANT_ID = "fhirServer/core/defaultTenantId";
    public static final String PROPERTY_DEFAULT_PRETTY_PRINT = "fhirServer/core/defaultPrettyPrint";
    public static final String PROPERTY_DEFAULT_HANDLING = "fhirServer/core/defaultHandling";
    public static final String PROPERTY_ALLOW_CLIENT_HANDLING_PREF = "fhirServer/core/allowClientHandlingPref";
    public static final String PROPERTY_CHECK_REFERENCE_TYPES = "fhirServer/core/checkReferenceTypes";
    public static final String PROPERTY_CHECK_CONTROL_CHARS = "fhirServer/core/checkControlCharacters";
    public static final String PROPERTY_CONDITIONAL_DELETE_MAX_NUMBER = "fhirServer/core/conditionalDeleteMaxNumber";
    public static final String PROPERTY_IF_NONE_MATCH_RETURNS_NOT_MODIFIED = "fhirServer/core/ifNoneMatchReturnsNotModified";
    public static final String PROPERTY_SERVER_REGISTRY_RESOURCE_PROVIDER_ENABLED = "fhirServer/core/serverRegistryResourceProviderEnabled";
    public static final String PROPERTY_SERVER_RESOLVE_FUNCTION_ENABLED = "fhirServer/core/serverResolveFunctionEnabled";
    public static final String PROPERTY_CAPABILITY_STATEMENT_CACHE = "fhirServer/core/capabilityStatementCacheTimeout";
    public static final String PROPERTY_EXTENDED_CODEABLE_CONCEPT_VALIDATION = "fhirServer/core/extendedCodeableConceptValidation";
    public static final String PROPERTY_DISABLED_OPERATIONS = "fhirServer/core/disabledOperations";
    public static final String PROPERTY_DEFAULT_PAGE_SIZE = "fhirServer/core/defaultPageSize";
    public static final String PROPERTY_MAX_PAGE_SIZE = "fhirServer/core/maxPageSize";
    public static final String PROPERTY_MAX_PAGE_INCLUDE_COUNT = "fhirServer/core/maxPageIncludeCount";
    public static final String PROPERTY_CAPABILITIES_URL = "fhirServer/core/capabilitiesUrl";
    public static final String PROPERTY_VALIDATION_FAIL_FAST = "fhirServer/validation/failFast";
    public static final String PROPERTY_TERM_SERVICE_CAPABILITIES_URL = "fhirServer/term/capabilitiesUrl";
    public static final String PROPERTY_GRAPH_TERM_SERVICE_PROVIDER_ENABLED = "fhirServer/term/graphTermServiceProvider/enabled";
    public static final String PROPERTY_GRAPH_TERM_SERVICE_PROVIDER_TIME_LIMIT = "fhirServer/term/graphTermServiceProvider/timeLimit";
    public static final String PROPERTY_GRAPH_TERM_SERVICE_PROVIDER_CONFIGURATION = "fhirServer/term/graphTermServiceProvider/configuration";
    public static final String PROPERTY_RESOURCES = "fhirServer/resources";
    public static final String PROPERTY_FIELD_RESOURCES_OPEN = "open";
    public static final String PROPERTY_FIELD_RESOURCES_INTERACTIONS = "interactions";
    public static final String PROPERTY_FIELD_RESOURCES_SEARCH_PARAMETERS = "searchParameters";
    public static final String PROPERTY_FIELD_RESOURCES_SEARCH_INCLUDES = "searchIncludes";
    public static final String PROPERTY_FIELD_RESOURCES_SEARCH_REV_INCLUDES = "searchRevIncludes";
    public static final String PROPERTY_FIELD_RESOURCES_SEARCH_PARAMETER_COMBINATIONS = "searchParameterCombinations";
    public static final String PROPERTY_FIELD_RESOURCES_PROFILES = "profiles";
    public static final String PROPERTY_FIELD_RESOURCES_PROFILES_AT_LEAST_ONE = "atLeastOne";
    public static final String PROPERTY_FIELD_RESOURCES_PROFILES_NOT_ALLOWED = "notAllowed";
    public static final String PROPERTY_FIELD_RESOURCES_PROFILES_ALLOW_UNKNOWN = "allowUnknown";
    public static final String PROPERTY_FIELD_RESOURCES_PROFILES_DEFAULT_VERSIONS = "defaultVersions";
    public static final String PROPERTY_SECURITY_CORS = "fhirServer/security/cors";
    public static final String PROPERTY_SECURITY_BASIC_ENABLED = "fhirServer/security/basic/enabled";
    public static final String PROPERTY_SECURITY_CERT_ENABLED = "fhirServer/security/certificates/enabled";
    public static final String PROPERTY_SECURITY_OAUTH_ENABLED = "fhirServer/security/oauth/enabled";
    public static final String PROPERTY_SECURITY_OAUTH_REG_URL = "fhirServer/security/oauth/regUrl";
    public static final String PROPERTY_SECURITY_OAUTH_AUTH_URL = "fhirServer/security/oauth/authUrl";
    public static final String PROPERTY_SECURITY_OAUTH_TOKEN_URL = "fhirServer/security/oauth/tokenUrl";
    public static final String PROPERTY_SECURITY_OAUTH_MANAGE_URL = "fhirServer/security/oauth/manageUrl";
    public static final String PROPERTY_SECURITY_OAUTH_INTROSPECT_URL = "fhirServer/security/oauth/introspectUrl";
    public static final String PROPERTY_SECURITY_OAUTH_REVOKE_URL = "fhirServer/security/oauth/smart/revokeUrl";
    public static final String PROPERTY_SECURITY_OAUTH_SMART_ENABLED = "fhirServer/security/oauth/smart/enabled";
    public static final String PROPERTY_SECURITY_OAUTH_SMART_SCOPES = "fhirServer/security/oauth/smart/scopes";
    public static final String PROPERTY_SECURITY_OAUTH_SMART_CAPABILITIES = "fhirServer/security/oauth/smart/capabilities";
    public static final String PROPERTY_AUDIT_SERVICE_CLASS_NAME = "fhirServer/audit/serviceClassName";
    public static final String PROPERTY_AUDIT_SERVICE_PROPERTIES = "fhirServer/audit/serviceProperties";
    public static final String PROPERTY_AUDIT_PATIENT_ID_EXTURL = "fhirServer/audit/patientIdExtensionUrl";
    public static final String PROPERTY_AUDIT_HOSTNAME = "fhirServer/audit/hostname";
    public static final String PROPERTY_AUDIT_IP = "fhirServer/audit/ip";
    public static final String PROPERTY_NOTIFICATION_RESOURCE_TYPES = "fhirServer/notifications/common/includeResourceTypes";
    public static final String PROPERTY_NOTIFICATION_NOTIFICATION_SIZE_BEHAVIOR = "fhirServer/notifications/common/maxNotificationSizeBehavior";
    public static final String PROPERTY_NOTIFICATION_MAX_SIZE = "fhirServer/notifications/common/maxNotificationSizeBytes";
    public static final String PROPERTY_WEBSOCKET_ENABLED = "fhirServer/notifications/websocket/enabled";
    public static final String PROPERTY_KAFKA_ENABLED = "fhirServer/notifications/kafka/enabled";
    public static final String PROPERTY_KAFKA_TOPICNAME = "fhirServer/notifications/kafka/topicName";
    public static final String PROPERTY_KAFKA_CONNECTIONPROPS = "fhirServer/notifications/kafka/connectionProperties";
    public static final String PROPERTY_KAFKA_SYNC = "fhirServer/notifications/kafka/sync";
    public static final String PROPERTY_NATS_ENABLED = "fhirServer/notifications/nats/enabled";
    public static final String PROPERTY_NATS_CLUSTER = "fhirServer/notifications/nats/cluster";
    public static final String PROPERTY_NATS_CHANNEL = "fhirServer/notifications/nats/channel";
    public static final String PROPERTY_NATS_CLIENT = "fhirServer/notifications/nats/client";
    public static final String PROPERTY_NATS_SERVERS = "fhirServer/notifications/nats/servers";
    public static final String PROPERTY_NATS_TLS_ENABLED = "fhirServer/notifications/nats/useTLS";
    public static final String PROPERTY_NATS_TRUSTSTORE = "fhirServer/notifications/nats/truststoreLocation";
    public static final String PROPERTY_NATS_TRUSTSTORE_PW = "fhirServer/notifications/nats/truststorePassword";
    public static final String PROPERTY_NATS_KEYSTORE = "fhirServer/notifications/nats/keystoreLocation";
    public static final String PROPERTY_NATS_KEYSTORE_PW = "fhirServer/notifications/nats/keystorePassword";
    public static final String PROPERTY_OPERATIONS_EVERYTHING = "fhirServer/operations/everything";
    public static final String PROPERTY_OPERATIONS_EVERYTHING_INCLUDE_TYPES = "includeTypes";
    public static final String PROPERTY_UPDATE_CREATE_ENABLED = "fhirServer/persistence/common/updateCreateEnabled";
    public static final String PROPERTY_PERSISTENCE_FACTORY = "fhirServer/persistence/factoryClassname";
    public static final String PROPERTY_DATASOURCES = "fhirServer/persistence/datasources";
    public static final String PROPERTY_JDBC_ENABLE_READ_ONLY_REPLICAS = "fhirServer/persistence/jdbc/enableReadOnlyReplicas";
    public static final String PROPERTY_PERSISTENCE_PAYLOAD = "fhirServer/persistence/payload";
    public static final String PROPERTY_JDBC_SEARCH_OPTIMIZER_OPTIONS = "searchOptimizerOptions";
    public static final String PROPERTY_SEARCH_BOUNDING_AREA_RADIUS_TYPE = "fhirServer/search/useBoundingRadius";
    @Deprecated
    public static final String PROPERTY_SEARCH_ENABLE_LEGACY_WHOLE_SYSTEM_SEARCH_PARAMS = "fhirServer/search/enableLegacyWholeSystemSearchParams";
    public static final String DEFAULT_TENANT_ID_HEADER_NAME = "X-FHIR-TENANT-ID";
    public static final String DEFAULT_DATASTORE_ID_HEADER_NAME = "X-FHIR-DSID";
    public static final String DEFAULT_PRETTY_RESPONSE_HEADER_NAME = "X-FHIR-FORMATTED";
    public static final String FHIR_SERVER_DEFAULT_CONFIG = "config/default/fhir-server-config.json";
    private static String configHome = "";
    private static FHIRConfiguration _instance = new FHIRConfiguration();
    private TenantSpecificPropertyGroupCache configCache = new TenantSpecificPropertyGroupCache();

    public static FHIRConfiguration getInstance() {
        return _instance;
    }

    public static void setConfigHome(String s) {
        if (s == null) {
            s = "";
        }
        if (!((String)s).isEmpty() && !((String)s).endsWith(File.separator)) {
            s = (String)s + File.separator;
        }
        configHome = s;
    }

    public static String getConfigHome() {
        return configHome;
    }

    public PropertyGroup loadConfiguration() throws Exception {
        return this.loadConfigurationForTenant("default");
    }

    public PropertyGroup loadConfigurationForTenant(String tenantId) throws Exception {
        return (PropertyGroup)this.configCache.getCachedObjectForTenant(tenantId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearConfiguration() {
        TenantSpecificPropertyGroupCache tenantSpecificPropertyGroupCache = this.configCache;
        synchronized (tenantSpecificPropertyGroupCache) {
            this.configCache.clearCache();
        }
    }

    public List<String> getConfiguredTenants() {
        ArrayList<String> result = new ArrayList<String>();
        File configDir = new File(FHIRConfiguration.getConfigHome() + CONFIG_LOCATION);
        log.fine("Listing tenant id's rooted at directory: " + configDir.getName());
        File[] files = configDir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.isDirectory()) continue;
                result.add(f.getName());
            }
        }
        log.fine("Returning list of tenant ids: " + ((Object)result).toString());
        return result;
    }
}

