/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.config;

import com.ibm.fhir.core.HTTPHandlingPreference;
import com.ibm.fhir.core.HTTPReturnPreference;
import com.ibm.fhir.exception.FHIRException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FHIRRequestContext {
    private static final Logger log = Logger.getLogger(FHIRRequestContext.class.getName());
    private String tenantId;
    private String dataStoreId;
    private String requestUniqueId;
    private String originalRequestUri;
    private Map<String, List<String>> httpHeaders;
    private boolean readOnly;
    private boolean bulk = false;
    private HTTPHandlingPreference handlingPreference = HTTPHandlingPreference.STRICT;
    private HTTPReturnPreference returnPreference = HTTPReturnPreference.MINIMAL;
    private boolean returnPreferenceDefault;
    private Map<String, Object> operationProperties = new HashMap<String, Object>();
    private Pattern validChars = Pattern.compile("[a-zA-Z0-9_\\-]+");
    private String errorMsg = "Only [a-z], [A-Z], [0-9], '_', and '-' characters are allowed.";
    private static ThreadLocal<FHIRRequestContext> contexts = new ThreadLocal<FHIRRequestContext>(){

        @Override
        public FHIRRequestContext initialValue() {
            try {
                return new FHIRRequestContext("default", "default");
            }
            catch (FHIRException e) {
                throw new IllegalStateException("Unexpected error while initializing FHIRRequestContext");
            }
        }
    };

    public FHIRRequestContext() {
        this.requestUniqueId = UUID.randomUUID().toString();
    }

    public FHIRRequestContext(String tenantId) throws FHIRException {
        this();
        this.setTenantId(tenantId);
    }

    public FHIRRequestContext(String tenantId, String dataStoreId) throws FHIRException {
        this(tenantId);
        this.setDataStoreId(dataStoreId);
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean flag) {
        this.readOnly = flag;
    }

    public boolean isBulk() {
        return this.bulk;
    }

    public void setBulk(boolean bulk) {
        this.bulk = bulk;
    }

    public void setTenantId(String tenantId) throws FHIRException {
        Matcher matcher = this.validChars.matcher(tenantId);
        if (!matcher.matches()) {
            throw new FHIRException("Invalid tenantId. " + this.errorMsg);
        }
        this.tenantId = tenantId;
    }

    public String getDataStoreId() {
        return this.dataStoreId;
    }

    public void setDataStoreId(String dataStoreId) throws FHIRException {
        Matcher matcher = this.validChars.matcher(dataStoreId);
        if (!matcher.matches()) {
            throw new FHIRException("Invalid dataStoreId. " + this.errorMsg);
        }
        this.dataStoreId = dataStoreId;
    }

    public void setExtendedOperationProperties(String name, Object value) {
        this.operationProperties.put(name, value);
    }

    public Object getExtendedOperationProperties(String name) {
        return this.operationProperties.get(name);
    }

    public static void set(FHIRRequestContext context) {
        Objects.requireNonNull(context);
        contexts.set(context);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("FHIRRequestContext.set: " + context.toString());
        }
    }

    public static FHIRRequestContext get() {
        FHIRRequestContext result = contexts.get();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("FHIRRequestContext.get: " + result.toString());
        }
        return result;
    }

    public static void remove() {
        contexts.remove();
        log.finest("FHIRRequestContext.remove invoked.");
    }

    public String toString() {
        return "FHIRRequestContext [tenantId=" + this.tenantId + ", dataStoreId=" + this.dataStoreId + ", this=" + FHIRRequestContext.objectHandle(this) + "]";
    }

    public String getRequestUniqueId() {
        return this.requestUniqueId;
    }

    private static String objectHandle(Object obj) {
        return "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    public HTTPHandlingPreference getHandlingPreference() {
        return this.handlingPreference;
    }

    public void setHandlingPreference(HTTPHandlingPreference handlingPreference) {
        this.handlingPreference = handlingPreference;
    }

    public HTTPReturnPreference getReturnPreference() {
        return this.returnPreference;
    }

    public void setReturnPreference(HTTPReturnPreference returnPreference) {
        this.returnPreference = returnPreference;
    }

    public String getOriginalRequestUri() {
        return this.originalRequestUri;
    }

    public void setOriginalRequestUri(String originalRequestUri) {
        this.originalRequestUri = originalRequestUri;
    }

    public Map<String, List<String>> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Map<String, List<String>> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public boolean isReturnPreferenceDefault() {
        return this.returnPreferenceDefault;
    }

    public void setReturnPreferenceDefault(boolean returnPreferenceIsDefault) {
        this.returnPreferenceDefault = returnPreferenceIsDefault;
    }
}

