/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.config;

import com.ibm.fhir.core.FHIRUtilities;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PropertyGroup {
    public static final String PATH_ELEMENT_SEPARATOR = "/";
    protected JsonObject jsonObj;

    public PropertyGroup(JsonObject jsonObj) {
        this.jsonObj = jsonObj;
    }

    public JsonObject getJsonObj() {
        return this.jsonObj;
    }

    protected void setJsonObj(JsonObject jsonObj) {
        this.jsonObj = jsonObj;
    }

    public PropertyGroup getPropertyGroup(String propertyName) {
        PropertyGroup result = null;
        JsonValue jsonValue = this.getJsonValue(propertyName);
        if (jsonValue != null) {
            if (jsonValue instanceof JsonObject) {
                result = new PropertyGroup((JsonObject)jsonValue);
            } else {
                throw new IllegalArgumentException("Property '" + propertyName + "' must be of type object (JsonObject)");
            }
        }
        return result;
    }

    public String getStringProperty(String propertyName) throws Exception {
        return this.getStringProperty(propertyName, null);
    }

    public String getStringProperty(String propertyName, String defaultValue) throws Exception {
        String result = defaultValue;
        JsonValue jsonValue = this.getJsonValue(propertyName);
        if (jsonValue != null) {
            if (jsonValue instanceof JsonString) {
                result = FHIRUtilities.decode((String)((JsonString)jsonValue).getString());
            } else {
                throw new IllegalArgumentException("Property '" + propertyName + "' must be of type String");
            }
        }
        return result;
    }

    public List<String> getStringListProperty(String propertyName) {
        Object[] array = this.getArrayProperty(propertyName);
        ArrayList<String> strings = null;
        if (array != null) {
            strings = new ArrayList<String>();
            for (int i = 0; i < array.length; ++i) {
                strings.add(array[i].toString());
            }
        }
        return strings;
    }

    public Integer getIntProperty(String propertyName) {
        return this.getIntProperty(propertyName, null);
    }

    public Integer getIntProperty(String propertyName, Integer defaultValue) {
        Integer result = defaultValue;
        JsonValue jsonValue = this.getJsonValue(propertyName);
        if (jsonValue != null) {
            if (jsonValue instanceof JsonNumber) {
                result = ((JsonNumber)jsonValue).intValue();
            } else {
                throw new IllegalArgumentException("Property '" + propertyName + "' must be of type int");
            }
        }
        return result;
    }

    public Double getDoubleProperty(String propertyName) {
        return this.getDoubleProperty(propertyName, null);
    }

    public Double getDoubleProperty(String propertyName, Double defaultValue) {
        Double result = defaultValue;
        JsonValue jsonValue = this.getJsonValue(propertyName);
        if (jsonValue != null) {
            if (jsonValue instanceof JsonNumber) {
                result = ((JsonNumber)jsonValue).doubleValue();
            } else {
                throw new IllegalArgumentException("Property '" + propertyName + "' must be of type double");
            }
        }
        return result;
    }

    public Boolean getBooleanProperty(String propertyName) {
        return this.getBooleanProperty(propertyName, null);
    }

    public Boolean getBooleanProperty(String propertyName, Boolean defaultValue) {
        Boolean result = defaultValue;
        JsonValue jsonValue = this.getJsonValue(propertyName);
        if (jsonValue != null) {
            if (jsonValue == JsonValue.TRUE || jsonValue == JsonValue.FALSE) {
                result = jsonValue == JsonValue.TRUE;
            } else if (jsonValue instanceof JsonString) {
                result = Boolean.valueOf(((JsonString)jsonValue).getString());
            } else {
                throw new IllegalArgumentException("Property '" + propertyName + "' must be of type boolean or String");
            }
        }
        return result;
    }

    public Object[] getArrayProperty(String propertyName) {
        Object[] result = null;
        JsonValue jsonValue = this.getJsonValue(propertyName);
        if (jsonValue != null) {
            if (jsonValue instanceof JsonArray) {
                result = PropertyGroup.convertJsonArray((JsonArray)jsonValue);
            } else {
                throw new IllegalArgumentException("Property '" + propertyName + "' must be an array");
            }
        }
        return result;
    }

    public List<PropertyEntry> getProperties() {
        ArrayList<PropertyEntry> results = new ArrayList<PropertyEntry>();
        for (Map.Entry entry : this.jsonObj.entrySet()) {
            Object jsonValue = PropertyGroup.convertJsonValue((JsonValue)entry.getValue());
            if (jsonValue == null) continue;
            results.add(new PropertyEntry((String)entry.getKey(), jsonValue));
        }
        return results;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PropertyGroup[");
        sb.append(this.jsonObj != null ? this.jsonObj.toString() : "<empty>");
        sb.append("]");
        return sb.toString();
    }

    public static Object convertJsonValue(JsonValue jsonValue) {
        Object result = null;
        switch (jsonValue.getValueType()) {
            case ARRAY: {
                Object[] objArray = PropertyGroup.convertJsonArray((JsonArray)jsonValue);
                result = Arrays.asList(objArray);
                break;
            }
            case OBJECT: {
                result = new PropertyGroup((JsonObject)jsonValue);
                break;
            }
            case STRING: {
                result = FHIRUtilities.decode((String)((JsonString)jsonValue).getString());
                break;
            }
            case NUMBER: {
                JsonNumber jsonNumber = (JsonNumber)jsonValue;
                if (jsonNumber.isIntegral()) {
                    result = jsonNumber.intValue();
                    break;
                }
                result = jsonNumber.doubleValue();
                break;
            }
            case TRUE: {
                result = Boolean.TRUE;
                break;
            }
            case FALSE: {
                result = Boolean.FALSE;
                break;
            }
            case NULL: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected JSON value type: " + jsonValue.getValueType().name());
            }
        }
        return result;
    }

    private static Object[] convertJsonArray(JsonArray jsonArray) {
        Object[] result = new Object[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            result[i] = PropertyGroup.convertJsonValue((JsonValue)jsonArray.get(i));
        }
        return result;
    }

    public JsonValue getJsonValue(String propertyName) {
        String[] pathElements = this.getPathElements(propertyName);
        JsonObject subGroup = this.getPropertySubGroup(pathElements);
        JsonValue result = null;
        if (subGroup != null) {
            result = (JsonValue)subGroup.get((Object)pathElements[pathElements.length - 1]);
        }
        return result == JsonValue.NULL ? null : result;
    }

    protected String[] getPathElements(String propertyName) {
        return propertyName.split(PATH_ELEMENT_SEPARATOR);
    }

    protected JsonObject getPropertySubGroup(String[] pathElements) {
        if (pathElements != null) {
            JsonObject cursor = this.jsonObj;
            int limit = pathElements.length - 1;
            for (int i = 0; i < limit && (cursor = cursor.getJsonObject(pathElements[i])) != null; ++i) {
            }
            return cursor;
        }
        return null;
    }

    public static class PropertyEntry {
        private String name;
        private Object value;

        public PropertyEntry(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

