/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.config;

import com.ibm.fhir.config.Interaction;
import com.ibm.fhir.config.PropertyGroup;
import com.ibm.fhir.core.ResourceTypeName;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ResourcesConfigAdapter {
    public static final Logger log = Logger.getLogger(ResourcesConfigAdapter.class.getName());
    public static final Set<String> ALL_CONCRETE_TYPES = Arrays.stream(ResourceTypeName.values()).filter(v -> v != ResourceTypeName.RESOURCE && v != ResourceTypeName.DOMAIN_RESOURCE).map(v -> v.value()).collect(Collectors.toSet());
    private final Set<String> supportedTypes;
    private final Map<Interaction, Set<String>> typesByInteraction = new HashMap<Interaction, Set<String>>();
    private boolean isWholeSystemSearchSupported = true;
    private boolean isWholeSystemHistorySupported = true;

    public ResourcesConfigAdapter(PropertyGroup resourcesConfig) {
        this.supportedTypes = this.computeSupportedResourceTypes(resourcesConfig);
        if (resourcesConfig == null) {
            for (Interaction interaction : Interaction.values()) {
                this.typesByInteraction.put(interaction, this.supportedTypes);
            }
            return;
        }
        List<String> defaultResourceInteractions = resourcesConfig.getStringListProperty(ResourceTypeName.RESOURCE.value() + "/interactions");
        if (defaultResourceInteractions != null) {
            this.isWholeSystemSearchSupported = defaultResourceInteractions.contains(Interaction.SEARCH.value());
            this.isWholeSystemHistorySupported = defaultResourceInteractions.contains(Interaction.HISTORY.value());
        }
        for (String resourceType : this.supportedTypes) {
            List<String> interactions = resourcesConfig.getStringListProperty(resourceType + "/interactions");
            if (interactions == null) {
                interactions = defaultResourceInteractions;
            }
            if (interactions == null) {
                for (Interaction interaction : Interaction.values()) {
                    this.typesByInteraction.computeIfAbsent(interaction, k -> new LinkedHashSet()).add(resourceType);
                }
                continue;
            }
            for (String interactionString : interactions) {
                Interaction interaction = Interaction.from(interactionString);
                this.typesByInteraction.computeIfAbsent(interaction, k -> new LinkedHashSet()).add(resourceType);
            }
        }
    }

    public boolean isSearchRestricted() {
        Set<String> searchableResourceTypes = this.typesByInteraction.get((Object)Interaction.SEARCH);
        return searchableResourceTypes == null || searchableResourceTypes.size() < ALL_CONCRETE_TYPES.size();
    }

    public boolean isHistoryRestricted() {
        Set<String> resourceTypesSupportingHistory = this.typesByInteraction.get((Object)Interaction.HISTORY);
        return resourceTypesSupportingHistory == null || resourceTypesSupportingHistory.size() < ALL_CONCRETE_TYPES.size();
    }

    public Set<String> getSupportedResourceTypes() {
        return this.supportedTypes;
    }

    public Set<String> getSupportedResourceTypes(Interaction interaction) {
        Set<String> result = this.typesByInteraction.get((Object)interaction);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    private Set<String> computeSupportedResourceTypes(PropertyGroup resourcesConfig) {
        if (resourcesConfig == null || resourcesConfig.getBooleanProperty("open", true).booleanValue()) {
            return ALL_CONCRETE_TYPES;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (PropertyGroup.PropertyEntry rsrcsEntry : resourcesConfig.getProperties()) {
            String name = rsrcsEntry.getName();
            if ("open".equals(name) || ResourceTypeName.RESOURCE.value().equals(name) || ResourceTypeName.DOMAIN_RESOURCE.value().equals(name)) continue;
            if (ALL_CONCRETE_TYPES.contains(name)) {
                result.add(name);
                continue;
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("Configured resource type '" + name + "' is not valid.");
        }
        return Collections.unmodifiableSet(result);
    }

    public boolean isWholeSystemSearchSupported() {
        return this.isWholeSystemSearchSupported;
    }

    public boolean isWholeSystemHistorySupported() {
        return this.isWholeSystemHistorySupported;
    }
}

