/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.config;

public class SystemConfigHelper {
    public static long convertToSeconds(String duration) {
        if (duration == null || duration.isEmpty()) {
            throw new IllegalArgumentException("Invalid duration - is empty");
        }
        long result = 0L;
        int start = 0;
        for (int idx = 0; idx < duration.length(); ++idx) {
            Integer value;
            String valueStr;
            int mult;
            switch (duration.charAt(idx)) {
                case 'H': 
                case 'h': {
                    mult = 3600;
                    break;
                }
                case 'M': 
                case 'm': {
                    mult = 60;
                    break;
                }
                case 'S': 
                case 's': {
                    mult = 1;
                    break;
                }
                default: {
                    mult = 0;
                }
            }
            if (mult > 0) {
                if (idx == start) {
                    throw new IllegalArgumentException("Invalid duration - no value before value type");
                }
                valueStr = duration.substring(start, idx);
                value = Integer.parseInt(valueStr);
                result += (long)(value * mult);
                start = idx + 1;
                continue;
            }
            if (idx != duration.length() - 1) continue;
            valueStr = duration.substring(start);
            value = Integer.parseInt(valueStr);
            result += (long)value.intValue();
        }
        return result;
    }

    public static long getDurationFromEnv(String envVariable, String defaultValue) {
        String valueStr = System.getenv(envVariable);
        if (valueStr == null || valueStr.isEmpty()) {
            valueStr = defaultValue;
        }
        if (valueStr == null || valueStr.isEmpty()) {
            return -1L;
        }
        return SystemConfigHelper.convertToSeconds(valueStr);
    }
}

